/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.reference;

import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.exchange.WrappedStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Comparators {
    public static final Comparator<Collection<ItemStack>> ITEM_STACK_COLLECTION_COMPARATOR = new Comparator<Collection<ItemStack>>(){

        @Override
        public int compare(Collection<ItemStack> o1, Collection<ItemStack> o2) {
            if (o1 != null && o2 != null) {
                if (o1.size() == o2.size()) {
                    if (o1.containsAll(o2)) {
                        if (o2.containsAll(o1)) {
                            return 0;
                        }
                        return 1;
                    }
                    return -1;
                }
                return o1.size() - o2.size();
            }
            if (o1 != null) {
                return -1;
            }
            if (o2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Set<WrappedStack>> WRAPPED_STACK_SET_COMPARATOR = new Comparator<Set<WrappedStack>>(){

        @Override
        public int compare(Set<WrappedStack> collection1, Set<WrappedStack> collection2) {
            if (collection1 != null && collection2 != null) {
                if (collection1.size() == collection2.size()) {
                    if (collection1.containsAll(collection2)) {
                        if (collection2.containsAll(collection1)) {
                            return 0;
                        }
                        return 1;
                    }
                    return -1;
                }
                return collection1.size() - collection2.size();
            }
            if (collection1 != null) {
                return -1;
            }
            if (collection2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<String> STRING_COMPARATOR = String::compareToIgnoreCase;
    public static final Comparator<ItemStack> ID_COMPARATOR = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (itemStack1.func_77973_b() != null && itemStack2.func_77973_b() != null) {
                    if (Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b()) == 0) {
                        if (itemStack1.func_77973_b() == itemStack2.func_77973_b()) {
                            if (itemStack1.func_77960_j() == itemStack2.func_77960_j() || itemStack1.func_77960_j() == Short.MAX_VALUE || itemStack2.func_77960_j() == Short.MAX_VALUE) {
                                if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                                    if (ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                                        return itemStack1.field_77994_a - itemStack2.field_77994_a;
                                    }
                                    return itemStack1.func_77978_p().hashCode() - itemStack2.func_77978_p().hashCode();
                                }
                                if (!itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                                    return -1;
                                }
                                if (itemStack1.func_77942_o() && !itemStack2.func_77942_o()) {
                                    return 1;
                                }
                                return itemStack1.field_77994_a - itemStack2.field_77994_a;
                            }
                            return itemStack1.func_77960_j() - itemStack2.func_77960_j();
                        }
                        return itemStack1.func_77973_b().func_77667_c(itemStack1).compareToIgnoreCase(itemStack2.func_77973_b().func_77667_c(itemStack2));
                    }
                    return Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b());
                }
                if (itemStack1.func_77973_b() != null) {
                    return -1;
                }
                if (itemStack2.func_77973_b() != null) {
                    return 1;
                }
                return 0;
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ItemStack> DISPLAY_NAME_COMPARATOR = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (itemStack1.func_82833_r().equalsIgnoreCase(itemStack2.func_82833_r())) {
                    return ID_COMPARATOR.compare(itemStack1, itemStack2);
                }
                return itemStack1.func_82833_r().compareToIgnoreCase(itemStack2.func_82833_r());
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ItemStack> ENERGY_VALUE_ITEM_STACK_COMPARATOR = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (EnergyValueRegistryProxy.hasEnergyValue(itemStack1) && EnergyValueRegistryProxy.hasEnergyValue(itemStack2)) {
                    return Float.compare(EnergyValueRegistryProxy.getEnergyValue(itemStack1).getValue(), EnergyValueRegistryProxy.getEnergyValue(itemStack2).getValue());
                }
                return ID_COMPARATOR.compare(itemStack1, itemStack2);
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };
}

