/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.knowledge;

import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.api.blacklist.BlacklistRegistryProxy;
import com.pahimar.ee3.handler.ConfigurationHandler;
import com.pahimar.ee3.knowledge.PlayerKnowledge;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.reference.Files;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PlayerKnowledgeRegistry {
    public static final PlayerKnowledgeRegistry INSTANCE = new PlayerKnowledgeRegistry();
    private final TreeMap<String, PlayerKnowledge> playerKnowledgeMap = new TreeMap(Comparators.STRING_COMPARATOR);
    private final PlayerKnowledge templatePlayerKnowledge = new PlayerKnowledge();
    public static File templatePlayerKnowledgeFile;
    public static final Marker PLAYER_KNOWLEDGE_MARKER;
    public static final Marker PLAYER_LEARN_KNOWLEDGE;
    public static final Marker PLAYER_FORGET_KNOWLEDGE_MARKER;
    public static final Marker PLAYER_FORGET_ALL_KNOWLEDGE_MARKER;

    private PlayerKnowledgeRegistry() {
    }

    public boolean doesPlayerKnow(EntityPlayer player, Object object) {
        return player != null && this.doesPlayerKnow(player.getDisplayName(), object);
    }

    public boolean doesPlayerKnow(String playerName, Object object) {
        if (this.getPlayerKnowledge(playerName) != null) {
            return this.getPlayerKnowledge(playerName).isKnown(object);
        }
        return false;
    }

    public boolean canPlayerLearn(EntityPlayer entityPlayer, Object object) {
        if (entityPlayer != null) {
            return this.canPlayerLearn(entityPlayer.getDisplayName(), object);
        }
        return false;
    }

    public boolean canPlayerLearn(String playerName, Object object) {
        if (this.getPlayerKnowledge(playerName) != null) {
            return !this.getPlayerKnowledge(playerName).isKnown(object) && BlacklistRegistryProxy.isLearnable(object);
        }
        return false;
    }

    public void teachPlayer(EntityPlayer entityPlayer, Object object) {
        if (entityPlayer != null) {
            this.teachPlayer(entityPlayer.getDisplayName(), object);
        }
    }

    public void teachPlayer(String playerName, Object object) {
        if (this.getPlayerKnowledge(playerName) != null) {
            this.getPlayerKnowledge(playerName).learn(object);
            LogHelper.trace(PLAYER_LEARN_KNOWLEDGE, "Player {} learned {}", playerName, object);
            this.save(playerName);
        }
    }

    public void teachPlayer(EntityPlayer entityPlayer, Collection<?> objects) {
        if (entityPlayer != null) {
            this.teachPlayer(entityPlayer.getDisplayName(), objects);
        }
    }

    public void teachPlayer(String playerName, Collection<?> objects) {
        PlayerKnowledge playerKnowledge;
        if (objects != null && (playerKnowledge = this.getPlayerKnowledge(playerName)) != null) {
            for (Object object : objects) {
                this.getPlayerKnowledge(playerName).learn(object);
                LogHelper.trace(PLAYER_LEARN_KNOWLEDGE, "Player {} learned {}", playerName, object);
            }
            this.save(playerName);
        }
    }

    public void makePlayerForget(EntityPlayer entityPlayer, Object object) {
        if (entityPlayer != null) {
            this.makePlayerForget(entityPlayer.getDisplayName(), object);
        }
    }

    public void makePlayerForget(String playerName, Object object) {
        if (this.getPlayerKnowledge(playerName) != null) {
            this.getPlayerKnowledge(playerName).forget(object);
            LogHelper.trace(PLAYER_FORGET_KNOWLEDGE_MARKER, "Player {} forgot {}", playerName, object);
            this.save(playerName);
        }
    }

    public void makePlayerForget(EntityPlayer entityPlayer, Collection<?> objects) {
        if (entityPlayer != null) {
            this.makePlayerForget(entityPlayer.getDisplayName(), objects);
        }
    }

    public void makePlayerForget(String playerName, Collection<?> objects) {
        PlayerKnowledge playerKnowledge;
        if (objects != null && (playerKnowledge = this.getPlayerKnowledge(playerName)) != null) {
            for (Object object : objects) {
                this.getPlayerKnowledge(playerName).forget(object);
                LogHelper.trace(PLAYER_FORGET_KNOWLEDGE_MARKER, "Player {} forgot {}", playerName, object);
            }
            this.save(playerName);
        }
    }

    public void makePlayerForgetAll(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            this.makePlayerForgetAll(entityPlayer.getDisplayName());
        }
    }

    public void makePlayerForgetAll(String playerName) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && playerName != null && !playerName.isEmpty()) {
            this.playerKnowledgeMap.put(playerName, new PlayerKnowledge());
            LogHelper.trace(PLAYER_FORGET_ALL_KNOWLEDGE_MARKER, "Player {} forget everything", playerName);
            this.save(playerName);
        }
    }

    public Set<ItemStack> getKnownItemStacks(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            return this.getKnownItemStacks(entityPlayer.getDisplayName());
        }
        return new TreeSet<ItemStack>(Comparators.ID_COMPARATOR);
    }

    public Set<ItemStack> getKnownItemStacks(String playerName) {
        if (this.getPlayerKnowledge(playerName) != null) {
            return this.getPlayerKnowledge(playerName).getKnownItemStacks();
        }
        return new TreeSet<ItemStack>(Comparators.ID_COMPARATOR);
    }

    protected PlayerKnowledge getPlayerKnowledge(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            return this.getPlayerKnowledge(entityPlayer.getDisplayName());
        }
        return null;
    }

    private PlayerKnowledge getPlayerKnowledge(String playerName) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && playerName != null && !playerName.isEmpty()) {
            if (!this.playerKnowledgeMap.containsKey(playerName)) {
                this.playerKnowledgeMap.put(playerName, this.load(PlayerKnowledgeRegistry.getPlayerKnowledgeFile(playerName), false));
            }
            return this.playerKnowledgeMap.get(playerName);
        }
        return null;
    }

    public void saveAll() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            SerializationHelper.writeJsonFile(templatePlayerKnowledgeFile, SerializationHelper.GSON.toJson((Object)this.templatePlayerKnowledge));
            for (String playerName : this.playerKnowledgeMap.keySet()) {
                this.save(playerName);
            }
        }
    }

    private void save(String playerName) {
        File playerKnowledgeFile;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && playerName != null && !playerName.isEmpty() && (playerKnowledgeFile = PlayerKnowledgeRegistry.getPlayerKnowledgeFile(playerName)) != null) {
            SerializationHelper.writeJsonFile(playerKnowledgeFile, SerializationHelper.GSON.toJson((Object)this.playerKnowledgeMap.get(playerName)));
        }
    }

    public void load() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.templatePlayerKnowledge.forgetAll();
            this.templatePlayerKnowledge.learn(this.load(templatePlayerKnowledgeFile, true).getKnownItemStacks());
            this.playerKnowledgeMap.clear();
        }
    }

    private PlayerKnowledge load(File file, boolean isTemplate) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && file != null) {
            try {
                String jsonString = SerializationHelper.readJsonFile(file);
                PlayerKnowledge playerKnowledge = (PlayerKnowledge)SerializationHelper.GSON.fromJson(jsonString, PlayerKnowledge.class);
                if (playerKnowledge != null) {
                    return playerKnowledge;
                }
            }
            catch (JsonSyntaxException e) {
                LogHelper.error("Unable to read player knowledge from file '{}'", file.getAbsoluteFile());
            }
            catch (FileNotFoundException e) {
                LogHelper.warn("Unable to find file '{}'", file.getAbsoluteFile());
            }
        }
        if (ConfigurationHandler.Settings.playerKnowledgeTemplateEnabled && !isTemplate) {
            LogHelper.info("Unable to read player knowledge from {}, initializing a new one with template data", file.getName());
            return new PlayerKnowledge(this.templatePlayerKnowledge);
        }
        LogHelper.info("Unable to read player knowledge from {}, initializing a new empty one", file.getName());
        return new PlayerKnowledge();
    }

    private static File getPlayerKnowledgeFile(String playerName) {
        if (playerName != null && !playerName.isEmpty()) {
            return new File(Files.playerDataDirectory, "knowledge" + File.separator + "transmutation" + File.separator + playerName + ".json");
        }
        return null;
    }

    static {
        PLAYER_KNOWLEDGE_MARKER = MarkerManager.getMarker((String)"EE3_PLAYER_KNOWLEDGE", (Marker)LogHelper.MOD_MARKER);
        PLAYER_LEARN_KNOWLEDGE = MarkerManager.getMarker((String)"EE3_PLAYER_TEACH_KNOWLEDGE", (Marker)PLAYER_KNOWLEDGE_MARKER);
        PLAYER_FORGET_KNOWLEDGE_MARKER = MarkerManager.getMarker((String)"EE3_PLAYER_FORGET_KNOWLEDGE", (Marker)PLAYER_KNOWLEDGE_MARKER);
        PLAYER_FORGET_ALL_KNOWLEDGE_MARKER = MarkerManager.getMarker((String)"EE3_PLAYER_FORGET_ALL_KNOWLEDGE", (Marker)PLAYER_FORGET_KNOWLEDGE_MARKER);
    }
}

