/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.array.AlchemyArrayRegistry;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageChalkSettings;
import com.pahimar.ee3.reference.Key;
import com.pahimar.ee3.settings.ChalkSettings;
import com.pahimar.ee3.tileentity.TileEntityDummyArray;
import com.pahimar.ee3.util.EntityHelper;
import com.pahimar.ee3.util.IKeyBound;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemChalk
extends ItemEE
implements IKeyBound {
    public ItemChalk() {
        this.func_77655_b("chalk");
        this.func_77656_e(80);
        this.canRepair = true;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (side == 0) {
                --y;
            } else if (side == 1) {
                ++y;
            } else if (side == 2) {
                --z;
            } else if (side == 3) {
                ++z;
            } else if (side == 4) {
                --x;
            } else if (side == 5) {
                ++x;
            }
            if (this.canPlaceAlchemyArray(itemStack, entityPlayer, world, x, y, z, side)) {
                this.placeAlchemyArray(itemStack, entityPlayer, world, x, y, z, side);
                return true;
            }
        }
        return false;
    }

    private boolean canPlaceAlchemyArray(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side) {
        if (!world.field_72995_K) {
            NBTTagCompound playerCustomData = EntityHelper.getCustomEntityData((Entity)entityPlayer);
            ChalkSettings chalkSettings = new ChalkSettings();
            chalkSettings.readFromNBT(playerCustomData);
            AlchemyArray alchemyArray = AlchemyArrayRegistry.getInstance().getAlchemyArray(chalkSettings.getIndex());
            int coordOffset = chalkSettings.getSize() - 1;
            ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
            boolean canPlaceAlchemyArray = ModBlocks.alchemyArray.func_149707_d(world, x, y, z, side);
            int chargeLevel = (chalkSettings.getSize() - 1) * 2 + 1;
            if (itemStack.func_77960_j() == itemStack.func_77958_k() && chargeLevel * chargeLevel * alchemyArray.getChalkCostPerBlock() == 1) {
                canPlaceAlchemyArray = true;
            } else if (itemStack.func_77958_k() - itemStack.func_77960_j() + 1 < chargeLevel * chargeLevel * alchemyArray.getChalkCostPerBlock()) {
                canPlaceAlchemyArray = false;
            }
            if (canPlaceAlchemyArray) {
                if (orientation == ForgeDirection.UP || orientation == ForgeDirection.DOWN) {
                    for (int i = x - coordOffset; i <= x + coordOffset; ++i) {
                        for (int j = z - coordOffset; j <= z + coordOffset; ++j) {
                            if (i == x && j == z || ModBlocks.dummyArray.func_149707_d(world, i, y, j, side) && !(world.func_147438_o(i, y, j) instanceof TileEntityDummyArray)) continue;
                            canPlaceAlchemyArray = false;
                        }
                    }
                } else if (orientation == ForgeDirection.NORTH || orientation == ForgeDirection.SOUTH) {
                    for (int i = x - coordOffset; i <= x + coordOffset; ++i) {
                        for (int j = y - coordOffset; j <= y + coordOffset; ++j) {
                            if (i == x && j == y || ModBlocks.dummyArray.func_149707_d(world, i, j, z, side) && !(world.func_147438_o(i, j, z) instanceof TileEntityDummyArray)) continue;
                            canPlaceAlchemyArray = false;
                        }
                    }
                } else if (orientation == ForgeDirection.EAST || orientation == ForgeDirection.WEST) {
                    for (int i = y - coordOffset; i <= y + coordOffset; ++i) {
                        for (int j = z - coordOffset; j <= z + coordOffset; ++j) {
                            if (i == y && j == z || ModBlocks.dummyArray.func_149707_d(world, x, i, j, side) && !(world.func_147438_o(x, i, j) instanceof TileEntityDummyArray)) continue;
                            canPlaceAlchemyArray = false;
                        }
                    }
                }
            }
            return canPlaceAlchemyArray;
        }
        return true;
    }

    private void placeAlchemyArray(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side) {
        block12: {
            if (world.field_72995_K) break block12;
            NBTTagCompound playerCustomData = EntityHelper.getCustomEntityData((Entity)entityPlayer);
            ChalkSettings chalkSettings = new ChalkSettings();
            chalkSettings.readFromNBT(playerCustomData);
            int coordOffset = chalkSettings.getSize() - 1;
            ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
            boolean canPlaceAlchemyArray = ModBlocks.alchemyArray.func_149707_d(world, x, y, z, side);
            this.placeBlockAt(entityPlayer, itemStack, world, x, y, z, (Block)ModBlocks.alchemyArray, side);
            if (canPlaceAlchemyArray) {
                if (orientation == ForgeDirection.UP || orientation == ForgeDirection.DOWN) {
                    for (int i = x - coordOffset; i <= x + coordOffset; ++i) {
                        for (int j = z - coordOffset; j <= z + coordOffset; ++j) {
                            if (i == x && j == z) continue;
                            this.placeBlockAt(entityPlayer, itemStack, world, i, y, j, (Block)ModBlocks.dummyArray, side);
                            if (!(world.func_147438_o(i, y, j) instanceof TileEntityDummyArray)) continue;
                            ((TileEntityDummyArray)world.func_147438_o(i, y, j)).setTrueCoords(x, y, z);
                        }
                    }
                } else if (orientation == ForgeDirection.NORTH || orientation == ForgeDirection.SOUTH) {
                    for (int i = x - coordOffset; i <= x + coordOffset; ++i) {
                        for (int j = y - coordOffset; j <= y + coordOffset; ++j) {
                            if (i == x && j == y) continue;
                            this.placeBlockAt(entityPlayer, itemStack, world, i, j, z, (Block)ModBlocks.dummyArray, side);
                            ((TileEntityDummyArray)world.func_147438_o(i, j, z)).setTrueCoords(x, y, z);
                        }
                    }
                } else if (orientation == ForgeDirection.EAST || orientation == ForgeDirection.WEST) {
                    for (int i = y - coordOffset; i <= y + coordOffset; ++i) {
                        for (int j = z - coordOffset; j <= z + coordOffset; ++j) {
                            if (i == y && j == z) continue;
                            this.placeBlockAt(entityPlayer, itemStack, world, x, i, j, (Block)ModBlocks.dummyArray, side);
                            ((TileEntityDummyArray)world.func_147438_o(x, i, j)).setTrueCoords(x, y, z);
                        }
                    }
                }
            }
        }
    }

    private boolean placeBlockAt(EntityPlayer entityPlayer, ItemStack itemStack, World world, int x, int y, int z, Block block, int metadata) {
        if (!world.field_72995_K) {
            if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
                return false;
            }
            if (world.func_147439_a(x, y, z) == block) {
                NBTTagCompound playerCustomData = EntityHelper.getCustomEntityData((Entity)entityPlayer);
                ChalkSettings chalkSettings = new ChalkSettings();
                chalkSettings.readFromNBT(playerCustomData);
                AlchemyArray alchemyArray = AlchemyArrayRegistry.getInstance().getAlchemyArray(chalkSettings.getIndex());
                if (alchemyArray != null) {
                    itemStack.func_77972_a(alchemyArray.getChalkCostPerBlock(), (EntityLivingBase)entityPlayer);
                    block.func_149689_a(world, x, y, z, (EntityLivingBase)entityPlayer, itemStack);
                    block.func_149714_e(world, x, y, z, metadata);
                }
            }
        }
        return true;
    }

    @Override
    public void doKeyBindingAction(EntityPlayer entityPlayer, ItemStack itemStack, Key key) {
        if (key != Key.UNKNOWN) {
            NBTTagCompound playerCustomData = EntityHelper.getCustomEntityData((Entity)entityPlayer);
            ChalkSettings chalkSettings = new ChalkSettings();
            chalkSettings.readFromNBT(playerCustomData);
            if (key == Key.CHARGE) {
                if (!entityPlayer.func_70093_af()) {
                    chalkSettings.incrementSize();
                } else {
                    chalkSettings.decrementSize();
                }
            } else if (key == Key.TOGGLE) {
                if (!entityPlayer.func_70093_af()) {
                    chalkSettings.incrementIndex();
                } else {
                    chalkSettings.decrementIndex();
                }
            } else if (key == Key.RELEASE) {
                if (!entityPlayer.func_70093_af()) {
                    chalkSettings.rotateClockwise();
                } else {
                    chalkSettings.rotateCounterClockwise();
                }
            }
            chalkSettings.writeToNBT(playerCustomData);
            EntityHelper.saveCustomEntityData((Entity)entityPlayer, playerCustomData);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageChalkSettings(chalkSettings), (EntityPlayerMP)entityPlayer);
        }
    }
}

