/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.renderer.tileentity;

import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChest;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererAlchemicalChest
extends TileEntitySpecialRenderer {
    private final ModelChest modelChest = new ModelChest();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float tick) {
        if (tileEntity instanceof TileEntityAlchemicalChest) {
            TileEntityAlchemicalChest tileEntityAlchemicalChest = (TileEntityAlchemicalChest)tileEntity;
            ForgeDirection direction = null;
            if (tileEntityAlchemicalChest.func_145831_w() != null) {
                direction = tileEntityAlchemicalChest.getOrientation();
            }
            if (tileEntityAlchemicalChest.getState() == 0) {
                this.func_147499_a(Textures.Model.ALCHEMICAL_CHEST_SMALL);
            } else if (tileEntityAlchemicalChest.getState() == 1) {
                this.func_147499_a(Textures.Model.ALCHEMICAL_CHEST_MEDIUM);
            } else if (tileEntityAlchemicalChest.getState() == 2) {
                this.func_147499_a(Textures.Model.ALCHEMICAL_CHEST_LARGE);
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            int angle = 0;
            if (direction != null) {
                if (direction == ForgeDirection.NORTH) {
                    angle = 180;
                } else if (direction == ForgeDirection.SOUTH) {
                    angle = 0;
                } else if (direction == ForgeDirection.WEST) {
                    angle = 90;
                } else if (direction == ForgeDirection.EAST) {
                    angle = -90;
                }
            }
            GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float adjustedLidAngle = tileEntityAlchemicalChest.prevLidAngle + (tileEntityAlchemicalChest.lidAngle - tileEntityAlchemicalChest.prevLidAngle) * tick;
            adjustedLidAngle = 1.0f - adjustedLidAngle;
            adjustedLidAngle = 1.0f - adjustedLidAngle * adjustedLidAngle * adjustedLidAngle;
            this.modelChest.field_78234_a.field_78795_f = -(adjustedLidAngle * (float)Math.PI / 2.0f);
            this.modelChest.func_78231_a();
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

