/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.array;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class AlchemyArray
implements Comparable<AlchemyArray> {
    private ResourceLocation texture;
    private String unlocalizedName;
    private String className;
    private int lightLevel;
    private int chalkPerBlockCost;

    private AlchemyArray() {
    }

    public AlchemyArray(ResourceLocation texture, String unlocalizedName) {
        this.texture = texture;
        this.unlocalizedName = unlocalizedName;
        this.chalkPerBlockCost = 1;
        this.lightLevel = 0;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public void setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public String getDisplayName() {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    public int getChalkCostPerBlock() {
        return this.chalkPerBlockCost;
    }

    public void setChalkPerBlockCost(int chalkPerBlockCost) {
        this.chalkPerBlockCost = Math.abs(chalkPerBlockCost);
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public String getClassName() {
        return this.className;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null) {
            this.texture = nbtTagCompound.func_74764_b("textureDomain") && nbtTagCompound.func_74764_b("texturePath") ? new ResourceLocation(nbtTagCompound.func_74779_i("textureDomain"), nbtTagCompound.func_74779_i("texturePath")) : new ResourceLocation("");
            this.unlocalizedName = nbtTagCompound.func_74764_b("unlocalizedName") ? nbtTagCompound.func_74779_i("unlocalizedName") : "";
            this.className = nbtTagCompound.func_74764_b("className") ? nbtTagCompound.func_74779_i("className") : "";
            this.lightLevel = nbtTagCompound.func_74764_b("lightLevel") ? nbtTagCompound.func_74762_e("lightLevel") : 0;
        } else {
            this.texture = new ResourceLocation("");
            this.unlocalizedName = "";
            this.className = "";
            this.lightLevel = 0;
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74778_a("textureDomain", this.texture.func_110624_b());
        nbtTagCompound.func_74778_a("texturePath", this.texture.func_110623_a());
        nbtTagCompound.func_74778_a("unlocalizedName", this.unlocalizedName);
        nbtTagCompound.func_74778_a("className", this.getClass().getCanonicalName());
        nbtTagCompound.func_74768_a("lightLevel", this.lightLevel);
    }

    public static AlchemyArray readArrayFromNBT(NBTTagCompound nbtTagCompound) {
        AlchemyArray alchemyArray = new AlchemyArray();
        alchemyArray.readFromNBT(nbtTagCompound);
        return alchemyArray;
    }

    public void onArrayPlacedBy(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityLivingBase entityLiving, ItemStack itemStack) {
    }

    public void onArrayActivated(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
    }

    public void onArrayClicked(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer) {
    }

    public void onArrayDestroyedByExplosion(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Explosion explosion) {
    }

    public void onArrayDestroyedByPlayer(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, int metaData) {
    }

    public void onEntityCollidedWithArray(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity) {
    }

    public void onArrayFallenUpon(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity, float fallDistance) {
    }

    public void onUpdate(World world, int arrayX, int arrayY, int arrayZ, int tickCount) {
    }

    public boolean equals(Object object) {
        if (object instanceof AlchemyArray) {
            return this.compareTo((AlchemyArray)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(AlchemyArray alchemyArray) {
        if (this.texture.func_110624_b().equalsIgnoreCase(alchemyArray.getTexture().func_110624_b())) {
            if (this.texture.func_110623_a().equalsIgnoreCase(alchemyArray.getTexture().func_110623_a())) {
                return 0;
            }
            return this.texture.func_110623_a().compareToIgnoreCase(alchemyArray.getTexture().func_110623_a());
        }
        return this.texture.func_110624_b().compareToIgnoreCase(alchemyArray.getTexture().func_110624_b());
    }
}

