/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.autopackager;

import cofh.api.energy.TileEnergyHandler;
import cofh.lib.util.helpers.InventoryHelper;
import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.tileentity.ISortingMember;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingMemberHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.mcupdater.autopackager.AutoPackager;
import org.mcupdater.shared.Position;

@Optional.Interface(iface="com.dynious.refinedrelocation.api.tileentity.ISortingMember", modid="RefinedRelocation")
public class TilePackager
extends TileEnergyHandler
implements ISortingMember {
    private boolean isFirstTick = true;
    private Object sortingHandler;
    private ForgeDirection orientation;
    private int tickCounter = 0;
    private int tickDelay = AutoPackager.delayCycleNormal;
    protected Mode mode = Mode.HYBRID;

    public void func_145845_h() {
        if (this.isFirstTick && Loader.isModLoaded((String)"RefinedRelocation")) {
            new Runnable(){

                @Override
                public void run() {
                    TilePackager.this.getHandler().onTileAdded();
                }
            }.run();
            this.isFirstTick = false;
        }
        super.func_145845_h();
        if (++this.tickCounter >= this.tickDelay) {
            this.tickCounter = 0;
            if (this.storage.getEnergyStored() > AutoPackager.energyPerCycle) {
                if (this.tryCraft()) {
                    this.storage.extractEnergy(AutoPackager.energyPerCycle, false);
                    this.tickDelay = AutoPackager.delayCycleNormal;
                } else {
                    this.tickDelay = AutoPackager.delayCycleIdle;
                }
            }
        }
    }

    private boolean tryCraft() {
        if (this.orientation == null) {
            return false;
        }
        Position inputPos = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.orientation);
        Position outputPos = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.orientation);
        inputPos.moveLeft(1.0);
        outputPos.moveRight(1.0);
        TileEntity tileInput = this.field_145850_b.func_147438_o((int)inputPos.x, (int)inputPos.y, (int)inputPos.z);
        TileEntity tileOutput = this.field_145850_b.func_147438_o((int)outputPos.x, (int)outputPos.y, (int)outputPos.z);
        HashMap slotMap = new HashMap();
        if (tileInput instanceof IInventory && tileOutput instanceof IInventory) {
            IInventory invInput = (IInventory)tileInput;
            IInventory invOutput = (IInventory)tileOutput;
            for (int slot = 0; slot < invInput.func_70302_i_(); ++slot) {
                InventoryCrafting largeCraft;
                ItemStack result;
                int craftSlot;
                InventoryCrafting smallCraft;
                ItemStack testStack;
                if (invInput.func_70301_a(slot) == null || invInput instanceof ISidedInventory && !((ISidedInventory)invInput).func_102008_b(slot, invInput.func_70301_a(slot), ForgeDirection.DOWN.ordinal())) continue;
                if (slotMap.containsKey(invInput.func_70301_a(slot).func_77977_a() + ":" + invInput.func_70301_a(slot).func_77960_j())) {
                    ((SortedSet)slotMap.get(invInput.func_70301_a(slot).func_77977_a() + ":" + invInput.func_70301_a(slot).func_77960_j())).add(slot);
                } else {
                    TreeSet<Integer> slotList = new TreeSet<Integer>();
                    slotList.add(slot);
                    slotMap.put(invInput.func_70301_a(slot).func_77977_a() + ":" + invInput.func_70301_a(slot).func_77960_j(), slotList);
                }
                if ((this.mode == Mode.HYBRID || this.mode == Mode.SMALL) && invInput.func_70301_a((int)slot).field_77994_a >= 4) {
                    testStack = invInput.func_70301_a(slot).func_77946_l();
                    testStack.field_77994_a = 1;
                    if (!AutoPackager.small.containsKey(testStack)) {
                        smallCraft = new InventoryCrafting(new Container(){

                            public boolean func_75145_c(EntityPlayer entityPlayer) {
                                return false;
                            }
                        }, 2, 2);
                        for (craftSlot = 0; craftSlot < 4; ++craftSlot) {
                            smallCraft.func_70299_a(craftSlot, testStack);
                        }
                        result = CraftingManager.func_77594_a().func_82787_a(smallCraft, this.field_145850_b);
                        AutoPackager.small.put(testStack, result);
                    } else {
                        result = AutoPackager.small.get(testStack);
                    }
                    if (result != null && (testStack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1)) == null) {
                        invInput.func_70298_a(slot, 4);
                        InventoryHelper.insertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1);
                        return true;
                    }
                }
                if ((this.mode == Mode.HYBRID || this.mode == Mode.LARGE) && invInput.func_70301_a((int)slot).field_77994_a >= 9) {
                    testStack = invInput.func_70301_a(slot).func_77946_l();
                    testStack.field_77994_a = 1;
                    if (!AutoPackager.large.containsKey(testStack)) {
                        largeCraft = new InventoryCrafting(new Container(){

                            public boolean func_75145_c(EntityPlayer entityPlayer) {
                                return false;
                            }
                        }, 3, 3);
                        for (craftSlot = 0; craftSlot < 9; ++craftSlot) {
                            largeCraft.func_70299_a(craftSlot, testStack);
                        }
                        result = CraftingManager.func_77594_a().func_82787_a(largeCraft, this.field_145850_b);
                        AutoPackager.large.put(testStack, result);
                    } else {
                        result = AutoPackager.large.get(testStack);
                    }
                    if (result != null && (testStack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1)) == null) {
                        invInput.func_70298_a(slot, 9);
                        InventoryHelper.insertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1);
                        return true;
                    }
                }
                if (this.mode == Mode.HOLLOW && invInput.func_70301_a((int)slot).field_77994_a >= 8) {
                    testStack = invInput.func_70301_a(slot).func_77946_l();
                    testStack.field_77994_a = 1;
                    if (!AutoPackager.hollow.containsKey(testStack)) {
                        largeCraft = new InventoryCrafting(new Container(){

                            public boolean func_75145_c(EntityPlayer entityPlayer) {
                                return false;
                            }
                        }, 3, 3);
                        for (craftSlot = 0; craftSlot < 9; ++craftSlot) {
                            largeCraft.func_70299_a(craftSlot, craftSlot == 4 ? null : testStack);
                        }
                        result = CraftingManager.func_77594_a().func_82787_a(largeCraft, this.field_145850_b);
                        AutoPackager.hollow.put(testStack, result);
                    } else {
                        result = AutoPackager.hollow.get(testStack);
                    }
                    if (result != null && (testStack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1)) == null) {
                        invInput.func_70298_a(slot, 8);
                        InventoryHelper.insertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1);
                        return true;
                    }
                }
                if (this.mode != Mode.UNPACKAGE || invInput.func_70301_a((int)slot).field_77994_a < 1) continue;
                testStack = invInput.func_70301_a(slot).func_77946_l();
                testStack.field_77994_a = 1;
                if (!AutoPackager.single.containsKey(testStack)) {
                    smallCraft = new InventoryCrafting(new Container(){

                        public boolean func_75145_c(EntityPlayer entityPlayer) {
                            return false;
                        }
                    }, 2, 2);
                    smallCraft.func_70299_a(0, testStack);
                    result = CraftingManager.func_77594_a().func_82787_a(smallCraft, this.field_145850_b);
                    AutoPackager.single.put(testStack, result);
                } else {
                    result = AutoPackager.single.get(testStack);
                }
                if (result == null || (testStack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1)) != null) continue;
                invInput.func_70298_a(slot, 1);
                InventoryHelper.insertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1);
                return true;
            }
            for (Map.Entry entry : slotMap.entrySet()) {
                if (((SortedSet)entry.getValue()).size() <= 1) continue;
                SortedSet slots = (SortedSet)entry.getValue();
                while (slots.size() > 1) {
                    if (invInput.func_70301_a(((Integer)slots.first()).intValue()) == null || !(invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77977_a() + ":" + invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77960_j()).equals(entry.getKey()) || invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a >= invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77976_d()) {
                        slots.remove(slots.first());
                        continue;
                    }
                    if (invInput.func_70301_a(((Integer)slots.last()).intValue()) == null || !invInput.func_70301_a(((Integer)slots.last()).intValue()).func_77969_a(invInput.func_70301_a(((Integer)slots.first()).intValue())) || !ItemStack.func_77970_a((ItemStack)invInput.func_70301_a(((Integer)slots.first()).intValue()), (ItemStack)invInput.func_70301_a(((Integer)slots.last()).intValue()))) {
                        slots.remove(slots.last());
                        continue;
                    }
                    if (invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a + invInput.func_70301_a((int)((Integer)slots.last()).intValue()).field_77994_a <= invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77976_d()) {
                        invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a += invInput.func_70301_a((int)((Integer)slots.last()).intValue()).field_77994_a;
                        invInput.func_70299_a(((Integer)slots.last()).intValue(), null);
                        continue;
                    }
                    int spaceRemain = invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77976_d() - invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a;
                    invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a += spaceRemain;
                    invInput.func_70298_a(((Integer)slots.last()).intValue(), spaceRemain);
                }
            }
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("orientation", this.orientation != null ? this.orientation.ordinal() : 0);
        tagCompound.func_74768_a("mode", this.mode.ordinal());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.orientation = ForgeDirection.getOrientation((int)tagCompound.func_74762_e("orientation"));
        this.mode = Mode.values()[tagCompound.func_74762_e("mode")];
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    public void cycleMode(EntityPlayer player) {
        this.mode = Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length];
        if (!this.field_145850_b.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"autopackager.mode.current") + " " + StatCollector.func_74838_a((String)this.mode.getMessage()), new Object[0]));
        }
    }

    public void checkMode(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"autopackager.mode.current") + " " + StatCollector.func_74838_a((String)this.mode.getMessage()), new Object[0]));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, nbt);
    }

    public void onDataPacket(NetworkManager netman, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Optional.Method(modid="RefinedRelocation")
    public ISortingMemberHandler getHandler() {
        if (this.sortingHandler == null) {
            this.sortingHandler = APIUtils.createSortingMemberHandler((TileEntity)this);
        }
        return (ISortingMemberHandler)this.sortingHandler;
    }

    @SideOnly(value=Side.CLIENT)
    public void addWailaInformation(List information) {
        information.add(StatCollector.func_74838_a((String)"autopackager.mode.current") + " " + StatCollector.func_74838_a((String)this.mode.getMessage()));
    }

    protected static enum Mode {
        HYBRID("autopackager.mode.hybrid"),
        SMALL("autopackager.mode.small"),
        LARGE("autopackager.mode.large"),
        HOLLOW("autopackager.mode.hollow"),
        UNPACKAGE("autopackager.mode.unpackage");

        private String message;

        private Mode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

