/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.page.unit;

import com.ewyboy.ewysworkshop.gui.container.slot.SlotUnitFurnaceInput;
import com.ewyboy.ewysworkshop.gui.container.slot.SlotUnitFurnaceQueue;
import com.ewyboy.ewysworkshop.gui.container.slot.SlotUnitFurnaceResult;
import com.ewyboy.ewysworkshop.item.Upgrade;
import com.ewyboy.ewysworkshop.page.Page;
import com.ewyboy.ewysworkshop.page.unit.Unit;
import com.ewyboy.ewysworkshop.tileentity.TileEntityTable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class UnitSmelting
extends Unit {
    private int inputId;
    private int outputId;
    private int queueId;
    private static final int QUEUE_MAX_COUNT = 3;
    private static final int QUEUE_X = 5;
    private static final int QUEUE_Y = 5;
    private static final int START_X = 25;
    private static final int START_Y = 23;
    private static final int RESULT_X = 56;
    private static final int SLOT_SIZE = 18;
    private static final int[] QUEUE_ORDER = new int[]{2, 0, 1};
    private static final int[] QUEUE_ORDER_START = new int[]{1, 1, 0};
    private static final int ARROW_X = 25;
    private static final int ARROW_Y = 1;

    public UnitSmelting(TileEntityTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        this.inputId = id;
        this.addSlot(new SlotUnitFurnaceInput(this.table, this.page, id++, this.x + 25, this.y + 23, this));
        this.outputId = id;
        this.addSlot(new SlotUnitFurnaceResult(this.table, this.page, id++, this.x + 25 + 56, this.y + 23, this));
        this.queueId = id;
        for (int i = 0; i < 3; ++i) {
            this.addSlot(new SlotUnitFurnaceQueue(this.table, this.page, id++, this.x + 5, this.y + 5 + i * 18, this, QUEUE_ORDER[i]));
        }
        return id;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int queueLength = this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.QUEUE);
        if (queueLength > 0) {
            int start = QUEUE_ORDER_START[queueLength - 1];
            for (int i = start + queueLength - 1; i >= start; --i) {
                int targetId = i == start + queueLength - 1 ? this.inputId : this.queueId + i + 1;
                int sourceId = this.queueId + i;
                ItemStack target = this.table.func_70301_a(targetId);
                ItemStack source = this.table.func_70301_a(sourceId);
                if (source == null) continue;
                ItemStack move = source.func_77946_l();
                move.field_77994_a = 1;
                if (!this.canMove(move, target)) continue;
                if (target == null) {
                    this.table.func_70299_a(targetId, move);
                } else {
                    ++target.field_77994_a;
                }
                --source.field_77994_a;
                if (source.field_77994_a != 0) continue;
                this.table.func_70299_a(sourceId, null);
            }
        }
    }

    @Override
    protected ItemStack getProductionResult() {
        ItemStack input = this.table.func_70301_a(this.inputId);
        return input == null ? null : FurnaceRecipes.func_77602_a().func_151395_a(input);
    }

    @Override
    protected void onProduction(ItemStack result) {
        this.table.func_70298_a(this.inputId, 1);
    }

    @Override
    public int getOutputId() {
        return this.outputId;
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return item != null && Item.func_150898_a((Block)Blocks.field_150460_al) == item.func_77973_b();
    }

    @Override
    public int getArrowX() {
        return 50;
    }

    @Override
    public int getArrowY() {
        return 24;
    }
}

