/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.network;

import com.ewyboy.ewysworkshop.network.IBitCount;
import com.ewyboy.ewysworkshop.network.StandardCounts;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class DataReader {
    private ByteBuf stream;
    private int byteBuffer;
    private int bitCountBuffer;

    DataReader(ByteBuf buf) {
        this.stream = buf;
    }

    public int readData(IBitCount count) {
        return this.readData(count.getBitCount());
    }

    private int readData(int bitCount) {
        int data = 0;
        int readBits = 0;
        while (true) {
            int bitsLeft;
            if (this.bitCountBuffer >= (bitsLeft = bitCount - readBits)) {
                data |= (this.byteBuffer & (int)Math.pow(2.0, bitsLeft) - 1) << readBits;
                this.byteBuffer >>>= bitsLeft;
                this.bitCountBuffer -= bitsLeft;
                readBits += bitsLeft;
                break;
            }
            data |= this.byteBuffer << readBits;
            readBits += this.bitCountBuffer;
            this.byteBuffer = this.stream.readUnsignedByte();
            this.bitCountBuffer = 8;
        }
        return data;
    }

    public int readSignedData(IBitCount count) {
        return this.readSignedData(count.getBitCount());
    }

    public int readSignedData(int bitCount) {
        int data = this.readData(bitCount);
        int threshold = (int)Math.pow(2.0, bitCount - 1);
        int max = (int)Math.pow(2.0, bitCount) - 1;
        if (data >= threshold) {
            data = max - data;
        }
        return data;
    }

    public String readString() {
        return this.readString(StandardCounts.DEFAULT_STRING);
    }

    public String readString(IBitCount bits) {
        int length = this.readData(bits);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.readByte();
        }
        return new String(bytes);
    }

    public NBTTagCompound readNBT() {
        if (this.readBoolean()) {
            byte[] bytes = new byte[this.readData(StandardCounts.NBT_LENGTH)];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)this.readByte();
            }
            try {
                return CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public boolean readBoolean() {
        return this.readData(StandardCounts.BOOLEAN) != 0;
    }

    public int readByte() {
        return this.readData(StandardCounts.BYTE);
    }

    public int readShort() {
        return this.readData(StandardCounts.SHORT);
    }

    public int readInteger() {
        int data = this.readData(StandardCounts.INTEGER);
        return data < 0 ? 0 : data;
    }

    public int readSignedByte() {
        return this.readSignedData(StandardCounts.BYTE);
    }

    public int readSignedShort() {
        return this.readSignedData(StandardCounts.SHORT);
    }

    public int readSignedInteger() {
        return this.readData(StandardCounts.INTEGER);
    }

    public <T extends Enum> T readEnum(Class<T> clazz) {
        try {
            Object[] values = (Object[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            int length = values.length;
            if (length == 0) {
                return null;
            }
            int bitCount = (int)(Math.log10(length) / Math.log10(2.0)) + 1;
            int val = this.readData(bitCount);
            return (T)((Enum)values[val]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

