/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenNewRedwood
extends WorldGenAbstractTree {
    private static long lastSeed = 0L;
    private static boolean useQuarter = false;

    public WorldGenNewRedwood(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z);
    }

    public boolean generate(World world, long seed, int x, int y, int z) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z);
    }

    private boolean generateTree(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(23) + 26;
        boolean b0 = true;
        boolean flag1 = true;
        int chunkCheck = 13;
        if (y < 1 || y + height + 5 > 256) {
            return false;
        }
        if (!TreeSoilRegistry.isValidSoil(world.func_147439_a(x, y - 1, z)) || y >= 256 - height - 1) {
            return false;
        }
        if (!world.func_72904_c(x - chunkCheck, y - chunkCheck, z - chunkCheck, x + chunkCheck, y + chunkCheck, z + chunkCheck)) {
            return false;
        }
        if (!this.check2x2Trunk(x, y, z, height + 1, world, false)) {
            return false;
        }
        if (TreeBlock.TRUNK.getBlock() != null && !useQuarter) {
            for (int j1 = 0; j1 <= 1; ++j1) {
                for (int j2 = 0; j2 <= 1; ++j2) {
                    if (j1 == 1) {
                        this.func_150516_a(world, x + j1, y, z + j2, Blocks.field_150350_a, 0);
                    }
                    this.func_150516_a(world, x + j1, y - 1, z + j2, Blocks.field_150346_d, 0);
                    Block block = world.func_147439_a(x + j1, y, z + j2);
                    if (block == null || block.isAir((IBlockAccess)world, x + j1, y, z + j2) || block.isLeaves((IBlockAccess)world, x + j1, y, z + j2)) {
                        this.func_150516_a(world, x + j1, y, z + j2, TreeBlock.BRANCH.getBlock(), TreeBlock.BRANCH.getMetadata());
                    }
                    for (int k3 = 1; k3 <= height - 4; ++k3) {
                        block = world.func_147439_a(x + j1, y + k3, z + j2);
                        if (block != null && !block.isAir((IBlockAccess)world, x + j1, y + k3, z + j2) && !block.isLeaves((IBlockAccess)world, x + j1, y + k3, z + j2)) continue;
                        this.func_150516_a(world, x + j1, y + k3, z + j2, TreeBlock.BRANCH.getBlock(), TreeBlock.BRANCH.getMetadata());
                    }
                }
            }
        } else {
            for (int offset = 0; offset <= height - 4; ++offset) {
                this.func_150516_a(world, x, y + offset, z, TreeBlock.TRUNK.getBlock(), 0);
                this.func_150516_a(world, x, y + offset, z + 1, TreeBlock.TRUNK.getBlock(), 3);
                this.func_150516_a(world, x + 1, y + offset, z, TreeBlock.TRUNK.getBlock(), 1);
                this.func_150516_a(world, x + 1, y + offset, z + 1, TreeBlock.TRUNK.getBlock(), 2);
            }
        }
        for (int j3 = height / 2; j3 <= height - 6; ++j3) {
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x, y + j3, z + 1, -1, 0);
            }
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x + 1, y + j3, z + 1, 1, 0);
            }
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x + 1, y + j3, z, 0, -1);
            }
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x + 1, y + j3, z + 1, 0, 1);
            }
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x, y + j3, z, -1, 1);
            }
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x, y + j3, z, -1, -1);
            }
            if (rand.nextInt(4) == 0) {
                this.generateBranch(world, rand, x, y + j3, z + 1, 1, 1);
            }
            if (rand.nextInt(4) != 0) continue;
            this.generateBranch(world, rand, x, y + j3, z, 1, -1);
        }
        return true;
    }

    public void generateBranch(World world, Random random, int x, int y, int z, int xD, int zD) {
        for (int br = 0; br < 9; ++br) {
            Block block;
            if (xD == -1 && random.nextInt(3) == 0) {
                --x;
            }
            if (xD == 1 && random.nextInt(3) == 0) {
                ++x;
            }
            if (zD == -1 && random.nextInt(3) == 0) {
                --z;
            }
            if (zD == 1 && random.nextInt(3) == 0) {
                ++z;
            }
            if ((block = world.func_147439_a(x, y, z)) == null || block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z)) {
                this.func_150516_a(world, x, y, z, TreeBlock.BRANCH.getBlock(), TreeBlock.BRANCH.getMetadata());
            }
            if (br == 8 || random.nextInt(6) == 0) {
                this.generateLeaves(world, x, y, z);
            }
            ++y;
        }
    }

    public void generateLeaves(World world, int x, int y, int z) {
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                Block block;
                if (!world.func_72863_F().func_73149_a(x + i >> 4, z + j >> 4)) continue;
                if (!(Math.abs(i) == 3 && Math.abs(j) == 3 || Math.abs(i) == 2 && Math.abs(j) == 3 || Math.abs(i) == 3 && Math.abs(j) == 2 || (block = world.func_147439_a(x + i, y, z + j)) != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x + i, y, z + j))) {
                    this.func_150516_a(world, x + i, y, z + j, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                }
                if (Math.abs(i) >= 3 || Math.abs(j) >= 3 || Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                block = world.func_147439_a(x + i, y + 1, z + j);
                if (block == null || block.canBeReplacedByLeaves((IBlockAccess)world, x + i, y + 1, z + j)) {
                    this.func_150516_a(world, x + i, y + 1, z + j, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                }
                if ((block = world.func_147439_a(x + i, y - 1, z + j)) != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x + i, y - 1, z + j)) continue;
                this.func_150516_a(world, x + i, y - 1, z + j, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
            }
        }
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    public boolean check2x2Trunk(int x, int y, int z, int height, World world, boolean inWater) {
        if (inWater) {
            for (int y1 = y + 1; y1 < y + height; ++y1) {
                Block b00 = world.func_147439_a(x, y1, z);
                Block b10 = world.func_147439_a(x + 1, y1, z);
                Block b01 = world.func_147439_a(x, y1, z + 1);
                Block b11 = world.func_147439_a(x + 1, y1, z + 1);
                if (b00 != null && !b00.equals(Blocks.field_150355_j) && !b00.isReplaceable((IBlockAccess)world, x, y1, z)) {
                    return false;
                }
                if (b01 != null && !b01.equals(Blocks.field_150355_j) && !b01.isReplaceable((IBlockAccess)world, x + 1, y1, z)) {
                    return false;
                }
                if (b10 != null && !b10.equals(Blocks.field_150355_j) && !b10.isReplaceable((IBlockAccess)world, x, y1, z + 1)) {
                    return false;
                }
                if (b11 == null || b11.equals(Blocks.field_150355_j) || b11.isReplaceable((IBlockAccess)world, x + 1, y1, z + 1)) continue;
                return false;
            }
        } else {
            for (int y1 = y + 1; y1 < y + height; ++y1) {
                if (!world.func_147437_c(x, y1, z)) {
                    return false;
                }
                if (!world.func_147437_c(x + 1, y1, z)) {
                    return false;
                }
                if (!world.func_147437_c(x, y1, z + 1)) {
                    return false;
                }
                if (world.func_147437_c(x + 1, y1, z + 1)) continue;
                return false;
            }
        }
        return true;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Blocks.field_150362_t)),
        TRUNK(new ItemStack(Blocks.field_150364_r, 1, 1)),
        BRANCH(new ItemStack(Blocks.field_150364_r, 1, 1));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_REDWOOD.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_REDWOOD.get();
            }
            if (Element.LOG_REDWOOD.isPresent()) {
                TreeBlock.BRANCH.stack = Element.LOG_REDWOOD.get();
            }
            if (Element.LOG_QUARTER_REDWOOD.isPresent()) {
                useQuarter = true;
                TreeBlock.TRUNK.stack = Element.LOG_QUARTER_REDWOOD.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ItemStack stack) {
            this.stack = stack;
        }

        public Block getBlock() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return Block.func_149634_a((Item)this.stack.func_77973_b());
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

