/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenCustomSwamp
extends WorldGenNewTreeBase {
    public WorldGenCustomSwamp() {
        super(false);
    }

    public WorldGenCustomSwamp(boolean notify) {
        super(notify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int canopyRadius;
        int y1;
        while (world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151586_h) {
            --y;
        }
        int height = rand.nextInt(4) + 10;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y12 = y; y12 <= y + 1 + height; ++y12) {
            if (y12 < 0 && y12 >= 256) {
                return false;
            }
            int clearanceNeededAroundTrunk = 1;
            if (y12 == y) {
                clearanceNeededAroundTrunk = 0;
            }
            if (y12 >= y + 1 + height - 2) {
                clearanceNeededAroundTrunk = 3;
            }
            for (int x1 = x - clearanceNeededAroundTrunk; x1 <= x + clearanceNeededAroundTrunk; ++x1) {
                for (int x2 = z - clearanceNeededAroundTrunk; x2 <= z + clearanceNeededAroundTrunk; ++x2) {
                    Block block = world.func_147439_a(x1, y12, x2);
                    if (block == null || block.isLeaves((IBlockAccess)world, x1, y12, x2)) continue;
                    if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150358_i)) {
                        if (y12 <= y) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        Block block = world.func_147439_a(x, y - 1, z);
        if (!block.equals(Blocks.field_150349_c) && !block.equals(Blocks.field_150346_d) || y >= 256 - height - 1) {
            return false;
        }
        world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int posTrunk = y1 - (y + height);
            canopyRadius = 2 - posTrunk / 2;
            for (int x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                int xOnRadius = x1 - x;
                for (int z1 = z - canopyRadius; z1 <= z + canopyRadius; ++z1) {
                    int zOnRadius = z1 - z;
                    Block block2 = world.func_147439_a(x1, y1, z1);
                    if (Math.abs(xOnRadius) == canopyRadius && Math.abs(zOnRadius) == canopyRadius && (rand.nextInt(2) == 0 || posTrunk == 0) || block2 != null && !block2.canBeReplacedByLeaves((IBlockAccess)world, x1, y1, z1)) continue;
                    world.func_147449_b(x1, y1, z1, (Block)Blocks.field_150362_t);
                }
            }
        }
        for (y1 = 0; y1 < height; ++y1) {
            Block block2 = world.func_147439_a(x, y + y1, z);
            if (block2 != null && !block2.isAir((IBlockAccess)world, x, y + y1, z) && !block2.isLeaves((IBlockAccess)world, x, y + y1, z) && !block2.equals(Blocks.field_150358_i) && !block2.equals(Blocks.field_150355_j)) continue;
            world.func_147449_b(x, y + y1, z, Blocks.field_150364_r);
        }
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int posTrunk = y1 - (y + height);
            canopyRadius = 2 - posTrunk / 2;
            for (int x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                for (int z1 = z - canopyRadius; z1 <= z + canopyRadius; ++z1) {
                    Block block2 = world.func_147439_a(x1, y1, z1);
                    if (block2 == null || !block2.isLeaves((IBlockAccess)world, x1, y1, z1)) continue;
                    if (rand.nextInt(4) == 0 && world.func_147437_c(x1 - 1, y1, z1)) {
                        this.generateVines(world, x1 - 1, y1, z1, 8);
                    }
                    if (rand.nextInt(4) == 0 && world.func_147437_c(x1 + 1, y1, z1)) {
                        this.generateVines(world, x1 + 1, y1, z1, 2);
                    }
                    if (rand.nextInt(4) == 0 && world.func_147437_c(x1, y1, z1 - 1)) {
                        this.generateVines(world, x1, y1, z1 - 1, 1);
                    }
                    if (rand.nextInt(4) != 0 || !world.func_147437_c(x1, y1, z1 + 1)) continue;
                    this.generateVines(world, x1, y1, z1 + 1, 4);
                }
            }
        }
        return true;
    }

    private void generateVines(World world, int x, int y, int z, int metadata) {
        world.func_147465_d(x, y, z, Blocks.field_150395_bd, metadata, 3);
        for (int i = 4; world.func_147437_c(x, --y, z) && i > 0; --i) {
            world.func_147465_d(x, y, z, Blocks.field_150395_bd, metadata, 3);
        }
    }
}

