/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.biome;

import com.google.common.base.Optional;
import extrabiomes.api.BiomeManager;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.DecorationSettings;
import extrabiomes.module.summa.biome.CustomBiomeDecorator;
import java.util.Random;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public abstract class ExtrabiomeGenBase
extends BiomeGenBase {
    protected BiomeSettings biomeSettings;
    protected BiomeDictionary.Type[] biomeTypeFlags;

    protected ExtrabiomeGenBase(BiomeSettings biomeSettings, BiomeDictionary.Type ... biomeTypeFlags) {
        super(biomeSettings.getID());
        this.biomeSettings = biomeSettings;
        this.biomeTypeFlags = biomeTypeFlags;
    }

    public BiomeSettings getBiomeSettings() {
        return this.biomeSettings;
    }

    public BiomeDictionary.Type[] getBiomeTypeFlags() {
        return this.biomeTypeFlags;
    }

    public abstract DecorationSettings getDecorationSettings();

    public BiomeDecorator func_76729_a() {
        try {
            return new CustomBiomeDecorator.Builder(this).loadSettings(this.getDecorationSettings()).build();
        }
        catch (Exception e) {
            LogHelper.severe("No decoration settings found for " + (Object)((Object)this), new Object[0]);
            return null;
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        Optional<? extends WorldGenerator> grassGen = BiomeManager.chooseRandomGrassGenforBiome(rand, this);
        if (grassGen.isPresent()) {
            return (WorldGenerator)grassGen.get();
        }
        return super.func_76730_b(rand);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        Optional<? extends WorldGenerator> treeGen = BiomeManager.chooseRandomTreeGenforBiome(rand, this);
        if (treeGen.isPresent() && treeGen.get() instanceof WorldGenAbstractTree) {
            return (WorldGenAbstractTree)treeGen.get();
        }
        return super.func_150567_a(rand);
    }

    public void canSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
    }
}

