/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.buildcraft;

import com.google.common.base.Optional;
import extrabiomes.helpers.LogHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.world.World;

public class BuildcraftAPI {
    private boolean modifyWorld = false;
    private static Optional<Method> generateSurfaceDeposit = Optional.absent();
    boolean useRandom = false;

    BuildcraftAPI() {
        Class<?> cls;
        try {
            cls = Class.forName("buildcraft.BuildCraftCore");
            Field fld = cls.getField("modifyWorld");
            this.modifyWorld = fld.getBoolean(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            cls = Class.forName("buildcraft.energy.OilPopulate");
            generateSurfaceDeposit = Optional.fromNullable((Object)cls.getMethod("generateSurfaceDeposit", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (Exception e) {
            try {
                cls = Class.forName("buildcraft.energy.OilPopulate");
                generateSurfaceDeposit = Optional.fromNullable((Object)cls.getMethod("generateSurfaceDeposit", World.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE));
                this.useRandom = true;
            }
            catch (Exception ex) {
                LogHelper.fine("Buildcraft Oil Generator could not be accessed. Extra oil in wastelands and mountainous deserts has been disabled.", new Object[0]);
                generateSurfaceDeposit = Optional.absent();
            }
        }
    }

    void generateSurfaceDeposit(World world, Random rand, int x, int y, int z, int radius) {
        try {
            if (this.useRandom) {
                ((Method)generateSurfaceDeposit.get()).invoke(null, world, rand, x, y, z, radius);
            } else {
                ((Method)generateSurfaceDeposit.get()).invoke(null, world, x, y, z, radius);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            LogHelper.fine("Buildcraft oil generation failed. Exception caught.", new Object[0]);
        }
    }

    boolean modifyWorld() {
        return this.modifyWorld;
    }
}

