/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.lib;

import com.google.common.collect.Maps;
import extrabiomes.utility.EnhancedConfiguration;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.config.Property;

public enum DecorationSettings {
    ALPINE(null, 7, null, 0, null, null, null, null, null, null, null, null, 4),
    AUTUMNWOODS(null, 6, null, 6, null, 3, null, null, null, null, null, null, 5),
    BIRCHFOREST(null, 7, null, 1, null, null, null, null, null, null, null, null, 6),
    EXTREMEJUNGLE(null, 50, null, 25, null, null, null, null, null, null, null, null, 7),
    FORESTEDHILLS(null, 7, null, 5, null, null, null, null, null, null, null, null, 5),
    FORESTEDISLAND(null, 7, 1, 3, null, null, null, null, null, null, null, null, 6),
    GLACIER(null, null, null, null, null, null, null, null, null, null, null, null, null),
    GREENHILLS(null, 1, null, null, null, null, null, null, null, null, null, null, 5),
    GREENSWAMP(4, 4, null, null, 0, 8, 10, null, 0, 0, 1, null, 6),
    ICEWASTELAND(null, 0, null, null, null, null, null, null, null, null, null, null, null),
    MARSH(null, 0, null, 32, null, null, 10, null, null, null, null, null, null),
    MEADOW(null, 0, 2, 12, null, null, null, null, null, null, null, null, 8),
    MINIJUNGLE(12, 15, null, null, null, 2, 70, null, null, null, 3, null, 7),
    MOUNTAINDESERT(null, 0, null, null, 2, null, 50, 10, null, null, null, null, null),
    MOUNTAINRIDGE(null, 0, null, 12, null, null, null, null, null, null, null, null, null),
    MOUNTAINTAIGA(null, 10, null, 1, null, null, null, null, null, null, null, null, 4),
    PINEFOREST(null, 10, null, 1, null, null, null, null, null, null, null, null, 4),
    RAINFOREST(null, 22, null, 4, null, null, null, null, null, null, null, null, 6),
    REDWOODFOREST(null, 7, null, null, null, null, null, null, null, null, null, null, null),
    REDWOODLUSH(null, 8, 1, null, null, null, null, null, null, null, null, null, 5),
    SAVANNA(null, 0, null, 17, null, null, null, null, null, null, null, null, 5),
    SHRUBLAND(null, 1, 1, 1, null, null, null, null, null, null, null, null, 4),
    SNOWYFOREST(null, 8, null, 4, null, null, null, null, null, null, null, null, null),
    SNOWYRAINFOREST(null, 17, null, 16, null, 2, null, null, null, null, null, null, null),
    TEMPORATERAINFOREST(null, 17, null, 16, null, 2, null, null, null, null, null, null, null),
    TUNDRA(null, null, null, 0, null, null, null, null, 0, 0, null, null, null),
    WASTELAND(null, null, null, 1, 3, null, null, null, null, null, null, null, null),
    WOODLANDS(null, 8, null, 3, null, null, null, null, null, null, null, null, 6),
    DEFAULT;

    private final Map<Decoration, Integer> settings = Maps.newHashMap();

    private DecorationSettings() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private DecorationSettings(Integer waterlily, Integer trees, Integer flowers, Integer grass, Integer deadBush, Integer mushrooms, Integer reeds, Integer cacti, Integer sand, Integer sand2, Integer clay, Integer bigMushrooms, Integer newFlowers) {
        this.initSetting(Decoration.WATERLILY, waterlily);
        this.initSetting(Decoration.TREES, trees);
        this.initSetting(Decoration.FLOWERS, flowers);
        this.initSetting(Decoration.GRASS, grass);
        this.initSetting(Decoration.DEADBUSH, deadBush);
        this.initSetting(Decoration.MUSHROOMS, mushrooms);
        this.initSetting(Decoration.REEDS, reeds);
        this.initSetting(Decoration.CACTI, cacti);
        this.initSetting(Decoration.SAND, sand);
        this.initSetting(Decoration.SAND2, sand2);
        this.initSetting(Decoration.CLAY, clay);
        this.initSetting(Decoration.BIGMUSHROOMS, bigMushrooms);
        this.initSetting(Decoration.NEW_FLOWERS, newFlowers);
    }

    private void initSetting(Decoration key, Integer val) {
        if (val != null && !val.equals(key.def)) {
            this.settings.put(key, val);
        }
    }

    public void load(EnhancedConfiguration configuration) {
        this.parseProperty(configuration, Decoration.WATERLILY);
        this.parseProperty(configuration, Decoration.TREES);
        this.parseProperty(configuration, Decoration.FLOWERS);
        this.parseProperty(configuration, Decoration.GRASS);
        this.parseProperty(configuration, Decoration.DEADBUSH);
        this.parseProperty(configuration, Decoration.MUSHROOMS);
        this.parseProperty(configuration, Decoration.REEDS);
        this.parseProperty(configuration, Decoration.CACTI);
        this.parseProperty(configuration, Decoration.SAND);
        this.parseProperty(configuration, Decoration.SAND2);
        this.parseProperty(configuration, Decoration.CLAY);
        this.parseProperty(configuration, Decoration.BIGMUSHROOMS);
        this.parseProperty(configuration, Decoration.NEW_FLOWERS);
    }

    private void parseProperty(EnhancedConfiguration configuration, Decoration decoration) {
        if (!this.settings.containsKey((Object)decoration)) {
            return;
        }
        Property property = configuration.get("decoration", this.toString() + decoration.key, this.settings.get((Object)decoration));
        this.settings.put(decoration, property.getInt());
    }

    public int getSetting(Decoration decoration) {
        if (this.settings.containsKey((Object)decoration)) {
            return this.settings.get((Object)decoration);
        }
        return decoration.def;
    }

    public Map<Decoration, Integer> getSettings() {
        return this.settings;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    public static enum Decoration {
        WATERLILY(".waterlily", 0),
        TREES(".trees", 0),
        FLOWERS(".flowers", 0),
        GRASS(".grass", 1),
        DEADBUSH(".deadBush", 0),
        MUSHROOMS(".mushrooms", 0),
        REEDS(".reeds", 0),
        CACTI(".cacti", 0),
        SAND(".sand", 1),
        SAND2(".sandTwo", 3),
        CLAY(".clay", 1),
        BIGMUSHROOMS(".bigMushrooms", 0),
        NEW_FLOWERS(".newFlowers", 0);

        public final String key;
        public final int def;

        private Decoration(String key, int def) {
            this.key = key;
            this.def = def;
        }
    }
}

