/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.helpers.ToolTipStringFormatter;
import extrabiomes.lib.BlockSettings;
import extrabiomes.subblocks.SubBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWaterPlant
extends Block {
    private BlockSettings settings;
    protected SubBlock[] subBlocks;
    protected String blockName;

    public BlockWaterPlant(BlockSettings settings, String name) {
        super(Material.field_151586_h);
        this.func_149675_a(true);
        this.func_149649_H();
        this.settings = settings;
        this.blockName = name;
        this.subBlocks = new SubBlock[16];
    }

    public BlockWaterPlant registerSubBlock(SubBlock childBlock, int metaData) throws Exception {
        if (this.subBlocks[metaData] != null) {
            throw new Exception("Subblock with metaData: " + metaData + ", already exists for " + this.blockName + ".");
        }
        childBlock.setBlock(this, metaData);
        this.subBlocks[metaData] = childBlock;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < this.subBlocks.length; ++i) {
            if (this.subBlocks[i] == null) continue;
            this.subBlocks[i].registerIcons(iconRegister);
        }
    }

    public IIcon func_149691_a(int side, int metaData) {
        if (this.subBlocks[metaData] != null) {
            return this.subBlocks[metaData].getIcon(side, metaData);
        }
        return null;
    }

    public String getLocalizedName(int metaData) {
        if (this.subBlocks[metaData] == null) {
            return "extrabiomes.invaliditem";
        }
        return this.func_149739_a() + "." + this.subBlocks[metaData].getUnlocalizedName();
    }

    public int func_149645_b() {
        return 6;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List itemList) {
        for (int i = 0; i < this.subBlocks.length; ++i) {
            if (this.subBlocks[i] == null) continue;
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        int metaData = world.func_72805_g(x, y, z);
        if (this.subBlocks[metaData] == null) {
            return false;
        }
        return this.subBlocks[metaData].canPlaceBlockAt(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int metaData = world.func_72805_g(x, y, z);
        if (this.subBlocks[metaData] == null) {
            return false;
        }
        return this.subBlocks[metaData].canBlockStay(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int metaData = world.func_72805_g(x, y, z);
        if (this.subBlocks[metaData] != null) {
            this.subBlocks[metaData].onNeighborBlockChange(world, x, y, z, neighbor, this);
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int silkTouch) {
        world.func_147449_b(x, y, z, Blocks.field_150355_j);
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int unused, ItemStack item) {
        if (item.func_77973_b() == this.settings.getItem()) {
            if (this.subBlocks[item.func_77960_j()] == null) {
                return false;
            }
            return this.subBlocks[item.func_77960_j()].canPlaceBlockAt(world, x, y, z);
        }
        return this.func_149707_d(world, x, y, z, unused);
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void addInformation(int metaData, List listOfLines) {
        String line;
        if (metaData < this.subBlocks.length && this.subBlocks[metaData] != null && !(line = I18n.func_135052_a((String)(this.func_149739_a() + "." + this.subBlocks[metaData].getUnlocalizedName() + ".description"), (Object[])new Object[0])).equals(this.func_149739_a() + "." + this.subBlocks[metaData].getUnlocalizedName() + ".description")) {
            if (listOfLines.size() > 0 && ((String)listOfLines.get(0)).length() > 20) {
                ToolTipStringFormatter.Format(line, listOfLines, ((String)listOfLines.get(0)).length() + 5);
            } else {
                ToolTipStringFormatter.Format(line, listOfLines);
            }
        }
    }
}

