/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.api.UseLogTurnerEvent;
import extrabiomes.blocks.BlockCustomLog;
import extrabiomes.blocks.BlockNewLog;
import extrabiomes.lib.BlockSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuarterLog
extends BlockLog {
    private static int renderId = 31;
    private final BarkOn barkOnSides;
    private BlockSettings settings;
    private HashMap<Integer, IIcon> textures;
    private IIcon[] textureArray = new IIcon[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private int index;

    private static Orientation determineOrientation(World world, int x, int y, int z, EntityLivingBase entity) {
        int direction = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        switch (direction) {
            case 0: 
            case 1: {
                return Orientation.UD;
            }
            case 2: 
            case 3: {
                return Orientation.NS;
            }
        }
        return Orientation.EW;
    }

    public static void setRenderId(int renderId) {
        BlockQuarterLog.renderId = renderId;
    }

    public BarkOn getBarkOnSides() {
        return this.barkOnSides;
    }

    public BlockQuarterLog(BlockSettings settings, int index, BarkOn barkOnSides) {
        this.settings = settings;
        this.barkOnSides = barkOnSides;
        this.index = index;
        this.textures = new HashMap();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textureArray[0] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "logredwoodsideleft");
        this.textureArray[1] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "logredwoodsideright");
        this.textureArray[2] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "redwoodtopleft");
        this.textureArray[3] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "redwoodtopright");
        this.textureArray[4] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "redwoodbottomleft");
        this.textureArray[5] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "redwoodbottomright");
        this.textureArray[6] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "redwoodsideleft");
        this.textureArray[7] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "redwoodsideright");
        this.textureArray[8] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "logfirsideleft");
        this.textureArray[9] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "logfirsideright");
        this.textureArray[10] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "firtopleft");
        this.textureArray[11] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "firtopright");
        this.textureArray[12] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "firbottomleft");
        this.textureArray[13] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "firbottomright");
        this.textureArray[14] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "firsideleft");
        this.textureArray[15] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "firsideright");
        this.textureArray[16] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "logoaksideleft");
        this.textureArray[17] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "logoaksideright");
        this.textureArray[18] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "oaktopleft");
        this.textureArray[19] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "oaktopright");
        this.textureArray[20] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "oakbottomleft");
        this.textureArray[21] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "oakbottomright");
        this.textureArray[22] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "oaksideleft");
        this.textureArray[23] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "oaksideright");
        this.setupTextures(this.index);
    }

    public void setupTextures(int index) {
        this.textures.put(index, this.textureArray[0]);
        this.textures.put(index + 1, this.textureArray[1]);
        this.textures.put(index + 2, this.textureArray[8]);
        this.textures.put(index + 3, this.textureArray[9]);
        this.textures.put(index + 4, this.textureArray[16]);
        this.textures.put(index + 5, this.textureArray[17]);
        this.textures.put(index + 16, this.textureArray[2]);
        this.textures.put(index + 17, this.textureArray[3]);
        this.textures.put(index + 18, this.textureArray[10]);
        this.textures.put(index + 19, this.textureArray[11]);
        this.textures.put(index + 20, this.textureArray[18]);
        this.textures.put(index + 21, this.textureArray[19]);
        this.textures.put(index + 32, this.textureArray[4]);
        this.textures.put(index + 33, this.textureArray[5]);
        this.textures.put(index + 34, this.textureArray[12]);
        this.textures.put(index + 35, this.textureArray[13]);
        this.textures.put(index + 36, this.textureArray[20]);
        this.textures.put(index + 37, this.textureArray[21]);
        this.textures.put(index + 48, this.textureArray[6]);
        this.textures.put(index + 49, this.textureArray[7]);
        this.textures.put(index + 50, this.textureArray[14]);
        this.textures.put(index + 51, this.textureArray[15]);
        this.textures.put(index + 52, this.textureArray[22]);
        this.textures.put(index + 53, this.textureArray[23]);
    }

    public IIcon func_149691_a(int side, int metadata) {
        int orientation = metadata & 0xC;
        int type = metadata & 3;
        if (type > 2) {
            type = 0;
        }
        int offset = 0;
        switch (this.barkOnSides) {
            case SE: {
                offset = this.getSETextureOffset(side, orientation);
                break;
            }
            case SW: {
                offset = this.getSWTextureOffset(side, orientation);
                break;
            }
            case NE: {
                offset = this.getNETextureOffset(side, orientation);
                break;
            }
            case NW: {
                offset = this.getNWTextureOffset(side, orientation);
            }
        }
        return this.textures.get(this.index + offset + type * 2);
    }

    private int getNETextureOffset(int side, int orientation) {
        int offset = 0;
        if (orientation == 0) {
            switch (side) {
                case 0: 
                case 1: {
                    offset = 17;
                    break;
                }
                case 2: {
                    offset = 0;
                    break;
                }
                case 3: {
                    offset = 49;
                    break;
                }
                case 4: {
                    offset = 48;
                    break;
                }
                default: {
                    offset = 1;
                    break;
                }
            }
        } else if (orientation == 4) {
            switch (side) {
                case 0: {
                    offset = 49;
                    break;
                }
                case 1: {
                    offset = 0;
                    break;
                }
                case 2: {
                    offset = 1;
                    break;
                }
                case 3: {
                    offset = 48;
                    break;
                }
                case 4: {
                    offset = 16;
                    break;
                }
                default: {
                    offset = 17;
                    break;
                }
            }
        } else if (orientation == 8) {
            switch (side) {
                case 0: {
                    offset = 49;
                    break;
                }
                case 2: {
                    offset = 16;
                    break;
                }
                case 3: {
                    offset = 17;
                    break;
                }
                case 4: {
                    offset = 49;
                    break;
                }
                default: {
                    offset = 1;
                }
            }
        }
        return offset;
    }

    private Block getNextBlock() {
        if (this == BarkOn.SW.block) {
            return BarkOn.NE.block;
        }
        if (this == BarkOn.NE.block) {
            return BarkOn.NW.block;
        }
        if (this == BarkOn.NW.block) {
            return BarkOn.SE.block;
        }
        return BarkOn.SW.block;
    }

    private int getNWTextureOffset(int side, int orientation) {
        int offset = 0;
        if (orientation == 0) {
            switch (side) {
                case 0: 
                case 1: {
                    offset = 16;
                    break;
                }
                case 2: {
                    offset = 1;
                    break;
                }
                case 3: {
                    offset = 48;
                    break;
                }
                case 4: {
                    offset = 0;
                    break;
                }
                default: {
                    offset = 49;
                    break;
                }
            }
        } else if (orientation == 4) {
            switch (side) {
                case 0: {
                    offset = 48;
                    break;
                }
                case 1: {
                    offset = 1;
                    break;
                }
                case 2: {
                    offset = 49;
                    break;
                }
                case 3: {
                    offset = 0;
                    break;
                }
                case 4: {
                    offset = 17;
                    break;
                }
                default: {
                    offset = 16;
                    break;
                }
            }
        } else if (orientation == 8) {
            switch (side) {
                case 0: {
                    offset = 48;
                    break;
                }
                case 1: {
                    offset = 0;
                    break;
                }
                case 2: {
                    offset = 17;
                    break;
                }
                case 3: {
                    offset = 16;
                    break;
                }
                case 4: {
                    offset = 1;
                    break;
                }
                default: {
                    offset = 49;
                }
            }
        }
        return offset;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item pickItem;
        int meta = world.func_72805_g(x, y, z);
        int pickMeta = 0;
        switch (meta) {
            case 1: {
                pickItem = BlockSettings.NEWLOG.getItem();
                pickMeta = BlockNewLog.BlockType.REDWOOD.metadata();
                break;
            }
            case 2: {
                pickItem = ItemBlock.func_150898_a((Block)Blocks.field_150364_r);
                pickMeta = 0;
                break;
            }
            default: {
                pickItem = BlockSettings.CUSTOMLOG.getItem();
                pickMeta = BlockCustomLog.BlockType.FIR.metadata();
            }
        }
        ItemStack itemstack = new ItemStack(pickItem, 1, pickMeta);
        return itemstack;
    }

    public int func_149645_b() {
        return renderId;
    }

    private int getSETextureOffset(int side, int orientation) {
        int offset = 0;
        if (orientation == 0) {
            switch (side) {
                case 0: 
                case 1: {
                    offset = 33;
                    break;
                }
                case 2: {
                    offset = 48;
                    break;
                }
                case 3: {
                    offset = 1;
                    break;
                }
                case 4: {
                    offset = 49;
                    break;
                }
                default: {
                    offset = 0;
                    break;
                }
            }
        } else if (orientation == 4) {
            switch (side) {
                case 0: {
                    offset = 0;
                    break;
                }
                case 1: {
                    offset = 49;
                    break;
                }
                case 2: {
                    offset = 48;
                    break;
                }
                case 3: {
                    offset = 1;
                    break;
                }
                case 4: {
                    offset = 33;
                    break;
                }
                default: {
                    offset = 32;
                    break;
                }
            }
        } else if (orientation == 8) {
            switch (side) {
                case 0: {
                    offset = 1;
                    break;
                }
                case 1: {
                    offset = 49;
                    break;
                }
                case 2: {
                    offset = 32;
                    break;
                }
                case 3: {
                    offset = 33;
                    break;
                }
                case 4: {
                    offset = 48;
                    break;
                }
                default: {
                    offset = 0;
                }
            }
        }
        return offset;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List list) {
    }

    private int getSWTextureOffset(int side, int orientation) {
        int offset = 0;
        if (orientation == 0) {
            switch (side) {
                case 0: 
                case 1: {
                    offset = 32;
                    break;
                }
                case 2: {
                    offset = 49;
                    break;
                }
                case 3: {
                    offset = 0;
                    break;
                }
                case 4: {
                    offset = 1;
                    break;
                }
                default: {
                    offset = 48;
                    break;
                }
            }
        } else if (orientation == 4) {
            switch (side) {
                case 0: {
                    offset = 1;
                    break;
                }
                case 1: {
                    offset = 48;
                    break;
                }
                case 2: {
                    offset = 0;
                    break;
                }
                case 3: {
                    offset = 49;
                    break;
                }
                case 4: {
                    offset = 32;
                    break;
                }
                default: {
                    offset = 33;
                    break;
                }
            }
        } else if (orientation == 8) {
            switch (side) {
                case 0: {
                    offset = 0;
                    break;
                }
                case 1: {
                    offset = 48;
                    break;
                }
                case 2: {
                    offset = 33;
                    break;
                }
                case 3: {
                    offset = 32;
                    break;
                }
                case 4: {
                    offset = 0;
                    break;
                }
                default: {
                    offset = 48;
                }
            }
        }
        return offset;
    }

    public Item func_149650_a(int metadata, Random rand, int unused) {
        switch (metadata &= 3) {
            case 1: {
                return BlockSettings.CUSTOMLOG.getItem();
            }
            case 2: {
                return ItemBlock.func_150898_a((Block)Blocks.field_150364_r);
            }
        }
        return BlockSettings.NEWLOG.getItem();
    }

    public int func_149692_a(int metadata) {
        switch (metadata &= 3) {
            case 0: {
                return BlockNewLog.BlockType.REDWOOD.metadata();
            }
            case 2: {
                return 0;
            }
        }
        return BlockCustomLog.BlockType.FIR.metadata();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int thisMeta;
        int eastMeta;
        Block eastBlock;
        int westMeta;
        Block westBlock;
        int southMeta;
        Block southBlock;
        int northMeta;
        Block northBlock;
        super.func_149689_a(world, x, y, z, entity, stack);
        Orientation orientation = BlockQuarterLog.determineOrientation(world, x, y, z, entity);
        if (orientation == Orientation.UD) {
            northBlock = world.func_147439_a(x, y, z - 1);
            northMeta = world.func_72805_g(x, y, z - 1);
            southBlock = world.func_147439_a(x, y, z + 1);
            southMeta = world.func_72805_g(x, y, z + 1);
            westBlock = world.func_147439_a(x - 1, y, z);
            westMeta = world.func_72805_g(x - 1, y, z);
            eastBlock = world.func_147439_a(x + 1, y, z);
            eastMeta = world.func_72805_g(x + 1, y, z);
            thisMeta = world.func_72805_g(x, y, z);
            if (thisMeta == northMeta) {
                if (northBlock == BarkOn.NW.block) {
                    world.func_147465_d(x, y, z, BarkOn.SW.block, thisMeta, 3);
                    return;
                }
                if (northBlock == BarkOn.NE.block) {
                    world.func_147465_d(x, y, z, BarkOn.SE.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == eastMeta) {
                if (eastBlock == BarkOn.NE.block) {
                    world.func_147465_d(x, y, z, BarkOn.NW.block, thisMeta, 3);
                    return;
                }
                if (eastBlock == BarkOn.SE.block) {
                    world.func_147465_d(x, y, z, BarkOn.SW.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == southMeta) {
                if (southBlock == BarkOn.SW.block) {
                    world.func_147465_d(x, y, z, BarkOn.NW.block, thisMeta, 3);
                    return;
                }
                if (southBlock == BarkOn.SE.block) {
                    world.func_147465_d(x, y, z, BarkOn.NE.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == westMeta) {
                if (westBlock == BarkOn.NW.block) {
                    world.func_147465_d(x, y, z, BarkOn.NE.block, thisMeta, 3);
                    return;
                }
                if (westBlock == BarkOn.SW.block) {
                    world.func_147465_d(x, y, z, BarkOn.SE.block, thisMeta, 3);
                    return;
                }
            }
        }
        if (orientation == Orientation.NS) {
            Block upBlock = world.func_147439_a(x, y + 1, z);
            int upMeta = world.func_72805_g(x, y + 1, z);
            Block downBlock = world.func_147439_a(x, y - 1, z);
            int downMeta = world.func_72805_g(x, y - 1, z);
            westBlock = world.func_147439_a(x - 1, y, z);
            westMeta = world.func_72805_g(x - 1, y, z);
            eastBlock = world.func_147439_a(x + 1, y, z);
            eastMeta = world.func_72805_g(x + 1, y, z);
            thisMeta = world.func_72805_g(x, y, z);
            if (thisMeta == upMeta) {
                if (upBlock == BarkOn.NW.block) {
                    world.func_147465_d(x, y, z, BarkOn.SW.block, thisMeta, 3);
                    return;
                }
                if (upBlock == BarkOn.NE.block) {
                    world.func_147465_d(x, y, z, BarkOn.SE.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == eastMeta) {
                if (eastBlock == BarkOn.NE.block) {
                    world.func_147465_d(x, y, z, BarkOn.NW.block, thisMeta, 3);
                    return;
                }
                if (eastBlock == BarkOn.SE.block) {
                    world.func_147465_d(x, y, z, BarkOn.SW.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == downMeta) {
                if (downBlock == BarkOn.SW.block) {
                    world.func_147465_d(x, y, z, BarkOn.NW.block, thisMeta, 3);
                    return;
                }
                if (downBlock == BarkOn.SE.block) {
                    world.func_147465_d(x, y, z, BarkOn.NE.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == westMeta) {
                if (westBlock == BarkOn.NW.block) {
                    world.func_147465_d(x, y, z, BarkOn.NE.block, thisMeta, 3);
                    return;
                }
                if (westBlock == BarkOn.SW.block) {
                    world.func_147465_d(x, y, z, BarkOn.SE.block, thisMeta, 3);
                    return;
                }
            }
        }
        if (orientation == Orientation.EW) {
            northBlock = world.func_147439_a(x, y, z - 1);
            northMeta = world.func_72805_g(x, y, z - 1);
            southBlock = world.func_147439_a(x, y, z + 1);
            southMeta = world.func_72805_g(x, y, z + 1);
            Block upBlock = world.func_147439_a(x, y + 1, z);
            int upMeta = world.func_72805_g(x, y + 1, z);
            Block downBlock = world.func_147439_a(x, y - 1, z);
            int downMeta = world.func_72805_g(x, y - 1, z);
            thisMeta = world.func_72805_g(x, y, z);
            if (thisMeta == northMeta) {
                if (northBlock == BarkOn.SW.block) {
                    world.func_147465_d(x, y, z, BarkOn.SE.block, thisMeta, 3);
                    return;
                }
                if (northBlock == BarkOn.NE.block) {
                    world.func_147465_d(x, y, z, BarkOn.NW.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == upMeta) {
                if (upBlock == BarkOn.NW.block) {
                    world.func_147465_d(x, y, z, BarkOn.SE.block, thisMeta, 3);
                    return;
                }
                if (upBlock == BarkOn.NE.block) {
                    world.func_147465_d(x, y, z, BarkOn.SW.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == southMeta) {
                if (southBlock == BarkOn.SE.block) {
                    world.func_147465_d(x, y, z, BarkOn.SW.block, thisMeta, 3);
                    return;
                }
                if (southBlock == BarkOn.NW.block) {
                    world.func_147465_d(x, y, z, BarkOn.NE.block, thisMeta, 3);
                    return;
                }
            }
            if (thisMeta == downMeta) {
                if (downBlock == BarkOn.SW.block) {
                    world.func_147465_d(x, y, z, BarkOn.NE.block, thisMeta, 3);
                    return;
                }
                if (downBlock == BarkOn.SE.block) {
                    world.func_147465_d(x, y, z, BarkOn.NW.block, thisMeta, 3);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onUseLogTurnerEvent(UseLogTurnerEvent event) {
        Block block = event.world.func_147439_a(event.x, event.y, event.z);
        if (block == this) {
            Block wood = Blocks.field_150364_r;
            event.world.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), wood.field_149762_H.field_150501_a, (wood.field_149762_H.func_150497_c() + 1.0f) / 2.0f, wood.field_149762_H.func_150494_d() * 1.55f);
            if (!event.world.field_72995_K) {
                int metadata = event.world.func_72805_g(event.x, event.y, event.z);
                int orientation = metadata & 0xC;
                int type = metadata & 3;
                int n = orientation == 0 ? 4 : (orientation = orientation == 4 ? 8 : 0);
                if (orientation == 0) {
                    block = this.getNextBlock();
                }
                event.world.func_147465_d(event.x, event.y, event.z, block, type | orientation, 3);
            }
            event.setHandled();
            event.setCanceled(true);
        }
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    protected boolean func_149700_E() {
        return false;
    }

    private static enum Orientation {
        UD,
        NS,
        EW;

    }

    public static enum BlockType {
        REDWOOD(0),
        FIR(1),
        OAK(2);

        private final int metadata;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }
    }

    public static enum BarkOn {
        SW,
        SE,
        NW,
        NE;

        private Block block;
    }
}

