/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.helpers.ToolTipStringFormatter;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.lib.SaplingSettings;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenBaldCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleShrub;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleTree;
import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import extrabiomes.module.summa.worldgen.WorldGenRainbowEucalyptusTree;
import extrabiomes.module.summa.worldgen.WorldGenSakuraBlossomTree;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;

public class BlockNewSapling
extends BlockFlower {
    static int saplingLifespan = 5000;
    private IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null};
    private static final int METADATA_BITMASK = 7;
    private static final int METADATA_MARKBIT = 8;
    private static Block forestrySoil;

    private static boolean isEnoughLightToGrow(World world, int x, int y, int z) {
        return world.func_72957_l(x, y, z) >= 9;
    }

    private static boolean isMarkedMetadata(int metadata) {
        return (metadata & 8) != 0;
    }

    private static int markedMetadata(int metadata) {
        return metadata | 8;
    }

    public static void setForestrySoil(Block soil) {
        forestrySoil = soil;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 7;
    }

    public BlockNewSapling() {
        super(0);
        float var3 = 0.4f;
        this.func_149676_a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegistry) {
        this.textures[0] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingbaldcypress");
        this.textures[1] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingjapanesemaple");
        this.textures[2] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingjapanesemapleshrub");
        this.textures[3] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingrainboweucalyptus");
        this.textures[4] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingsakura");
    }

    private void attemptGrowTree(World world, int x, int y, int z, Random rand) {
        if (BlockNewSapling.isEnoughLightToGrow(world, x, y + 1, z) && rand.nextInt(7) == 0) {
            int metadata = world.func_72805_g(x, y, z);
            if (!BlockNewSapling.isMarkedMetadata(metadata)) {
                world.func_72921_c(x, y, z, BlockNewSapling.markedMetadata(metadata), 3);
            } else {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    protected boolean canThisPlantGrowOnThisBlock(Block block) {
        return TreeSoilRegistry.isValidSoil(block);
    }

    public int func_149692_a(int metadata) {
        return BlockNewSapling.unmarkedMetadata(metadata);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (this.textures[metadata = BlockNewSapling.unmarkedMetadata(metadata)] == null) {
            metadata = 0;
        }
        return this.textures[metadata];
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random rand) {
        int marked = world.func_72805_g(x, y, z);
        if ((marked & 8) == 0) {
            world.func_72921_c(x, y, z, marked | 8, 4);
        } else {
            this.growTree(world, x, y, z, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void growTree(World world, int x, int y, int z, Random rand) {
        boolean isForestryFarmed;
        int metadata = BlockNewSapling.unmarkedMetadata(world.func_72805_g(x, y, z));
        WorldGenNewTreeBase tree = null;
        int x1 = 0;
        int z1 = 0;
        boolean isHuge = false;
        boolean bl = isForestryFarmed = world.func_147439_a(x, y - 1, z) == forestrySoil;
        if (metadata == BlockType.BALD_CYPRESS.metadata() || metadata == BlockType.RAINBOW_EUCALYPTUS.metadata()) {
            for (x1 = 0; x1 >= -1; --x1) {
                for (z1 = 0; z1 >= -1; --z1) {
                    if (!this.isSameSapling(world, x + x1, y, z + z1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z + z1, metadata) || !this.isSameSapling(world, x + x1, y, z + z1 + 1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z + z1 + 1, metadata)) continue;
                    tree = metadata == BlockType.BALD_CYPRESS.metadata() ? new WorldGenBaldCypressTree(true) : new WorldGenRainbowEucalyptusTree(true);
                    isHuge = true;
                    break;
                }
                if (tree == null) {
                    continue;
                }
                break;
            }
        } else {
            tree = metadata == BlockType.JAPANESE_MAPLE.metadata() ? new WorldGenJapaneseMapleTree(true) : (metadata == BlockType.SAKURA_BLOSSOM.metadata() ? new WorldGenSakuraBlossomTree(true) : new WorldGenJapaneseMapleShrub(true));
        }
        if (tree != null) {
            if (isHuge) {
                world.func_147449_b(x + x1, y, z + z1, Blocks.field_150350_a);
                world.func_147449_b(x + x1 + 1, y, z + z1, Blocks.field_150350_a);
                world.func_147449_b(x + x1, y, z + z1 + 1, Blocks.field_150350_a);
                world.func_147449_b(x + x1 + 1, y, z + z1 + 1, Blocks.field_150350_a);
            } else {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
            if (!tree.func_76484_a(world, rand, x + x1, y, z + z1)) {
                if (isHuge) {
                    world.func_147465_d(x + x1, y, z + z1, (Block)this, metadata, 3);
                    world.func_147465_d(x + x1 + 1, y, z + z1, (Block)this, metadata, 3);
                    world.func_147465_d(x + x1, y, z + z1 + 1, (Block)this, metadata, 3);
                    world.func_147465_d(x + x1 + 1, y, z + z1 + 1, (Block)this, metadata, 3);
                } else {
                    world.func_147465_d(x, y, z, (Block)this, metadata, 3);
                }
            } else if (isForestryFarmed) {
                if (isHuge) {
                    world.func_147449_b(x + x1, y - 1, z + z1, (Block)Blocks.field_150354_m);
                    world.func_147449_b(x + x1 + 1, y - 1, z + z1, (Block)Blocks.field_150354_m);
                    world.func_147449_b(x + x1, y - 1, z + z1 + 1, (Block)Blocks.field_150354_m);
                    world.func_147449_b(x + x1 + 1, y - 1, z + z1 + 1, (Block)Blocks.field_150354_m);
                } else {
                    world.func_147449_b(x, y - 1, z, (Block)Blocks.field_150354_m);
                }
            }
        }
    }

    public boolean isSameSapling(World world, int x, int y, int z, int metadata) {
        return world.func_147439_a(x, y, z) == this && BlockNewSapling.unmarkedMetadata(world.func_72805_g(x, y, z)) == metadata;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            this.attemptGrowTree(world, x, y, z, rand);
        }
    }

    public static int getSaplingLifespan() {
        return saplingLifespan;
    }

    public static void setSaplingLifespan(int life) {
        saplingLifespan = life > 0 ? life : 0;
    }

    @SubscribeEvent
    public void itemExpiring(ItemExpireEvent event) {
        if (event.entityItem.func_92059_d().func_77973_b() == ItemBlock.func_150898_a((Block)this)) {
            int count = event.entityItem.func_92059_d().field_77994_a;
            for (int i = 0; i < count; ++i) {
                double ratio;
                int metadata = BlockNewSapling.unmarkedMetadata(event.entityItem.func_92059_d().func_77960_j());
                int posX = (int)Math.floor(event.entityItem.field_70142_S);
                int posY = (int)Math.floor(event.entityItem.field_70137_T);
                int posZ = (int)Math.floor(event.entityItem.field_70136_U);
                double chance = event.entityItem.field_70170_p.field_73012_v.nextDouble() * 100.0;
                if (!this.canThisPlantGrowOnThisBlock(event.entityItem.field_70170_p.func_147439_a(posX, posY - 1, posZ))) continue;
                double d = ratio = !GeneralSettings.bigTreeSaplingDropModifier ? 1.0 : 4.0;
                if (metadata == BlockType.BALD_CYPRESS.metadata() && chance <= SaplingSettings.BALD_CYPRESS.chance() * ratio) {
                    this.plant2x2Sapling(posX, posY, posZ, event.entityItem.field_70170_p, event.entityItem.func_92059_d());
                    continue;
                }
                if (metadata == BlockType.RAINBOW_EUCALYPTUS.metadata() && chance <= SaplingSettings.RAINBOW_EUCALYPTUS.chance() * ratio) {
                    this.plant2x2Sapling(posX, posY, posZ, event.entityItem.field_70170_p, event.entityItem.func_92059_d());
                    continue;
                }
                if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.JAPANESE_MAPLE.metadata() && chance <= SaplingSettings.JAPANESE_MAPLE.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, (Block)this, metadata, 2);
                    continue;
                }
                if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.JAPANESE_MAPLE_SHRUB.metadata() && chance <= SaplingSettings.JAPANESE_MAPLE_SHRUB.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, (Block)this, metadata, 2);
                    continue;
                }
                if (!event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) || metadata != BlockType.SAKURA_BLOSSOM.metadata || !(chance <= SaplingSettings.SAKURA_BLOSSOM.chance())) continue;
                event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, (Block)this, metadata, 2);
            }
        }
    }

    private void plant2x2Sapling(int x, int y, int z, World world, ItemStack sapling) {
        int metadata = sapling.func_77960_j();
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x + 1, y, z) || this.isSameSaplingBlock(x + 1, y, z, world, sapling)) && (world.func_147437_c(x + 1, y, z + 1) || this.isSameSaplingBlock(x + 1, y, z + 1, world, sapling)) && (world.func_147437_c(x, y, z + 1) || this.isSameSaplingBlock(x, y, z + 1, world, sapling)) && world.func_147437_c(x, y, z) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x + 1, y - 1, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x + 1, y - 1, z + 1)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z + 1))) {
            world.func_147465_d(x, y, z, (Block)this, metadata, 2);
            world.func_147465_d(x + 1, y, z, (Block)this, metadata, 2);
            world.func_147465_d(x + 1, y, z + 1, (Block)this, metadata, 2);
            world.func_147465_d(x, y, z + 1, (Block)this, metadata, 2);
            return;
        }
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x, y, z + 1) || this.isSameSaplingBlock(x, y, z + 1, world, sapling)) && (world.func_147437_c(x - 1, y, z + 1) || this.isSameSaplingBlock(x - 1, y, z + 1, world, sapling)) && (world.func_147437_c(x - 1, y, z) || this.isSameSaplingBlock(x - 1, y, z, world, sapling)) && world.func_147437_c(x, y, z) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z + 1)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x - 1, y - 1, z + 1)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x - 1, y - 1, z))) {
            world.func_147465_d(x, y, z, (Block)this, metadata, 2);
            world.func_147465_d(x, y, z + 1, (Block)this, metadata, 2);
            world.func_147465_d(x - 1, y, z + 1, (Block)this, metadata, 2);
            world.func_147465_d(x - 1, y, z, (Block)this, metadata, 2);
            return;
        }
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x - 1, y, z) || this.isSameSaplingBlock(x - 1, y, z, world, sapling)) && (world.func_147437_c(x - 1, y, z - 1) || this.isSameSaplingBlock(x - 1, y, z - 1, world, sapling)) && (world.func_147437_c(x, y, z - 1) || this.isSameSaplingBlock(x, y, z - 1, world, sapling)) && world.func_147437_c(x, y, z) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x - 1, y - 1, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x - 1, y - 1, z - 1)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z - 1))) {
            world.func_147465_d(x, y, z, (Block)this, metadata, 2);
            world.func_147465_d(x - 1, y, z, (Block)this, metadata, 2);
            world.func_147465_d(x - 1, y, z - 1, (Block)this, metadata, 2);
            world.func_147465_d(x, y, z - 1, (Block)this, metadata, 2);
            return;
        }
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x, y, z - 1) || this.isSameSaplingBlock(x, y, z - 1, world, sapling)) && (world.func_147437_c(x + 1, y, z - 1) || this.isSameSaplingBlock(x + 1, y, z - 1, world, sapling)) && (world.func_147437_c(x + 1, y, z) || this.isSameSaplingBlock(x + 1, y, z, world, sapling)) && world.func_147437_c(x, y, z) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z - 1)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x + 1, y - 1, z - 1)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x + 1, y - 1, z))) {
            world.func_147465_d(x, y, z, (Block)this, metadata, 2);
            world.func_147465_d(x, y, z - 1, (Block)this, metadata, 2);
            world.func_147465_d(x + 1, y, z - 1, (Block)this, metadata, 2);
            world.func_147465_d(x + 1, y, z, (Block)this, metadata, 2);
            return;
        }
    }

    private boolean isSameSaplingBlock(int x, int y, int z, World world, ItemStack sapling) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        return block != null && block != Blocks.field_150350_a && sapling.func_77973_b() == ItemBlock.func_150898_a((Block)this) && sapling.func_77960_j() == metadata;
    }

    @SubscribeEvent
    public void itemEntering(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityItem && !event.world.field_72995_K && ((EntityItem)event.entity).func_92059_d().func_77973_b() == ItemBlock.func_150898_a((Block)this)) {
            ((EntityItem)event.entity).lifespan = saplingLifespan;
        }
    }

    public static void addInformation(int metaData, List listOfLines) {
        BlockType test = BlockType.values()[metaData];
        if (test != null) {
            String[] lines = test.toolTipData();
            if (lines.length < 1) {
                return;
            }
            if (lines.length > 1) {
                for (int line = 1; line < lines.length; ++line) {
                    listOfLines.add(lines[line]);
                }
                if (lines[0] != "") {
                    listOfLines.add("");
                }
            }
            if (lines[0] != "") {
                ToolTipStringFormatter.Format(LanguageRegistry.instance().getStringLocalization("extrabiomes.planting_guide"), listOfLines);
                listOfLines.add(lines[0]);
            }
        }
    }

    public static enum BlockType {
        BALD_CYPRESS(0, new String[]{"2x2"}),
        JAPANESE_MAPLE(1, new String[]{"1x1"}),
        JAPANESE_MAPLE_SHRUB(2, new String[]{"1x1"}),
        RAINBOW_EUCALYPTUS(3, new String[]{"2x2"}),
        SAKURA_BLOSSOM(4, new String[]{"1x1"});

        private final int metadata;
        private final String[] toolTipData;

        private BlockType(int metadata, String[] data) {
            this.metadata = metadata;
            this.toolTipData = data;
        }

        public int metadata() {
            return this.metadata;
        }

        public String[] toolTipData() {
            return this.toolTipData;
        }
    }
}

