/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.Element;
import extrabiomes.lib.GeneralSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockNewLeaves
extends BlockLeavesBase
implements IShearable {
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;
    int[] adjacentTreeBlocks;
    private IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null, null, null, null, null};

    private static int calcSmoothedBiomeFoliageColor(IBlockAccess iBlockAccess, int x, int z) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int z1 = -1; z1 <= 1; ++z1) {
            for (int x1 = -1; x1 <= 1; ++x1) {
                int foliageColor = iBlockAccess.func_72807_a(x + x1, z + z1).func_150571_c(x + x1, 96, z + z1);
                red += (foliageColor & 0xFF0000) >> 16;
                green += (foliageColor & 0xFF00) >> 8;
                blue += foliageColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    private static int setDecayOnMetadata(int metadata) {
        return metadata | 8;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 3;
    }

    public BlockNewLeaves(Material material, boolean useFastGraphics) {
        super(material, useFastGraphics);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures[0] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesbaldcypressfancy");
        this.textures[1] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesbaldcypressfast");
        this.textures[2] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesjapanesemaplefancy");
        this.textures[3] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesjapanesemaplefast");
        this.textures[4] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesjapanesemapleshrubfancy");
        this.textures[5] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesjapanesemapleshrubfast");
        this.textures[6] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesrainboweucalyptusfancy");
        this.textures[7] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesrainboweucalyptusfast");
        this.textures[8] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesbaldcypress");
        this.textures[9] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesjapanesemaple");
        this.textures[10] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesjapanesemapleshrub");
        this.textures[11] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesrainboweucalyptus");
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, BlockNewLeaves.setDecayOnMetadata(world.func_72805_g(x, y, z)), 3);
    }

    public void func_149749_a(World world, int x, int y, int z, Block _block, int metadata) {
        boolean leafDecayRadius = true;
        int chuckCheckRadius = 2;
        if (!world.func_72904_c(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            return;
        }
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -1; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    Block block = world.func_147439_a(x + x1, y + y1, z + z1);
                    if (block == null) continue;
                    block.beginLeavesDecay(world, x + x1, y + y1, z + z1);
                }
            }
        }
    }

    public int func_149720_d(IBlockAccess iBlockAccess, int x, int y, int z) {
        int metadata = BlockNewLeaves.unmarkedMetadata(iBlockAccess.func_72805_g(x, y, z));
        if (metadata == BlockType.JAPANESE_MAPLE.metadata() || metadata == BlockType.JAPANESE_MAPLE_SHRUB.metadata()) {
            return this.func_149741_i(metadata);
        }
        return BlockNewLeaves.calcSmoothedBiomeFoliageColor(iBlockAccess, x, z);
    }

    public int func_149692_a(int metadata) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingMetadata() : 0;
    }

    private void doSaplingDrop(World world, int x, int y, int z, int metadata, int par7) {
        Item itemDropped = this.func_149650_a(metadata, world.field_73012_v, par7);
        int damageDropped = this.func_149692_a(metadata);
        this.func_149642_a(world, x, y, z, new ItemStack(itemDropped, 1, damageDropped));
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int par7) {
        this.leafTypeDropper((IBlockAccess)world, world, x, y, z, metadata, par7);
    }

    private void leafTypeDropper(IBlockAccess iBlockAccess, World world, int x, int y, int z, int metadata, int par7) {
        int damageValue = BlockNewLeaves.unmarkedMetadata(iBlockAccess.func_72805_g(x, y, z));
        if (world.field_72995_K) {
            return;
        }
        if (damageValue == BlockType.JAPANESE_MAPLE.metadata || damageValue == BlockType.JAPANESE_MAPLE_SHRUB.metadata || !GeneralSettings.bigTreeSaplingDropModifier) {
            if (world.field_73012_v.nextInt(20) == 0) {
                this.doSaplingDrop(world, x, y, z, metadata, par7);
            }
        } else if (world.field_73012_v.nextInt(90) == 0) {
            this.doSaplingDrop(world, x, y, z, metadata, par7);
        }
    }

    public int func_149635_D() {
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.textures[BlockNewLeaves.unmarkedMetadata(metadata) * 2 + (!this.func_149662_c() ? 0 : 1)];
    }

    public IIcon getIconBetterLeaves(int metadata, float randomIndex) {
        return this.textures[8 + BlockNewLeaves.unmarkedMetadata(metadata)];
    }

    public IIcon getIconFallingLeaves(int metadata) {
        return this.textures[BlockNewLeaves.unmarkedMetadata(metadata) * 2 + 1];
    }

    public float getSpawnChanceFallingLeaves(int metadata) {
        return 0.01f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149643_k(World world, int x, int y, int z) {
        return BlockNewLeaves.unmarkedMetadata(world.func_72805_g(x, y, z));
    }

    public int func_149741_i(int metadata) {
        metadata = BlockNewLeaves.unmarkedMetadata(metadata);
        switch (metadata) {
            case 0: {
                return ColorizerFoliage.func_77470_a((double)1.0, (double)0.5);
            }
            case 1: {
                return 0xFFFFFF;
            }
            case 2: {
                return ColorizerFoliage.func_77470_a((double)1.0, (double)0.5);
            }
        }
        return ColorizerFoliage.func_77470_a((double)1.0, (double)0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int md) {
        super.func_149636_a(world, player, x, y, z, md);
    }

    public Item func_149650_a(int metadata, Random rand, int par3) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingItem() : Item.func_150898_a((Block)Blocks.field_150345_g);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.beginLeavesDecay(world, x, y, z);
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockNewLeaves.unmarkedMetadata(world.func_72805_g(x, y, z))));
        return ret;
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    public boolean func_149646_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.field_150121_P = !Blocks.field_150362_t.func_149662_c();
        return super.func_149646_a(par1iBlockAccess, par2, par3, par4, par5);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int leafRange;
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (BlockNewLeaves.isUserPlaced(metadata) || !BlockNewLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = BlockNewLeaves.unmarkedMetadata(metadata) == BlockType.JAPANESE_MAPLE.metadata ? 8 : 6;
        int rangeCheckChunk = rangeWood + 1;
        int var9 = 32;
        int var10 = 1024;
        int var11 = 16;
        int n = leafRange = BlockNewLeaves.unmarkedMetadata(metadata) == BlockType.JAPANESE_MAPLE.metadata ? 10 : 4;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[32768];
        }
        if (world.func_72904_c(x - rangeCheckChunk, y - rangeCheckChunk, z - rangeCheckChunk, x + rangeCheckChunk, y + rangeCheckChunk, z + rangeCheckChunk)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -rangeWood; var12 <= rangeWood; ++var12) {
                for (var13 = -rangeWood; var13 <= rangeWood; ++var13) {
                    for (var14 = -rangeWood; var14 <= rangeWood; ++var14) {
                        Block block = world.func_147439_a(x + var12, y + var13, z + var14);
                        this.adjacentTreeBlocks[(var12 + 16) * 1024 + (var13 + 16) * 32 + var14 + 16] = block != null && block.canSustainLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? 0 : (block != null && block.isLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= leafRange; ++var12) {
                for (var13 = -rangeWood; var13 <= rangeWood; ++var13) {
                    for (var14 = -rangeWood; var14 <= rangeWood; ++var14) {
                        for (int var15 = -rangeWood; var15 <= rangeWood; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[16912] >= 0) {
            world.func_72921_c(x, y, z, BlockNewLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(world, x, y, z);
        }
    }

    public static enum BlockType {
        BALD_CYPRESS(0),
        JAPANESE_MAPLE(1),
        JAPANESE_MAPLE_SHRUB(2),
        RAINBOW_EUCALYPTUS(3);

        private final int metadata;
        private ItemStack sapling = new ItemStack(Blocks.field_150345_g);
        private static boolean loadedCustomBlocks;

        static BlockType fromMetadata(int metadata) {
            metadata = BlockNewLeaves.unmarkedMetadata(metadata);
            for (BlockType type : BlockType.values()) {
                if (type.metadata() != metadata) continue;
                return type;
            }
            return null;
        }

        private static void loadCustomBlocks() {
            if (Element.SAPLING_BALD_CYPRESS.isPresent()) {
                BlockType.BALD_CYPRESS.sapling = Element.SAPLING_BALD_CYPRESS.get();
            }
            if (Element.SAPLING_JAPANESE_MAPLE.isPresent()) {
                BlockType.JAPANESE_MAPLE.sapling = Element.SAPLING_JAPANESE_MAPLE.get();
            }
            if (Element.SAPLING_JAPANESE_MAPLE_SHRUB.isPresent()) {
                BlockType.JAPANESE_MAPLE_SHRUB.sapling = Element.SAPLING_JAPANESE_MAPLE_SHRUB.get();
            }
            if (Element.SAPLING_RAINBOW_EUCALYPTUS.isPresent()) {
                BlockType.RAINBOW_EUCALYPTUS.sapling = Element.SAPLING_RAINBOW_EUCALYPTUS.get();
            }
            loadedCustomBlocks = true;
        }

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        Item getSaplingItem() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77973_b();
        }

        Block getSaplingBlock() {
            return Block.func_149634_a((Item)this.sapling.func_77973_b());
        }

        int getSaplingMetadata() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77960_j();
        }

        public int metadata() {
            return this.metadata;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

