/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.blocks.ICropType;
import extrabiomes.helpers.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCropBasic
extends BlockFlower {
    public static final int MAX_GROWTH_STAGE = 7;
    protected static final int MIN_LIGHT_LEVEL = 9;
    protected static final int MIN_FERTILIZER = 2;
    protected static final int MAX_FERTILIZER = 5;
    protected static final int RENDER_TYPE_CROP = 6;
    protected static final int RENDER_TYPE_FLOWER = 1;
    protected static final int DEFAULT_RENDER_TYPE = 6;
    public final ICropType cropType;

    protected BlockCropBasic(ICropType type) {
        super(0);
        this.cropType = type;
        this.func_149672_a(Block.field_149779_h);
        float offset = 0.2f;
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 0.6f, 0.7f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        ArrayList IIcons = Lists.newArrayListWithCapacity((int)8);
        String name = this.cropType.name().toLowerCase();
        Object lastIIcon = null;
        for (int k = 0; k <= 7; ++k) {
            int l = k != 6 ? k : k - 1;
            String texture = "plant_" + name + l;
            IIcon IIcon2 = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + texture);
            IIcons.add(k, IIcon2);
        }
        this.cropType.setStageIIcons(IIcons);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
        for (int i = 0; i <= 7; ++i) {
            p_149666_3_.add(new ItemStack(p_149666_1_, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata > 7) {
            metadata = 7;
        }
        try {
            return this.cropType.getStageIIcon(metadata);
        }
        catch (Exception e) {
            LogHelper.warning("Unable to get stage IIcon for " + this.cropType.name() + " @ " + metadata, new Object[0]);
            return null;
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        float rate;
        int meta;
        super.func_149674_a(world, x, y, z, rand);
        if (world.func_72957_l(x, y, z) >= 9 && (meta = world.func_72805_g(x, y, z)) < 7 && rand.nextInt((int)(25.0f / (rate = this.getGrowthRate(world, x, y, z))) + 1) == 0) {
            world.func_72921_c(x, y, z, ++meta, 2);
        }
    }

    public void fertilize(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
        if (meta > 7) {
            meta = 7;
        }
        world.func_72921_c(x, y, z, meta, 2);
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random rand) {
        this.fertilize(world, x, y, z);
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        float rate = 1.0f;
        Block id_nZ = world.func_147439_a(x, y, z - 1);
        Block id_pZ = world.func_147439_a(x, y, z + 1);
        Block id_nX = world.func_147439_a(x - 1, y, z);
        Block id_pX = world.func_147439_a(x + 1, y, z);
        Block id_nXnZ = world.func_147439_a(x - 1, y, z - 1);
        Block id_pXnZ = world.func_147439_a(x + 1, y, z - 1);
        Block id_pXpZ = world.func_147439_a(x + 1, y, z + 1);
        Block id_nXpZ = world.func_147439_a(x - 1, y, z + 1);
        boolean flagX = id_nX == this || id_pX == this;
        boolean flagZ = id_nZ == this || id_pZ == this;
        boolean flagD = id_nXnZ == this || id_pXnZ == this || id_pXpZ == this || id_nXpZ == this;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = z - 1; j <= z + 1; ++j) {
                Block id_ground = world.func_147439_a(i, y - 1, j);
                float bonus = 0.0f;
                if (id_ground != null && id_ground.canSustainPlant((IBlockAccess)world, i, y - 1, j, ForgeDirection.UP, (IPlantable)this)) {
                    bonus = 1.0f;
                    if (id_ground.isFertile(world, i, y - 1, j)) {
                        bonus = 3.0f;
                    }
                }
                if (i != x || j != z) {
                    bonus /= 4.0f;
                }
                rate += bonus;
            }
        }
        if (flagD || flagX && flagZ) {
            rate /= 2.0f;
        }
        return rate;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        if (metadata >= 7) {
            for (int n = 0; n < 3 + fortune; ++n) {
                if (world.field_73012_v.nextInt(15) > metadata) continue;
                ret.add(this.getSeedItem());
            }
        }
        return ret;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return meta >= 7 ? this.getCropItem() : this.getSeedItem().func_77973_b();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_149645_b() {
        return this.cropType.getRenderType();
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public ItemStack getSeedItem() {
        return this.cropType.getSeedItem();
    }

    public Item getCropItem() {
        return this.cropType.getCropItem();
    }

    public void setSeedItem(ItemStack seed) {
        this.cropType.setSeedItem(seed);
    }

    public void setCropItem(Item crop) {
        this.cropType.setCropItem(crop);
    }

    public static enum CropType implements ICropType
    {

        private ArrayList<IIcon> IIcons;
        private ItemStack seed;
        private Item crop;
        private int renderType;

        @Override
        public IIcon getStageIIcon(int stage) {
            return this.IIcons.get(stage);
        }

        @Override
        public void setStageIIcons(ArrayList<IIcon> IIcons) {
            this.IIcons = IIcons;
        }

        @Override
        public ItemStack getSeedItem() {
            return this.seed;
        }

        @Override
        public Item getCropItem() {
            return this.crop;
        }

        @Override
        public void setSeedItem(ItemStack seed) {
            this.seed = seed;
        }

        @Override
        public void setCropItem(Item crop) {
            this.crop = crop;
        }

        @Override
        public int getRenderType() {
            return this.renderType;
        }
    }
}

