/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v1;

import com.google.common.base.Preconditions;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.inventory.legacy.ItemDistribution;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.helpers.Index;
import openperipheral.integration.mystcraft.v1.NotebookIInventoryWrapper;

public class AdapterWritingDesk
implements IPeripheralAdapter {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"com.xcompwiz.mystcraft.tileentity.TileEntityDesk");
    private final MethodAccess.Function0<Integer> GET_MAX_NOTEBOOK_COUNT = MethodAccess.create(Integer.TYPE, this.CLASS, (String[])new String[]{"getMaxNotebookCount"});
    private final MethodAccess.Function1<ItemStack, Byte> GET_NOTEBOOK = MethodAccess.create(ItemStack.class, this.CLASS, Byte.TYPE, (String[])new String[]{"getNotebook"});
    private final MethodAccess.Function2<Void, EntityPlayer, String> WRITE_SYMBOL = MethodAccess.create(Void.TYPE, this.CLASS, EntityPlayer.class, String.class, (String[])new String[]{"writeSymbol"});

    public Class<?> getTargetClass() {
        return this.CLASS;
    }

    public String getSourceId() {
        return "mystcraft_desk";
    }

    @ScriptCallable(description="Get the maximum number of notebooks this desk can store", returnTypes={ReturnType.NUMBER})
    public int getMaxNotebookCount(Object tileEntityDesk) {
        return (Integer)this.GET_MAX_NOTEBOOK_COUNT.call(tileEntityDesk);
    }

    @ScriptCallable(description="Get the name of a notebook", returnTypes={ReturnType.STRING})
    public String getNotebookName(Object desk, @Arg(name="slot", description="The writing desk slot you are interested in") Index deskSlot) {
        return this.createInventoryWrapper(desk, deskSlot).func_145825_b();
    }

    @ScriptCallable(description="Get the number of pages in a notebook", returnTypes={ReturnType.NUMBER})
    public Integer getNotebookSize(Object desk, @Arg(name="deskSlot") Index deskSlot) {
        return this.createInventoryWrapper(desk, deskSlot).getItemCount();
    }

    @ScriptCallable(description="Get the contents of a slot in a notebook", returnTypes={ReturnType.NUMBER})
    public ItemStack getNotebookStackInSlot(Object desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="notebookSlot") Index notebookSlot) {
        return this.createInventoryWrapper(desk, deskSlot).func_70301_a(notebookSlot.value);
    }

    @ScriptCallable(description="Get the last slot index in a notebook", returnTypes={ReturnType.NUMBER})
    public Integer getLastNotebookSlot(Object desk, @Arg(name="deskSlot") Index deskSlot) {
        return this.createInventoryWrapper(desk, deskSlot).func_70302_i_() - 1;
    }

    @ScriptCallable(description="Swap notebook slots")
    public void swapNotebookPages(Object desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="from") Index from, @Arg(name="to") Index to) {
        InventoryUtils.swapStacks((IInventory)this.createInventoryWrapper(desk, deskSlot), (int)from.value, (int)to.value);
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Push a page from the notebook into a specific slot in external inventory. Returns the amount of items moved")
    public int pushNotebookPage(TileEntity desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(name="fromSlot", description="The page slot in inventory that you're pushing from") Index fromSlot, @Optionals @Arg(name="intoSlot", description="The slot in the other inventory that you want to push into") Index intoSlot) {
        int amount;
        NotebookIInventoryWrapper source = this.createInventoryWrapper(desk, deskSlot);
        IInventory target = AdapterWritingDesk.getTargetTile(desk, direction);
        if (intoSlot == null) {
            intoSlot = new Index(-1, 0);
        }
        if ((amount = ItemDistribution.moveItemInto((IInventory)source, (int)fromSlot.value, (IInventory)target, (int)intoSlot.value, (int)64, (ForgeDirection)direction.getOpposite(), (boolean)true)) > 0) {
            target.func_70296_d();
        }
        return amount;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Pull an item from the target inventory into any slot in the current one. Returns the amount of items moved")
    public int pullNotebookPage(TileEntity desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="direction", description="The direction of the other inventory)") ForgeDirection direction, @Arg(name="fromSlot", description="The slot in the other inventory that you're pulling from") int notebookSlot) {
        NotebookIInventoryWrapper target;
        IInventory source = AdapterWritingDesk.getTargetTile(desk, direction);
        int amount = ItemDistribution.moveItemInto((IInventory)source, (int)(notebookSlot - 1), (IInventory)(target = this.createInventoryWrapper(desk, deskSlot)), (int)-1, (int)1, (ForgeDirection)direction.getOpposite(), (boolean)true, (boolean)false);
        if (amount > 0) {
            source.func_70296_d();
        }
        return amount;
    }

    @ScriptCallable(description="Create a symbol page from the target symbol")
    public void writeSymbol(final TileEntity desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="notebookSlot", description="The source symbol to copy") Index notebookSlot) {
        final String symbol = AdapterWritingDesk.getSymbolFromPage(this.getNotebookStackInSlot(desk, deskSlot, notebookSlot));
        if (symbol != null) {
            FakePlayerPool.instance.executeOnPlayer((WorldServer)desk.func_145831_w(), new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    AdapterWritingDesk.this.WRITE_SYMBOL.call((Object)desk, (Object)fakePlayer, (Object)symbol);
                }
            });
        }
    }

    private static String getSymbolFromPage(ItemStack info) {
        NBTTagCompound tag;
        Item item;
        if (info != null && info.func_77942_o() && (item = info.func_77973_b()) != null && "item.myst.page".equals(item.func_77658_a()) && (tag = info.func_77978_p()) != null) {
            return tag.func_74779_i("symbol");
        }
        return null;
    }

    private static IInventory getTargetTile(TileEntity target, ForgeDirection direction) {
        Preconditions.checkArgument((direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        TileEntity targetTile = BlockUtils.getTileInDirection((TileEntity)target, (ForgeDirection)direction);
        Preconditions.checkArgument((boolean)(targetTile instanceof IInventory), (Object)"Target direction is not a valid inventory");
        return (IInventory)targetTile;
    }

    private NotebookIInventoryWrapper createInventoryWrapper(Object tile, Index slot) {
        ItemStack notebook = (ItemStack)this.GET_NOTEBOOK.call(tile, (Object)slot.byteValue());
        return new NotebookIInventoryWrapper(notebook);
    }
}

