/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.lib.EnumColour;
import ganymedes01.etfuturum.recipes.RecipeAddPattern;
import ganymedes01.etfuturum.recipes.RecipeDuplicatePattern;
import ganymedes01.etfuturum.recipes.RecipeTippedArrow;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModRecipes {
    public static String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};

    public static void init() {
        if (EtFuturum.enableBanners) {
            RecipeSorter.register((String)"etfuturum.RecipeDuplicatePattern", RecipeDuplicatePattern.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            RecipeSorter.register((String)"etfuturum.RecipeAddPattern", RecipeAddPattern.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        }
        ModRecipes.registerOreDictionary();
        ModRecipes.registerRecipes();
        ModRecipes.tweakRecipes();
    }

    private static void tweakRecipes() {
        if (EtFuturum.enableDoors) {
            Items.field_151135_aq.func_77625_d(64);
            Items.field_151139_aw.func_77625_d(64);
            ModRecipes.removeFirstRecipeFor(Items.field_151135_aq);
            ModRecipes.removeFirstRecipeFor(Items.field_151139_aw);
        }
        if (EtFuturum.enableFences) {
            ModRecipes.removeFirstRecipeFor(Blocks.field_150422_aJ);
            ModRecipes.removeFirstRecipeFor(Blocks.field_150396_be);
            Blocks.field_150422_aJ.func_149647_a(null);
            Blocks.field_150396_be.func_149647_a(null);
        }
        if (EtFuturum.enableBurnableBlocks) {
            Blocks.field_150480_ab.setFireInfo(Blocks.field_150396_be, 5, 20);
            Blocks.field_150480_ab.setFireInfo(Blocks.field_150422_aJ, 5, 20);
            Blocks.field_150480_ab.setFireInfo((Block)Blocks.field_150330_I, 60, 100);
        }
    }

    private static void registerOreDictionary() {
        OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack((Block)Blocks.field_150486_ae));
        OreDictionary.registerOre((String)"trapdoorWood", (Block)Blocks.field_150415_aT);
        if (EtFuturum.enablePrismarine) {
            OreDictionary.registerOre((String)"shardPrismarine", (ItemStack)new ItemStack(ModItems.prismarine_shard));
            OreDictionary.registerOre((String)"crystalPrismarine", (ItemStack)new ItemStack(ModItems.prismarine_crystals));
            OreDictionary.registerOre((String)"blockPrismarine", (ItemStack)new ItemStack(ModBlocks.prismarine, 1, Short.MAX_VALUE));
        }
        if (EtFuturum.enableStones) {
            OreDictionary.registerOre((String)"stoneGranite", (ItemStack)new ItemStack(ModBlocks.stone, 1, 1));
            OreDictionary.registerOre((String)"stoneDiorite", (ItemStack)new ItemStack(ModBlocks.stone, 1, 3));
            OreDictionary.registerOre((String)"stoneAndesite", (ItemStack)new ItemStack(ModBlocks.stone, 1, 5));
            OreDictionary.registerOre((String)"stoneGranitePolished", (ItemStack)new ItemStack(ModBlocks.stone, 1, 2));
            OreDictionary.registerOre((String)"stoneDioritePolished", (ItemStack)new ItemStack(ModBlocks.stone, 1, 4));
            OreDictionary.registerOre((String)"stoneAndesitePolished", (ItemStack)new ItemStack(ModBlocks.stone, 1, 6));
        }
        if (EtFuturum.enableSlimeBlock) {
            OreDictionary.registerOre((String)"blockSlime", (ItemStack)new ItemStack(ModBlocks.slime));
        }
        if (EtFuturum.enableIronTrapdoor) {
            OreDictionary.registerOre((String)"trapdoorIron", (Block)ModBlocks.iron_trapdoor);
        }
        if (EtFuturum.enableBeetroot) {
            OreDictionary.registerOre((String)"cropBeetroot", (Item)ModItems.beetroot);
        }
        if (EtFuturum.enableChorusFruit) {
            OreDictionary.registerOre((String)"brickEndStone", (Block)ModBlocks.end_bricks);
        }
    }

    private static void registerRecipes() {
        int i;
        if (EtFuturum.enableStoneBrickRecipes) {
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150341_Y), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150395_bd));
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150395_bd));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150417_aV, 1, 3), "x", "x", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150333_U, 1, 5));
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150417_aV), (ItemStack)new ItemStack(Blocks.field_150417_aV, 1, 2), (float)0.0f);
        }
        if (EtFuturum.enableSlimeBlock) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.slime), "xxx", "xxx", "xxx", Character.valueOf('x'), "slimeball");
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151123_aH, 9), ModBlocks.slime);
        }
        if (EtFuturum.enableCoarseDirt) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.coarse_dirt, 4), "xy", "yx", Character.valueOf('x'), new ItemStack(Blocks.field_150346_d), Character.valueOf('y'), new ItemStack(Blocks.field_150351_n));
        }
        if (EtFuturum.enableMutton) {
            GameRegistry.addSmelting((Item)ModItems.raw_mutton, (ItemStack)new ItemStack(ModItems.cooked_mutton), (float)0.35f);
        }
        if (EtFuturum.enableIronTrapdoor) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.iron_trapdoor), "xx", "xx", Character.valueOf('x'), "ingotIron");
        }
        if (EtFuturum.enableStones) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 2, 3), "xy", "yx", Character.valueOf('x'), new ItemStack(Blocks.field_150347_e), Character.valueOf('y'), "gemQuartz");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 4, 4), "xx", "xx", Character.valueOf('x'), "stoneDiorite");
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.stone, 2, 5), new ItemStack(Blocks.field_150347_e), "stoneDiorite");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 4, 6), "xx", "xx", Character.valueOf('x'), "stoneAndesite");
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.stone, 2, 1), "gemQuartz", "stoneDiorite");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 4, 2), "xx", "xx", Character.valueOf('x'), "stoneGranite");
        }
        if (EtFuturum.enablePrismarine) {
            int PLAIN = 0;
            int BRICKS = 1;
            int DARK = 2;
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine, 1, DARK), "xxx", "xyx", "xxx", Character.valueOf('x'), "shardPrismarine", Character.valueOf('y'), "dyeBlack");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine, 1, PLAIN), "xx", "xx", Character.valueOf('x'), "shardPrismarine");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine, 1, BRICKS), "xxx", "xxx", "xxx", Character.valueOf('x'), "shardPrismarine");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.sea_lantern), "xyx", "yyy", "xyx", Character.valueOf('x'), "shardPrismarine", Character.valueOf('y'), "crystalPrismarine");
            if (EtFuturum.enableRecipeForPrismarine && !Loader.isModLoaded((String)"Botania")) {
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.prismarine_shard, 4), "xy", "zx", Character.valueOf('x'), "gemQuartz", Character.valueOf('y'), "dyeBlue", Character.valueOf('z'), "dyeGreen");
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.prismarine_crystals, 4), "xy", "yx", Character.valueOf('x'), "gemQuartz", Character.valueOf('y'), "dustGlowstone");
            }
        }
        if (EtFuturum.enableDoors) {
            for (i = 0; i < ModBlocks.doors.length; ++i) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.doors[i], 3), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i + 1));
            }
            ModRecipes.addShapedRecipe(new ItemStack(Items.field_151135_aq, 3), "xx", "xx", "xx", Character.valueOf('x'), "plankWood");
            ModRecipes.addShapedRecipe(new ItemStack(Items.field_151139_aw, 3), "xx", "xx", "xx", Character.valueOf('x'), "ingotIron");
        }
        if (EtFuturum.enableRedSandstone) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone), "xx", "xx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150354_m, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone, 1, 1), "x", "x", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone_slab));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone, 4, 2), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone_slab, 6), "xxx", Character.valueOf('x'), ModBlocks.red_sandstone);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.red_sandstone);
        }
        if (EtFuturum.enableFences) {
            for (i = 0; i < ModBlocks.fences.length; ++i) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.fences[i], 3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i), Character.valueOf('y'), "stickWood");
            }
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.fences[0], 3), "xyx", "xyx", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "stickWood");
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150422_aJ), ModBlocks.fences[0]);
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.fences[0]), Blocks.field_150422_aJ);
            for (i = 0; i < ModBlocks.gates.length; ++i) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.gates[i]), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i + 1), Character.valueOf('y'), "stickWood");
            }
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150396_be), "yxy", "yxy", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "stickWood");
        }
        if (EtFuturum.enableBanners) {
            for (EnumColour colour : EnumColour.values()) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.banner, 1, colour.getDamage()), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150325_L, 1, colour.getDamage()), Character.valueOf('y'), "stickWood");
            }
            GameRegistry.addRecipe((IRecipe)new RecipeDuplicatePattern());
            GameRegistry.addRecipe((IRecipe)new RecipeAddPattern());
        }
        if (EtFuturum.enableArmourStand) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.armour_stand), "xxx", " x ", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack((Block)Blocks.field_150333_U));
        }
        if (EtFuturum.enableRabbit) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.rabbit_stew), " R ", "CPM", " B ", Character.valueOf('R'), new ItemStack(ModItems.cooked_rabbit), Character.valueOf('C'), Items.field_151172_bF, Character.valueOf('P'), Items.field_151168_bH, Character.valueOf('M'), Blocks.field_150338_P, Character.valueOf('B'), Items.field_151054_z);
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.rabbit_stew), " R ", "CPD", " B ", Character.valueOf('R'), new ItemStack(ModItems.cooked_rabbit), Character.valueOf('C'), Items.field_151172_bF, Character.valueOf('P'), Items.field_151168_bH, Character.valueOf('D'), Blocks.field_150337_Q, Character.valueOf('B'), Items.field_151054_z);
            GameRegistry.addSmelting((Item)ModItems.raw_rabbit, (ItemStack)new ItemStack(ModItems.cooked_rabbit), (float)0.35f);
            ModRecipes.addShapedRecipe(new ItemStack(Items.field_151116_aA), "xx", "xx", Character.valueOf('x'), ModItems.rabbit_hide);
        }
        if (EtFuturum.enableOldGravel) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.old_gravel, 4), "xy", "yx", Character.valueOf('x'), ModBlocks.coarse_dirt, Character.valueOf('y'), Blocks.field_150351_n);
        }
        if (EtFuturum.enableSponge) {
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.sponge), Blocks.field_150360_v);
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150360_v), ModBlocks.sponge);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.sponge, 1, 1), (ItemStack)new ItemStack(ModBlocks.sponge), (float)0.0f);
        }
        if (EtFuturum.enableBeetroot) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.beetroot_soup), "xxx", "xxx", " y ", Character.valueOf('x'), "cropBeetroot", Character.valueOf('y'), Items.field_151054_z);
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 1), "cropBeetroot");
        }
        if (EtFuturum.enableChorusFruit) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_block, 4), "xx", "xx", Character.valueOf('x'), ModItems.popped_chorus_fruit);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.purpur_block);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_slab, 6), "xxx", Character.valueOf('x'), ModBlocks.purpur_block);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_pillar), "x", "x", Character.valueOf('x'), ModBlocks.purpur_slab);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_bricks), "xx", "xx", Character.valueOf('x'), Blocks.field_150377_bs);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.chorus_fruit), (ItemStack)new ItemStack(ModItems.popped_chorus_fruit), (float)0.0f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_rod), "x", "y", Character.valueOf('x'), Items.field_151072_bj, Character.valueOf('y'), ModItems.popped_chorus_fruit);
        }
        if (EtFuturum.enableCryingObsidian) {
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.crying_obsidian), Blocks.field_150343_Z, "gemLapis");
        }
        if (EtFuturum.enableLingeringPotions) {
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.dragon_breath), new ItemStack((Item)Items.field_151068_bn, 1, 8195), ModItems.chorus_fruit, ModItems.chorus_fruit);
        }
        if (EtFuturum.enableDragonRespawn) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.end_crystal), "xxx", "xyx", "xzx", Character.valueOf('x'), "blockGlassColorless", Character.valueOf('y'), Items.field_151061_bv, Character.valueOf('z'), Items.field_151073_bk);
        }
        if (EtFuturum.enableRoses) {
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 1), ModBlocks.rose);
            ModRecipes.addShapedRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.rose));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.rose, 12), "xx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        }
        if (EtFuturum.enableTippedArrows && EtFuturum.enableLingeringPotions) {
            RecipeSorter.register((String)"etfuturum.RecipeTippedArrow", RecipeTippedArrow.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
            GameRegistry.addRecipe((IRecipe)new RecipeTippedArrow(new ItemStack(ModItems.tipped_arrow), "xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151032_g, Character.valueOf('y'), new ItemStack(ModItems.lingering_potion, 1, Short.MAX_VALUE)));
        }
    }

    private static void addShapedRecipe(ItemStack output, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, objects));
    }

    private static void addShapelessRecipe(ItemStack output, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, objects));
    }

    private static void removeFirstRecipeFor(Block block) {
        ModRecipes.removeFirstRecipeFor(Item.func_150898_a((Block)block));
    }

    private static void removeFirstRecipeFor(Item item) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack stack;
            if (recipe == null || (stack = ((IRecipe)recipe).func_77571_b()) == null || stack.func_77973_b() != item) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
            return;
        }
    }
}

