/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.lib;

import java.awt.Color;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.StatCollector;

public enum EnumColour {
    BLACK("Black", MapColor.field_151646_E),
    RED("Red", MapColor.field_151645_D),
    GREEN("Green", MapColor.field_151651_C),
    BROWN("Brown", MapColor.field_151650_B),
    BLUE("Blue", MapColor.field_151649_A),
    PURPLE("Purple", MapColor.field_151678_z),
    CYAN("Cyan", MapColor.field_151679_y),
    LIGHT_GREY("LightGray", MapColor.field_151680_x),
    GREY("Gray", MapColor.field_151670_w),
    PINK("Pink", MapColor.field_151671_v),
    LIME("Lime", MapColor.field_151672_u),
    YELLOW("Yellow", MapColor.field_151673_t),
    LIGHT_BLUE("LightBlue", MapColor.field_151674_s),
    MAGENTA("Magenta", MapColor.field_151675_r),
    ORANGE("Orange", MapColor.field_151676_q),
    WHITE("White", MapColor.field_151666_j);

    final String dye;
    final String name;
    final MapColor mapColour;

    private EnumColour(String name, MapColor mapColour) {
        this.dye = "dye" + name;
        this.name = name;
        this.mapColour = mapColour;
    }

    public String getName() {
        return this.name;
    }

    public String getMojangName() {
        if (this == LIGHT_GREY) {
            return "silver";
        }
        return this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
    }

    public String getOreName() {
        return this.dye;
    }

    public MapColor getMapColour() {
        return this.mapColour;
    }

    public Color getColour() {
        int i = this.getDamage();
        return new Color(EntitySheep.field_70898_d[i][0], EntitySheep.field_70898_d[i][1], EntitySheep.field_70898_d[i][2]);
    }

    public int getDamage() {
        return BlockColored.func_150031_c((int)this.ordinal());
    }

    public int getRGB() {
        return this.getColour().getRGB();
    }

    public int getDarker() {
        return this.getColour().darker().getRGB();
    }

    public int getBrighter() {
        return this.getColour().brighter().getRGB();
    }

    public String getTranslatedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalisedName());
    }

    public String getUnlocalisedName() {
        return "colour.etfuturum." + this.dye;
    }

    public static EnumColour fromDamage(int meta) {
        meta = BlockColored.func_150031_c((int)meta);
        return EnumColour.values()[Math.min(Math.max(0, meta), EnumColour.values().length - 1)];
    }
}

