/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities.ai;

import com.google.common.base.Objects;
import net.minecraft.util.MathHelper;

public class Vec3i
implements Comparable<Vec3i> {
    private final int x;
    private final int y;
    private final int z;

    public Vec3i(int xIn, int yIn, int zIn) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
    }

    public Vec3i(double xIn, double yIn, double zIn) {
        this(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vec3i)) {
            return false;
        }
        Vec3i vec3i = (Vec3i)p_equals_1_;
        return this.getX() != vec3i.getX() ? false : (this.getY() != vec3i.getY() ? false : this.getZ() == vec3i.getZ());
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vec3i vec) {
        return this.getY() == vec.getY() ? (this.getZ() == vec.getZ() ? this.getX() - vec.getX() : this.getZ() - vec.getZ()) : this.getY() - vec.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Vec3i crossProduct(Vec3i vec) {
        return new Vec3i(this.getY() * vec.getZ() - this.getZ() * vec.getY(), this.getZ() * vec.getX() - this.getX() * vec.getZ(), this.getX() * vec.getY() - this.getY() * vec.getX());
    }

    public double distanceSq(double toX, double toY, double toZ) {
        double d3 = (double)this.getX() - toX;
        double d4 = (double)this.getY() - toY;
        double d5 = (double)this.getZ() - toZ;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double distanceSqToCenter(double xIn, double yIn, double zIn) {
        double d3 = (double)this.getX() + 0.5 - xIn;
        double d4 = (double)this.getY() + 0.5 - yIn;
        double d5 = (double)this.getZ() + 0.5 - zIn;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double distanceSq(Vec3i to) {
        return this.distanceSq(to.getX(), to.getY(), to.getZ());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }
}

