/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.IConfigurable;
import ganymedes01.etfuturum.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class WorldTickEventHandler {
    private static Map<Block, Block> replacements;
    private boolean isReplacing = false;

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END || this.isReplacing) {
            return;
        }
        if (replacements == null) {
            replacements = new HashMap<Block, Block>();
            if (EtFuturum.enableBrewingStands) {
                replacements.put(Blocks.field_150382_bo, ModBlocks.brewing_stand);
            }
            if (EtFuturum.enableColourfulBeacons) {
                replacements.put((Block)Blocks.field_150461_bJ, ModBlocks.beacon);
            }
            if (EtFuturum.enableEnchants) {
                replacements.put(Blocks.field_150381_bn, ModBlocks.enchantment_table);
            }
            if (EtFuturum.enableInvertedDaylightSensor) {
                replacements.put((Block)Blocks.field_150453_bW, ModBlocks.daylight_sensor);
            }
        }
        if (replacements.isEmpty()) {
            return;
        }
        this.isReplacing = true;
        World world = event.world;
        for (int i = 0; i < world.field_147482_g.size(); ++i) {
            TileEntity tile = (TileEntity)world.field_147482_g.get(i);
            int x = tile.field_145851_c;
            int y = tile.field_145848_d;
            int z = tile.field_145849_e;
            Block replacement = replacements.get(world.func_147439_a(x, y, z));
            if (replacement == null || !((IConfigurable)replacement).isEnabled()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_145841_b(nbt);
            if (tile instanceof IInventory) {
                IInventory invt = (IInventory)tile;
                for (int j = 0; j < invt.func_70302_i_(); ++j) {
                    invt.func_70299_a(j, null);
                }
            }
            world.func_147449_b(x, y, z, replacement);
            TileEntity newTile = world.func_147438_o(x, y, z);
            newTile.func_145839_a(nbt);
            break;
        }
        this.isReplacing = false;
    }
}

