/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.skins;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.client.skins.NewImageBufferDownload;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class NewThreadDownloadImageData
extends SimpleTexture {
    private static final Logger logger = LogManager.getLogger();
    private static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    private final File field_152434_e;
    private final String imageUrl;
    private final IImageBuffer imageBuffer;
    private BufferedImage bufferedImage;
    private Thread imageThread;
    private boolean textureUploaded;
    private NewImageBufferDownload imgDownload;
    private ResourceLocation resLocationOld;

    public NewThreadDownloadImageData(File file, String imageUrl, ResourceLocation texture, NewImageBufferDownload imgDownload, ResourceLocation resLocationOld, IImageBuffer imageBuffer) {
        super(texture);
        this.field_152434_e = file;
        this.imageUrl = imageUrl;
        this.imgDownload = imgDownload;
        this.resLocationOld = resLocationOld;
        this.imageBuffer = imageBuffer;
    }

    private void checkTextureUploaded() {
        if (!this.textureUploaded && this.bufferedImage != null) {
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
            if (this.imgDownload != null) {
                BufferedImage oldStyleImg = this.imgDownload.getOldSyleImage();
                Minecraft.func_71410_x().func_110434_K().func_110579_a(this.resLocationOld, (ITextureObject)new DynamicTexture(oldStyleImg));
            }
            this.textureUploaded = true;
        }
    }

    public int func_110552_b() {
        this.checkTextureUploaded();
        return super.func_110552_b();
    }

    public void setBufferedImage(BufferedImage p_147641_1_) {
        this.bufferedImage = p_147641_1_;
        if (this.imageBuffer != null) {
            this.imageBuffer.func_152634_a();
        }
    }

    public void func_110551_a(IResourceManager p_110551_1_) throws IOException {
        if (this.bufferedImage == null && this.field_110568_b != null) {
            super.func_110551_a(p_110551_1_);
        }
        if (this.imageThread == null) {
            if (this.field_152434_e != null && this.field_152434_e.isFile()) {
                logger.debug("Loading http texture from local cache ({})", new Object[]{this.field_152434_e});
                try {
                    this.bufferedImage = ImageIO.read(this.field_152434_e);
                    if (this.imageBuffer != null) {
                        this.setBufferedImage(this.imageBuffer.func_78432_a(this.bufferedImage));
                    }
                }
                catch (IOException ioexception) {
                    logger.error("Couldn't load skin " + this.field_152434_e, (Throwable)ioexception);
                    this.func_152433_a();
                }
            } else {
                this.func_152433_a();
            }
        }
    }

    protected void func_152433_a() {
        this.imageThread = new Thread("Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                logger.debug("Downloading http texture from {} to {}", new Object[]{NewThreadDownloadImageData.this.imageUrl, NewThreadDownloadImageData.this.field_152434_e});
                try {
                    httpurlconnection = (HttpURLConnection)new URL(NewThreadDownloadImageData.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        BufferedImage bufferedimage;
                        if (NewThreadDownloadImageData.this.field_152434_e != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)NewThreadDownloadImageData.this.field_152434_e);
                            bufferedimage = ImageIO.read(NewThreadDownloadImageData.this.field_152434_e);
                        } else {
                            bufferedimage = ImageIO.read(httpurlconnection.getInputStream());
                        }
                        if (NewThreadDownloadImageData.this.imageBuffer != null) {
                            bufferedimage = NewThreadDownloadImageData.this.imageBuffer.func_78432_a(bufferedimage);
                        }
                        NewThreadDownloadImageData.this.setBufferedImage(bufferedimage);
                        return;
                    }
                }
                catch (Exception exception) {
                    logger.error("Couldn't download http texture", (Throwable)exception);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }
}

