/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModEnchantments;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.command.SetPlayerModelCommand;
import ganymedes01.etfuturum.configuration.ConfigurationHandler;
import ganymedes01.etfuturum.core.proxy.CommonProxy;
import ganymedes01.etfuturum.entities.ModEntityList;
import ganymedes01.etfuturum.items.ItemEntityEgg;
import ganymedes01.etfuturum.network.ArmourStandInteractHandler;
import ganymedes01.etfuturum.network.ArmourStandInteractMessage;
import ganymedes01.etfuturum.network.BlackHeartParticlesHandler;
import ganymedes01.etfuturum.network.BlackHeartParticlesMessage;
import ganymedes01.etfuturum.network.SetPlayerModelHandler;
import ganymedes01.etfuturum.network.SetPlayerModelMessage;
import ganymedes01.etfuturum.recipes.BrewingFuelRegistry;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.world.EtFuturumWorldGenerator;
import ganymedes01.etfuturum.world.OceanMonument;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="etfuturum", name="Et Futurum", version="1.5.5", dependencies="required-after:Forge@[10.13.4.1558,);", guiFactory="ganymedes01.etfuturum.configuration.ConfigGuiFactory")
public class EtFuturum {
    @Mod.Instance(value="etfuturum")
    public static EtFuturum instance;
    @SidedProxy(clientSide="ganymedes01.etfuturum.core.proxy.ClientProxy", serverSide="ganymedes01.etfuturum.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper networkWrapper;
    public static CreativeTabs creativeTab;
    public static boolean enableStones;
    public static boolean enableIronTrapdoor;
    public static boolean enableMutton;
    public static boolean enableSponge;
    public static boolean enablePrismarine;
    public static boolean enableDoors;
    public static boolean enableInvertedDaylightSensor;
    public static boolean enableCoarseDirt;
    public static boolean enableRedSandstone;
    public static boolean enableEnchants;
    public static boolean enableAnvil;
    public static boolean enableFences;
    public static boolean enableSilkTouchingMushrooms;
    public static boolean enableBanners;
    public static boolean enableSlimeBlock;
    public static boolean enableArmourStand;
    public static boolean enableRabbit;
    public static boolean enableOldGravel;
    public static boolean enableRecipeForPrismarine;
    public static boolean enableEndermite;
    public static boolean enableBeetroot;
    public static boolean enableChorusFruit;
    public static boolean enableGrassPath;
    public static boolean enableSticksFromDeadBushes;
    public static boolean enableBowRendering;
    public static boolean enableTippedArrows;
    public static boolean enableLingeringPotions;
    public static boolean enableBurnableBlocks;
    public static boolean enableFancySkulls;
    public static boolean enableSkullDrop;
    public static boolean enableDmgIndicator;
    public static boolean enableTransparentAmour;
    public static boolean enableCryingObsidian;
    public static boolean enableUpdatedFoodValues;
    public static boolean enableUpdatedHarvestLevels;
    public static boolean enableVillagerZombies;
    public static boolean enableStoneBrickRecipes;
    public static boolean enableBabyGrowthBoost;
    public static boolean enableVillagerTurnsIntoWitch;
    public static boolean enableElytra;
    public static boolean enableFrostWalker;
    public static boolean enableMending;
    public static boolean enableBrewingStands;
    public static boolean enableDragonRespawn;
    public static boolean enableRoses;
    public static boolean enableColourfulBeacons;
    public static boolean enablePlayerSkinOverlay;
    public static boolean enableShearableGolems;
    public static boolean enableShearableCobwebs;
    public static int maxStonesPerCluster;
    public static boolean isTinkersConstructLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.INSTANCE.init(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "etfuturum" + ".cfg"));
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EtFuturumWorldGenerator(), (int)0);
        ModBlocks.init();
        ModItems.init();
        ModEnchantments.init();
        OceanMonument.makeMap();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("etfuturum");
        networkWrapper.registerMessage(ArmourStandInteractHandler.class, ArmourStandInteractMessage.class, 0, Side.SERVER);
        networkWrapper.registerMessage(BlackHeartParticlesHandler.class, BlackHeartParticlesMessage.class, 1, Side.CLIENT);
        networkWrapper.registerMessage(SetPlayerModelHandler.class, SetPlayerModelMessage.class, 2, Side.CLIENT);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        ModRecipes.init();
        proxy.registerEvents();
        proxy.registerEntities();
        proxy.registerRenderers();
        if (ModEntityList.hasEntitiesWithEggs()) {
            ModEntityList.entity_egg = new ItemEntityEgg();
            GameRegistry.registerItem((Item)ModEntityList.entity_egg, (String)"entity_egg");
            OreDictionary.registerOre((String)"mobEgg", (Item)ModEntityList.entity_egg);
        }
        isTinkersConstructLoaded = Loader.isModLoaded((String)"TConstruct");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Items.field_151072_bj.func_77664_n();
        Blocks.field_150447_bR.func_149647_a(CreativeTabs.field_78028_d);
        if (enableUpdatedFoodValues) {
            this.setFinalField(ItemFood.class, Items.field_151172_bF, 3, "healAmount", "field_77853_b");
            this.setFinalField(ItemFood.class, Items.field_151168_bH, 5, "healAmount", "field_77853_b");
        }
        if (enableUpdatedHarvestLevels) {
            Blocks.field_150403_cj.setHarvestLevel("pickaxe", 0);
            Blocks.field_150468_ap.setHarvestLevel("axe", 0);
            Blocks.field_150440_ba.setHarvestLevel("axe", 0);
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.key.equals("register-brewing-fuel")) continue;
            NBTTagCompound nbt = message.getNBTValue();
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Fuel"));
            int brews = nbt.func_74762_e("Brews");
            BrewingFuelRegistry.registerFuel(stack, brews);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (enablePlayerSkinOverlay) {
            event.registerServerCommand((ICommand)new SetPlayerModelCommand());
        }
    }

    private void setFinalField(Class<?> cls, Object obj, Object newValue, String ... fieldNames) {
        try {
            Field field = ReflectionHelper.findField(cls, (String[])fieldNames);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(obj, newValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        creativeTab = new CreativeTabs("etfuturum"){

            public Item func_78016_d() {
                return enablePrismarine ? ModItems.prismarine_shard : Items.field_151144_bL;
            }
        };
        enableStones = true;
        enableIronTrapdoor = true;
        enableMutton = true;
        enableSponge = true;
        enablePrismarine = true;
        enableDoors = true;
        enableInvertedDaylightSensor = true;
        enableCoarseDirt = true;
        enableRedSandstone = true;
        enableEnchants = true;
        enableAnvil = true;
        enableFences = true;
        enableSilkTouchingMushrooms = true;
        enableBanners = true;
        enableSlimeBlock = true;
        enableArmourStand = true;
        enableRabbit = true;
        enableOldGravel = true;
        enableRecipeForPrismarine = true;
        enableEndermite = true;
        enableBeetroot = true;
        enableChorusFruit = true;
        enableGrassPath = true;
        enableSticksFromDeadBushes = true;
        enableBowRendering = true;
        enableTippedArrows = true;
        enableLingeringPotions = true;
        enableBurnableBlocks = true;
        enableFancySkulls = true;
        enableSkullDrop = true;
        enableDmgIndicator = true;
        enableTransparentAmour = true;
        enableCryingObsidian = true;
        enableUpdatedFoodValues = true;
        enableUpdatedHarvestLevels = true;
        enableVillagerZombies = true;
        enableStoneBrickRecipes = true;
        enableBabyGrowthBoost = true;
        enableVillagerTurnsIntoWitch = true;
        enableElytra = true;
        enableFrostWalker = true;
        enableMending = true;
        enableBrewingStands = true;
        enableDragonRespawn = true;
        enableRoses = true;
        enableColourfulBeacons = true;
        enablePlayerSkinOverlay = true;
        enableShearableGolems = true;
        enableShearableCobwebs = true;
        maxStonesPerCluster = 33;
        isTinkersConstructLoaded = false;
    }
}

