/*
 * Decompiled with CFR 0.152.
 */
package moarcarts.mods.rf.tileentities;

import boilerplate.common.blocks.SideType;
import boilerplate.common.tiles.TileEntitySided;
import boilerplate.common.utils.BlockUtils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import mods.railcraft.api.carts.CartTools;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRFLoader
extends TileEntitySided
implements IEnergyHandler {
    protected EnergyStorage energyStorage = new EnergyStorage(100000, 1000, 1000);

    public void func_145845_h() {
        super.func_145845_h();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            EntityMinecart entityMinecart;
            if (this.getSideValue(direction.ordinal()) == SideType.NONE) continue;
            int blockPosX = this.field_145851_c + direction.offsetX;
            int blockPosY = this.field_145848_d + direction.offsetY;
            int blockPosZ = this.field_145849_e + direction.offsetZ;
            if (this.getSideValue(direction.ordinal()) == SideType.INPUT) {
                IEnergyProvider energyProvider = null;
                if (BlockUtils.isRailBlock((Block)this.field_145850_b.func_147439_a(blockPosX, blockPosY, blockPosZ))) {
                    entityMinecart = CartTools.getMinecartOnSide((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (float)1.0f, (ForgeDirection)direction);
                    if (entityMinecart instanceof IEnergyProvider) {
                        energyProvider = (IEnergyProvider)entityMinecart;
                    }
                } else if (this.field_145850_b.func_147438_o(blockPosX, blockPosY, blockPosZ) instanceof IEnergyProvider) {
                    energyProvider = (IEnergyProvider)this.field_145850_b.func_147438_o(blockPosX, blockPosY, blockPosZ);
                }
                if (energyProvider != null) {
                    this.unLoadCart(direction, energyProvider);
                }
            }
            if (this.getSideValue(direction.ordinal()) != SideType.OUTPUT) continue;
            IEnergyReceiver energyReceiver = null;
            if (BlockUtils.isRailBlock((Block)this.field_145850_b.func_147439_a(blockPosX, blockPosY, blockPosZ))) {
                entityMinecart = CartTools.getMinecartOnSide((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (float)1.0f, (ForgeDirection)direction);
                if (entityMinecart instanceof IEnergyReceiver) {
                    energyReceiver = (IEnergyReceiver)entityMinecart;
                }
            } else if (this.field_145850_b.func_147438_o(blockPosX, blockPosY, blockPosZ) instanceof IEnergyReceiver) {
                energyReceiver = (IEnergyReceiver)this.field_145850_b.func_147438_o(blockPosX, blockPosY, blockPosZ);
            }
            if (energyReceiver == null) continue;
            this.loadCart(direction, energyReceiver);
        }
    }

    public void unLoadCart(ForgeDirection direction, IEnergyProvider provider) {
        int amountToUnload = this.energyStorage.receiveEnergy(this.energyStorage.getMaxReceive(), true);
        int amountRemovedFromCart = provider.extractEnergy(direction.getOpposite(), amountToUnload, false);
        this.energyStorage.receiveEnergy(amountRemovedFromCart, false);
    }

    public void loadCart(ForgeDirection direction, IEnergyReceiver receiver) {
        int amountToLoad = this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), true);
        int amountLoadedIntoCart = receiver.receiveEnergy(direction.getOpposite(), amountToLoad, false);
        this.energyStorage.extractEnergy(amountLoadedIntoCart, false);
    }

    public void readFromNBTCustom(NBTTagCompound nbtTagCompound) {
        super.readFromNBTCustom(nbtTagCompound);
        this.energyStorage.readFromNBT(nbtTagCompound);
    }

    public void writeToNBTCustom(NBTTagCompound nbtTagCompound) {
        super.writeToNBTCustom(nbtTagCompound);
        this.energyStorage.writeToNBT(nbtTagCompound);
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int amount, boolean simulate) {
        int received = !this.field_145850_b.field_72995_K && this.canConnectEnergy(forgeDirection) ? this.energyStorage.receiveEnergy(amount, simulate) : 0;
        this.sendBlockUpdate();
        return received;
    }

    public int extractEnergy(ForgeDirection forgeDirection, int amount, boolean simulate) {
        int extracted = this.canConnectEnergy(forgeDirection) ? this.energyStorage.extractEnergy(amount, simulate) : 0;
        this.sendBlockUpdate();
        return extracted;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return this.getSideValue(forgeDirection.ordinal()) != SideType.NONE;
    }
}

