/*
 * Decompiled with CFR 0.152.
 */
package moarcarts.entities;

import moarcarts.MoarCarts;
import moarcarts.entities.EntityMinecartBase;
import moarcarts.fakeworld.FakeWorld;
import moarcarts.network.EntityTileEntityUpdateMessage;
import moarcarts.network.EntityTileEntityUpdateRequestMessage;
import moarcarts.renderers.IRenderBlock;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class EntityMinecartTEBase
extends EntityMinecartBase
implements IRenderBlock {
    protected TileEntity tileEntity;
    private static int IS_DIRTY_DW = 30;
    private static int IS_CLIENT_NEEDY = 28;
    private static int UPDATE_TICKS = 200;

    public EntityMinecartTEBase(World world, int metadata) {
        super(world, metadata);
        if (this.cartBlock instanceof BlockContainer) {
            this.setTileEntity(this.cartBlock.createTileEntity(world, metadata));
        }
        this.setDirty(true);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(IS_DIRTY_DW, (Object)1);
        this.field_70180_af.func_75682_a(IS_CLIENT_NEEDY, (Object)1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (this.isClientNeedy() || this.isDirty() && this.random.nextInt(UPDATE_TICKS) == 0)) {
            this.setDirty(false);
            this.setClientNeedy(false);
            this.sendUpdateToAllAround();
        }
        if (this.shouldTileUpdate()) {
            this.getTileEntity().func_145845_h();
        }
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        this.sendUpdateToAllAround();
        boolean interacted = true;
        if (!player.func_70093_af()) {
            EntityPlayer fakePlayer = MoarCarts.proxy.getFakePlayer(player, this);
            interacted = this.getCartBlock().func_149727_a((World)this.getFakeWorld(), 0, 0, 0, fakePlayer, this.getMetadata(), 0.0f, 0.0f, 0.0f);
            MoarCarts.proxy.resetPlayer(player);
        }
        return interacted;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.getTileEntity().func_145839_a(nbtTagCompound.func_74775_l("TILEENTITY"));
        this.setDirty(nbtTagCompound.func_74767_n("DIRTY"));
        this.setClientNeedy(nbtTagCompound.func_74767_n("NEEDY"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        NBTTagCompound tileEntityNBTTagCompound = new NBTTagCompound();
        this.getTileEntity().func_145841_b(tileEntityNBTTagCompound);
        nbtTagCompound.func_74782_a("TILEENTITY", (NBTBase)tileEntityNBTTagCompound);
        nbtTagCompound.func_74757_a("DIRTY", this.isDirty());
        nbtTagCompound.func_74757_a("NEEDY", this.isClientNeedy());
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public void setTileEntityNBT(ItemStack itemStack) {
        if (itemStack.func_77942_o() && this.shouldSaveDataToItem()) {
            this.getTileEntity().func_145839_a(itemStack.func_77978_p().func_74775_l("tilenbt"));
        }
    }

    @Override
    public IRenderBlock.RenderMethod getRenderMethod() {
        return this.getItem().getCartBlockRenderMethod(this.getCartItem());
    }

    public void sendUpdateToAllAround() {
        if (!this.field_70170_p.field_72995_K) {
            MoarCarts.packetHandler.sendToAllAround(new EntityTileEntityUpdateMessage(this), this);
        }
    }

    public void requestClientUpdate() {
        if (this.field_70170_p.field_72995_K) {
            MoarCarts.packetHandler.sendToServer(new EntityTileEntityUpdateRequestMessage(this));
        }
    }

    @Override
    public void afterEntitySpawned() {
        this.sendUpdateToAllAround();
    }

    public boolean shouldSaveDataToItem() {
        return false;
    }

    @Override
    public void dropCart(ItemStack cartItem) {
        if (this.shouldSaveDataToItem()) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            this.getTileEntity().func_145841_b(nbtTagCompound);
            NBTTagCompound itemNBTTagCompound = cartItem.func_77942_o() ? cartItem.func_77978_p() : new NBTTagCompound();
            this.getTileEntity().func_145841_b(nbtTagCompound);
            itemNBTTagCompound.func_74782_a("tilenbt", (NBTBase)nbtTagCompound);
            cartItem.func_77982_d(itemNBTTagCompound);
        }
        super.dropCart(cartItem);
    }

    public TileEntity createTileEntity() {
        if (this.field_70170_p != null && this.getCartBlock() != null) {
            return this.getCartBlock().createTileEntity(this.field_70170_p, this.getMetadata());
        }
        return null;
    }

    public TileEntity getTileEntity() {
        if (this.tileEntity == null) {
            this.setTileEntity(this.createTileEntity());
        }
        return this.tileEntity;
    }

    public void setTileEntity(TileEntity tileEntity) {
        NBTTagCompound nbtTagCompound = null;
        if (this.tileEntity != null) {
            nbtTagCompound = new NBTTagCompound();
            this.tileEntity.func_145841_b(nbtTagCompound);
        }
        this.tileEntity = tileEntity;
        if (this.tileEntity != null) {
            this.setFakeWorld(new FakeWorld(this));
            this.tileEntity.func_145834_a((World)this.getFakeWorld());
            if (nbtTagCompound != null) {
                this.tileEntity.func_145839_a(nbtTagCompound);
            }
            this.sendUpdateToAllAround();
        } else {
            MoarCarts.logger.error("Null Tile Entity Reported. THIS IS BAD!");
        }
    }

    @Override
    public void setMetadata(int metadata) {
        super.setMetadata(metadata);
        TileEntity tileEntity = this.createTileEntity();
        if (tileEntity != null) {
            this.setTileEntity(tileEntity);
        }
    }

    public boolean shouldTileUpdate() {
        return false;
    }

    public boolean isDirty() {
        return this.field_70180_af.func_75683_a(IS_DIRTY_DW) != 0;
    }

    public void setDirty(boolean isDirty) {
        this.field_70180_af.func_75692_b(IS_DIRTY_DW, (Object)(isDirty ? (byte)1 : 0));
    }

    public boolean isClientNeedy() {
        return this.field_70180_af.func_75683_a(IS_CLIENT_NEEDY) != 0;
    }

    public void setClientNeedy(boolean needy) {
        this.field_70180_af.func_75692_b(IS_CLIENT_NEEDY, (Object)(needy ? (byte)1 : 0));
    }

    public boolean showHalo() {
        return false;
    }

    public String getHaloString() {
        return "";
    }
}

