/*
 * Decompiled with CFR 0.152.
 */
package moarcarts.entities;

import boilerplate.common.utils.ComparatorUtils;
import cpw.mods.fml.common.Optional;
import moarcarts.entities.EntityMinecartTEBase;
import mods.railcraft.api.carts.IFluidCart;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(iface="mods.railcraft.api.carts.IFluidCart", modid="RailcraftAPI|carts")
public abstract class EntityMinecartFluidTEBase
extends EntityMinecartTEBase
implements IFluidHandler,
IFluidCart {
    private static int IS_FILLING = 29;

    public EntityMinecartFluidTEBase(World world, int metadata) {
        super(world, metadata);
    }

    public IFluidHandler getFluidTileEntity() {
        return (IFluidHandler)this.getTileEntity();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(IS_FILLING, (Object)0);
    }

    @Optional.Method(modid="RailcraftAPI|carts")
    public boolean canPassFluidRequests(Fluid fluid) {
        return true;
    }

    @Optional.Method(modid="RailcraftAPI|carts")
    public boolean canAcceptPushedFluid(EntityMinecart entityMinecart, Fluid fluid) {
        return this.getFluidTileEntity().canFill(ForgeDirection.UNKNOWN, fluid);
    }

    @Optional.Method(modid="RailcraftAPI|carts")
    public boolean canProvidePulledFluid(EntityMinecart entityMinecart, Fluid fluid) {
        return this.getFluidTileEntity().canDrain(ForgeDirection.UNKNOWN, fluid);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.getFluidTileEntity().fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.getFluidTileEntity().drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getFluidTileEntity().drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getFluidTileEntity().canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getFluidTileEntity().canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getFluidTileEntity().getTankInfo(from);
    }

    public boolean isFilling() {
        return this.field_70180_af.func_75683_a(IS_FILLING) != 0;
    }

    @Optional.Method(modid="RailcraftAPI|carts")
    public void setFilling(boolean isFilling) {
        this.field_70180_af.func_75692_b(IS_FILLING, (Object)(isFilling ? (byte)1 : 0));
    }

    @Override
    public int getComparatorInputOverride() {
        if (!this.cartBlock.func_149740_M()) {
            return ComparatorUtils.scaleSingleFluidLevelTo((int)15, (IFluidHandler)this);
        }
        return super.getComparatorInputOverride();
    }
}

