/*
 * Decompiled with CFR 0.152.
 */
package moarcarts.entities;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.Random;
import moarcarts.MoarCarts;
import moarcarts.api.IComparatorCart;
import moarcarts.config.ConfigSettings;
import moarcarts.fakeworld.FakeWorld;
import moarcarts.items.ItemMinecartBase;
import mods.railcraft.api.carts.IMinecart;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

@Optional.Interface(iface="mods.railcraft.api.carts.IMinecart", modid="RailcraftAPI|carts")
public abstract class EntityMinecartBase
extends EntityMinecart
implements IMinecart,
IComparatorCart {
    protected Block cartBlock;
    protected Random random;
    protected FakeWorld fakeWorld;
    private static int METADATA_DW = 31;
    private static String METADATA = "METADATA";

    public EntityMinecartBase(World world, int metadata) {
        super(world);
        this.setMetadata(metadata);
        this.fakeWorld = new FakeWorld(this);
        this.random = new Random();
    }

    public abstract ItemMinecartBase getItem();

    public ItemStack getCartItem() {
        int metaData = this.getItem().func_77614_k() ? this.getMetadata() : 0;
        return new ItemStack((Item)this.getItem(), 1, metaData);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(METADATA_DW, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setMetadata(nbtTagCompound.func_74762_e(METADATA));
    }

    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a(METADATA, this.getMetadata());
    }

    public Block func_145820_n() {
        return this.getCartBlock();
    }

    public Block func_145817_o() {
        return this.getCartBlock();
    }

    public int func_94098_o() {
        return this.getMetadata();
    }

    public void func_94095_a(DamageSource damageSource) {
        this.func_70106_y();
    }

    public int func_94087_l() {
        return 1;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarCarts.instance, (int)2, (World)player.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
        }
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shouldDoDisplayTick() && this.field_70170_p.field_72995_K && this.random.nextInt(10) == 0) {
            this.doDisplayTick();
        }
    }

    public void afterEntitySpawned() {
    }

    public void func_70020_e(NBTTagCompound nbtTagCompound) {
        super.func_70020_e(nbtTagCompound);
    }

    public void func_70109_d(NBTTagCompound nbtTagCompound) {
        super.func_70109_d(nbtTagCompound);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70106_y() {
        ItemStack blockCartItemStack;
        super.func_70106_y();
        if (ConfigSettings.doMinecartsBreakOnDrop()) {
            blockCartItemStack = new ItemStack(this.getCartBlock());
            ItemStack cartItemStack = new ItemStack(Items.field_151143_au, 1);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(cartItemStack, 0.1f);
            }
        } else {
            blockCartItemStack = this.getCartItem();
            if (this.func_95999_t() != null && !this.func_95999_t().isEmpty()) {
                blockCartItemStack.func_151001_c(this.func_95999_t());
            }
        }
        this.dropCart(blockCartItemStack);
    }

    public void dropCart(ItemStack cartItem) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70099_a(cartItem, 0.1f);
        }
    }

    @Optional.Method(modid="RailcraftAPI|carts")
    public boolean doesCartMatchFilter(ItemStack itemStack, EntityMinecart entityMinecart) {
        return itemStack != null && entityMinecart instanceof EntityMinecartBase && itemStack.func_77969_a(entityMinecart.getCartItem());
    }

    @Override
    public int getComparatorInputOverride() {
        if (this.getCartBlock().func_149740_M()) {
            return this.getCartBlock().func_149736_g((World)this.getFakeWorld(), 0, 0, 0, this.getMetadata());
        }
        return 0;
    }

    public boolean canBeRidden() {
        return false;
    }

    public boolean shouldDoDisplayTick() {
        return false;
    }

    public void doDisplayTick() {
        int intPosX = (int)Math.floor(this.field_70165_t);
        int intPosY = (int)Math.floor(this.field_70163_u);
        int intPosZ = (int)Math.floor(this.field_70161_v);
        this.getCartBlock().func_149734_b((World)this.getFakeWorld(), intPosX, intPosY, intPosZ, this.random);
    }

    public Block getCartBlock() {
        return this.getItem().getCartBlock(this.getCartItem());
    }

    public void setCartBlock(Block cartBlock) {
        this.cartBlock = cartBlock;
    }

    public int getMetadata() {
        return this.field_70180_af.func_75679_c(METADATA_DW);
    }

    public void setMetadata(int metadata) {
        this.field_70180_af.func_75692_b(METADATA_DW, (Object)metadata);
    }

    public FakeWorld getFakeWorld() {
        if (this.fakeWorld == null) {
            this.fakeWorld = new FakeWorld(this);
        }
        return this.fakeWorld;
    }

    public void setFakeWorld(FakeWorld fakeWorld) {
        this.fakeWorld = fakeWorld;
    }
}

