/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.rf;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;
import powercrystals.powerconverters.power.systems.rf.TileEntityRFConsumer;

public class TileEntityRFProducer
extends TileEntityEnergyProducer<IEnergyConnection>
implements IEnergyProvider {
    public TileEntityRFProducer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("RF"), 0, IEnergyConnection.class);
    }

    @Override
    public double produceEnergy(double energy) {
        boolean powered;
        double tmpEnergyPerOutput = this.getPowerSystem().getInternalEnergyPerOutput(0);
        double energyToUse = energy / tmpEnergyPerOutput;
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (!powered && energyToUse > 0.0) {
            List<BlockPosition> positions = new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e).getAdjacent(true);
            for (BlockPosition p : positions) {
                IEnergyReceiver eReceiver;
                IEnergyHandler eHandler;
                double received;
                TileEntity te = this.field_145850_b.func_147438_o(p.x, p.y, p.z);
                if (te instanceof TileEntityRFConsumer || te instanceof TileEntityEnergyBridge || !(te instanceof IEnergyHandler ? (energy -= (received = (double)(eHandler = (IEnergyHandler)te).receiveEnergy(p.orientation.getOpposite(), (int)energyToUse, false)) * tmpEnergyPerOutput) <= 0.0 : te instanceof IEnergyReceiver && (energy -= (received = (double)(eReceiver = (IEnergyReceiver)te).receiveEnergy(p.orientation.getOpposite(), (int)energyToUse, false)) * tmpEnergyPerOutput) <= 0.0)) continue;
                break;
            }
        }
        return energy;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)((float)bridge.getEnergyStored() / this.getPowerSystem().getInternalEnergyPerInput(0));
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)((float)bridge.getEnergyStoredMax() / this.getPowerSystem().getInternalEnergyPerInput(0));
    }
}

