/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.systems.gt5.BlockGregTech;
import powercrystals.powerconverters.power.systems.gt5.ItemBlockGregTech;
import powercrystals.powerconverters.power.systems.gt5.TileEntityGregTechConsumer;
import powercrystals.powerconverters.power.systems.gt5.TileEntityGregTechProducer;

public class PowerGregTech5
extends PowerSystem {
    public static final String id = "GT";
    public static final float DEFAULT_ENERGY_PER_INPUT = 4000.0f;
    public static final float DEFAULT_ENERGY_PER_OUTPUT = 4000.0f;
    public static final String CATEGORY_FACTORIZATION = "powersystems.gt";
    public static final String[] VOLTAGE_NAMES = new String[]{"ULV", "LV", "MV", "HV", "EV", "IV", "LuV", "ZPMV", "UV"};
    public static final int[] VOLTAGE_VALUES = new int[]{8, 32, 128, 512, 2048, 8192, 32768, 131072, 524288};

    public PowerGregTech5() {
        this.name = "GregTech";
        this._internalEnergyPerInput = 4000.0f;
        this._internalEnergyPerOutput = 4000.0f;
        this._unit = "EU";
        this.voltageNames = VOLTAGE_NAMES;
        this.voltageValues = VOLTAGE_VALUES;
        this.block = new BlockGregTech();
        this.itemBlock = ItemBlockGregTech.class;
        this.consumer = TileEntityGregTechConsumer.class;
        this.producer = TileEntityGregTechProducer.class;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void registerBlocks() {
        GameRegistry.registerBlock((Block)this.block, (Class)this.itemBlock, (String)"converter.gt");
        GameRegistry.registerTileEntity((Class)this.consumer, (String)"powerConverterGTConsumer");
        GameRegistry.registerTileEntity((Class)this.producer, (String)"powerConverterGTProducer");
    }

    @Override
    public void registerCommonRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 1), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 0), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 3), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 2), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 5), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 4), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 5)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 7), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 6)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 6), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 7)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 9), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 8)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 8), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 9)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 11), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 10)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 10), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 11)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 13), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 12)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 12), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 13)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 15), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 14)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 14), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 15)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 17), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 16)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 16), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 17)});
    }

    @Override
    public void loadConfig(Configuration c) {
        this._internalEnergyPerInput = (float)c.get(CATEGORY_FACTORIZATION, "internalEnergyPerInput", 4000.0).getDouble(4000.0);
        this._internalEnergyPerOutput = (float)c.get(CATEGORY_FACTORIZATION, "internalEnergyPerOutput", 4000.0).getDouble(4000.0);
    }

    @Override
    public void saveConfig(Configuration c) {
        c.getCategory(CATEGORY_FACTORIZATION).get("internalEnergyPerInput").set((double)this._internalEnergyPerInput);
        c.getCategory(CATEGORY_FACTORIZATION).get("internalEnergyPerOutput").set((double)this._internalEnergyPerOutput);
    }

    @Override
    public String getRateString(BridgeSideData data) {
        long EUt = VOLTAGE_VALUES[data.voltageNameIndex];
        long AMP = (long)Math.ceil(data.outputRate / (double)EUt);
        return AMP + " A";
    }
}

