/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import powercrystals.powerconverters.common.BlockPowerConverterCommon;
import powercrystals.powerconverters.common.ItemBlockPowerConverterCommon;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.crafting.RecipeProvider;
import powercrystals.powerconverters.crafting.mods.RecipeBuildCraft;
import powercrystals.powerconverters.crafting.mods.RecipeEnderIO;
import powercrystals.powerconverters.crafting.mods.RecipeFactorization;
import powercrystals.powerconverters.crafting.mods.RecipeForestry;
import powercrystals.powerconverters.crafting.mods.RecipeGregTech5;
import powercrystals.powerconverters.crafting.mods.RecipeIndustrialCraft;
import powercrystals.powerconverters.crafting.mods.RecipeMFFS;
import powercrystals.powerconverters.crafting.mods.RecipeRailcraft;
import powercrystals.powerconverters.crafting.mods.RecipeThermalExpansion;
import powercrystals.powerconverters.crafting.mods.RecipeVanilla;
import powercrystals.powerconverters.gui.PCGUIHandler;
import powercrystals.powerconverters.network.PacketClientSync;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.systems.PowerFactorization;
import powercrystals.powerconverters.power.systems.PowerFortron;
import powercrystals.powerconverters.power.systems.PowerGregTech5;
import powercrystals.powerconverters.power.systems.PowerIndustrialcraft;
import powercrystals.powerconverters.power.systems.PowerRedstoneFlux;
import powercrystals.powerconverters.power.systems.PowerSteam;

@Mod(modid="PowerConverters", name="Power Converters", dependencies="after:BuildCraft|Energy;after:factorization;after:IC2;after:Railcraft;after:ThermalExpansion;after:gregtech;after:MFFS")
public final class PowerConverterCore {
    public static final String modId = "PowerConverters";
    public static final String modName = "Power Converters";
    public static final String version;
    public static final String guiFolder = "PowerConverters:textures/gui/";
    public static Block converterBlockCommon;
    @Mod.Instance(value="PowerConverters")
    public static PowerConverterCore instance;
    public static int bridgeBufferSize;
    private Set<RecipeProvider> enabledRecipes;
    public SimpleNetworkWrapper networkWrapper;
    public Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.logger = evt.getModLog();
        evt.getModMetadata().version = version;
        FMLCommonHandler.instance().bus().register((Object)this);
        this.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("powerconverters");
        this.networkWrapper.registerMessage(PacketClientSync.Handler.class, PacketClientSync.class, 0, Side.CLIENT);
        this.registerPowerSystems();
        File dir = evt.getModConfigurationDirectory();
        this.loadConfig(dir);
        converterBlockCommon = new BlockPowerConverterCommon();
        GameRegistry.registerBlock((Block)converterBlockCommon, ItemBlockPowerConverterCommon.class, (String)"converter.common");
        GameRegistry.registerTileEntity(TileEntityEnergyBridge.class, (String)"powerConverterEnergyBridge");
        GameRegistry.registerTileEntity(TileEntityCharger.class, (String)"powerConverterUniversalCharger");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) throws Exception {
        PowerSystemManager.getInstance().registerBlocks();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent unused) throws Exception {
        this.logger.info("+++++++++++++++++++++++++[PowerConverters][NOTICE]+++++++++++++++++++++++++");
        this.logger.info("Default power ratios are based on FTB standards and not all mods follow these");
        this.logger.info("If you find conflicting ratios in your pack, please adjust the config acoordingly or remove PC");
        this.logger.info("These conflicts are not the fault of any mod author. It is the nature on minecraft");
        this.logger.info("-------------------------[PowerConverters][STEAM]-------------------------");
        this.logger.info("Default steam ratios, while based on standards, will create infinite energy loops");
        this.logger.info("To prevent over powered infinite energy, use a steam throttle values of less than 5");
        this.logger.info("+++++++++++++++++++++++++[PowerConverters][NOTICE]+++++++++++++++++++++++++");
        PowerSystemManager.getInstance().registerCommonRecipes();
        for (RecipeProvider provider : this.enabledRecipes) {
            provider.registerRecipes();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new PCGUIHandler());
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    private void registerPowerSystems() {
        ModContainer modContainer;
        PowerSystemManager manager = PowerSystemManager.getInstance();
        this.enabledRecipes = new HashSet<RecipeProvider>();
        this.enabledRecipes.add(new RecipeVanilla());
        if (FluidRegistry.isFluidRegistered((String)"steam")) {
            if (manager.getPowerSystemByName(PowerSteam.id) == null) {
                manager.registerPowerSystem(new PowerSteam());
            }
            ((PowerSteam)manager.getPowerSystemByName(PowerSteam.id)).addSteamType("steam", "Steam", 500.0f, 500.0f);
        }
        if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
            this.enabledRecipes.add(new RecipeBuildCraft());
            if (manager.getPowerSystemByName("RF") == null) {
                manager.registerPowerSystem(new PowerRedstoneFlux());
            }
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            this.enabledRecipes.add(new RecipeEnderIO());
            if (manager.getPowerSystemByName("RF") == null) {
                manager.registerPowerSystem(new PowerRedstoneFlux());
            }
        }
        if (Loader.isModLoaded((String)"factorization")) {
            this.enabledRecipes.add(new RecipeFactorization());
            if (manager.getPowerSystemByName("FZ") == null) {
                manager.registerPowerSystem(new PowerFactorization());
            }
        }
        if (Loader.isModLoaded((String)"IC2")) {
            this.enabledRecipes.add(new RecipeIndustrialCraft());
            if (manager.getPowerSystemByName("IC2") == null) {
                manager.registerPowerSystem(new PowerIndustrialcraft());
            }
            if (manager.getPowerSystemByName(PowerSteam.id) == null) {
                manager.registerPowerSystem(new PowerSteam());
            }
            ((PowerSteam)manager.getPowerSystemByName(PowerSteam.id)).addSteamType("ic2steam", "IC2 Steam", 500.0f, 500.0f);
            ((PowerSteam)manager.getPowerSystemByName(PowerSteam.id)).addSteamType("ic2superheatedsteam", "IC2 Superheated Steam", 500.0f, 500.0f);
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            this.enabledRecipes.add(new RecipeRailcraft());
            if (manager.getPowerSystemByName(PowerSteam.id) == null) {
                manager.registerPowerSystem(new PowerSteam());
            }
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            this.enabledRecipes.add(new RecipeForestry());
            if (manager.getPowerSystemByName("RF") == null) {
                manager.registerPowerSystem(new PowerRedstoneFlux());
            }
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            this.enabledRecipes.add(new RecipeThermalExpansion());
            if (manager.getPowerSystemByName("RF") == null) {
                manager.registerPowerSystem(new PowerRedstoneFlux());
            }
        }
        if (Loader.isModLoaded((String)"gregtech") && "MC1710".equals((modContainer = (ModContainer)Loader.instance().getIndexedModList().get("gregtech")).getVersion())) {
            this.enabledRecipes.add(new RecipeGregTech5());
            if (manager.getPowerSystemByName("GT") == null) {
                manager.registerPowerSystem(new PowerGregTech5());
            }
        }
        if (Loader.isModLoaded((String)"MFFS")) {
            this.enabledRecipes.add(new RecipeMFFS());
            if (manager.getPowerSystemByName("Fortron") == null) {
                manager.registerPowerSystem(new PowerFortron());
            }
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent event) {
        if (event.getSide().isServer()) {
            this.logger.debug("Server: initialising powersystem data.");
            PowerSystemManager.getInstance().setServerSystemIds();
        }
    }

    @SubscribeEvent
    public void clientConnected(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player == null || event.player.field_70170_p == null || event.player.field_70170_p.field_72995_K || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound energyNBT = PowerSystemManager.getInstance().writePowerData();
        PacketClientSync packetClientSync = new PacketClientSync(energyNBT);
        this.networkWrapper.sendTo((IMessage)packetClientSync, (EntityPlayerMP)event.player);
        this.logger.debug("Sending sync packet to player %s", new Object[]{event.player.toString()});
    }

    public static Object tryOreDict(String name, ItemStack itemStack) {
        for (ItemStack ore : OreDictionary.getOres((String)name)) {
            if (!ore.func_77969_a(itemStack)) continue;
            return name;
        }
        return itemStack;
    }

    private void loadConfig(File dir) {
        dir = new File(new File(dir, modId.toLowerCase()), "common.cfg");
        Configuration c = new Configuration(dir);
        bridgeBufferSize = c.get("general", "bridgeBufferSize", 160000000).getInt();
        for (RecipeProvider provider : this.enabledRecipes) {
            provider.loadConfig(c);
        }
        PowerSystemManager.getInstance().loadConfigs(c);
        c.save();
    }

    static {
        Properties prop = new Properties();
        try {
            InputStream stream = PowerConverterCore.class.getClassLoader().getResourceAsStream("version.properties");
            prop.load(stream);
            stream.close();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        version = String.format("%s_build-%s", prop.getProperty("version"), prop.getProperty("build_number"));
    }
}

