/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ColorUtils {
    private static final Map<String, ColorMeta> COLORS_BY_ORE_NAME = Maps.newHashMap();
    private static final Map<String, ColorMeta> COLORS_BY_NAME = Maps.newHashMap();
    private static final Map<Integer, ColorMeta> COLORS_BY_ORE_ID = Maps.newHashMap();
    private static final Map<Integer, ColorMeta> COLORS_BY_BITMASK = Maps.newHashMap();

    public static Set<ColorMeta> stackToColor(ItemStack stack) {
        Set result = Sets.newIdentityHashSet();
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            ColorMeta meta = COLORS_BY_ORE_ID.get(oreId);
            if (meta == null) continue;
            result.add(meta);
        }
        return result;
    }

    public static ColorMeta oreIdToColor(int oreId) {
        return COLORS_BY_ORE_ID.get(oreId);
    }

    public static ColorMeta oreNameToColor(String oreName) {
        return COLORS_BY_ORE_NAME.get(oreName);
    }

    public static ColorMeta nameToColor(String name) {
        return COLORS_BY_NAME.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static ColorMeta bitmaskToColor(int bitmask) {
        return COLORS_BY_BITMASK.get(bitmask);
    }

    public static ColorMeta vanillaBlockToColor(int vanillaId) {
        return ColorMeta.COLORS[~vanillaId & 0xF];
    }

    public static ColorMeta vanillaDyeToColor(int vanillaId) {
        return ColorMeta.COLORS[vanillaId & 0xF];
    }

    public static Collection<ColorMeta> getAllColors() {
        return ImmutableList.copyOf((Object[])ColorMeta.COLORS);
    }

    public static int bitmaskToVanilla(int color) {
        int low;
        int high = Integer.numberOfLeadingZeros(color);
        Preconditions.checkArgument((high == 31 - (low = Integer.numberOfTrailingZeros(color)) && low <= 16 ? 1 : 0) != 0, (String)"Invalid color value: %sb", (Object[])new Object[]{Integer.toBinaryString(color)});
        return low;
    }

    public static ColorMeta findNearestColor(RGB target, int tolernace) {
        ColorMeta result = null;
        int distSq = Integer.MAX_VALUE;
        for (ColorMeta meta : ColorMeta.COLORS) {
            int currentDistSq = meta.rgbWrap.distanceSq(target);
            if (currentDistSq >= distSq) continue;
            result = meta;
            distSq = currentDistSq;
        }
        return distSq < 3 * tolernace * tolernace ? result : null;
    }

    static {
        for (ColorMeta color : ColorMeta.COLORS) {
            COLORS_BY_NAME.put(color.name, color);
            COLORS_BY_ORE_NAME.put(color.oreName, color);
            COLORS_BY_ORE_ID.put(color.oreId, color);
            COLORS_BY_BITMASK.put(color.bitmask, color);
        }
    }

    public static class CYMK {
        private float cyan;
        private float yellow;
        private float magenta;
        private float key;

        public CYMK(float c, float y, float m, float k) {
            this.cyan = c;
            this.yellow = y;
            this.magenta = m;
            this.key = k;
        }

        public float getCyan() {
            return this.cyan;
        }

        public void setCyan(float cyan) {
            this.cyan = cyan;
        }

        public float getYellow() {
            return this.yellow;
        }

        public void setYellow(float yellow) {
            this.yellow = yellow;
        }

        public float getMagenta() {
            return this.magenta;
        }

        public void setMagenta(float magenta) {
            this.magenta = magenta;
        }

        public float getKey() {
            return this.key;
        }

        public void setKey(float key) {
            this.key = key;
        }
    }

    public static class RGB {
        public int r;
        public int g;
        public int b;

        public RGB(float r, float g, float b) {
            this.r = (int)(r * 255.0f) & 0xFF;
            this.g = (int)(g * 255.0f) & 0xFF;
            this.b = (int)(b * 255.0f) & 0xFF;
        }

        public RGB(int r, int g, int b) {
            this.r = r & 0xFF;
            this.g = g & 0xFF;
            this.b = b & 0xFF;
        }

        public RGB(int color) {
            this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
        }

        public RGB() {
        }

        public void setColor(int color) {
            this.r = (color & 0xFF0000) >> 16;
            this.g = (color & 0xFF00) >> 8;
            this.b = color & 0xFF;
        }

        public int getColor() {
            return this.r << 16 | this.g << 8 | this.b;
        }

        public float getR() {
            return (float)this.r / 255.0f;
        }

        public float getG() {
            return (float)this.g / 255.0f;
        }

        public float getB() {
            return (float)this.b / 255.0f;
        }

        public RGB interpolate(RGB other, double amount) {
            int iPolR = (int)((double)this.r * (1.0 - amount) + (double)other.r * amount);
            int iPolG = (int)((double)this.g * (1.0 - amount) + (double)other.g * amount);
            int iPolB = (int)((double)this.b * (1.0 - amount) + (double)other.b * amount);
            return new RGB(iPolR, iPolG, iPolB);
        }

        public CYMK toCYMK() {
            float cyan = 1.0f - (float)this.r / 255.0f;
            float magenta = 1.0f - (float)this.g / 255.0f;
            float yellow = 1.0f - (float)this.b / 255.0f;
            float K = 1.0f;
            if (cyan < K) {
                K = cyan;
            }
            if (magenta < K) {
                K = magenta;
            }
            if (yellow < K) {
                K = yellow;
            }
            if (K == 1.0f) {
                cyan = 0.0f;
                magenta = 0.0f;
                yellow = 0.0f;
            } else {
                cyan = (cyan - K) / (1.0f - K);
                magenta = (magenta - K) / (1.0f - K);
                yellow = (yellow - K) / (1.0f - K);
            }
            return new CYMK(cyan, yellow, magenta, K);
        }

        public int distanceSq(RGB other) {
            int dR = this.r - other.r;
            int dG = this.g - other.g;
            int dB = this.b - other.b;
            return dR * dR + dG * dG + dB * dB;
        }
    }

    public static enum ColorMeta {
        BLACK("black", 0x1E1B1B),
        RED("red", 11743532),
        GREEN("green", 3887386),
        BROWN("brown", 5320730),
        BLUE("blue", 2437522),
        PURPLE("purple", 8073150),
        CYAN("cyan", 2651799),
        LIGHT_GRAY("lightGray", "silver", 0xABABAB),
        GRAY("gray", 0x434343),
        PINK("pink", 14188952),
        LIME("lime", 4312372),
        YELLOW("yellow", 14602026),
        LIGHT_BLUE("lightBlue", "light_blue", 6719955),
        MAGENTA("magenta", 12801229),
        ORANGE("orange", 15435844),
        WHITE("white", 0xF0F0F0);

        public final int rgb;
        public final int vanillaDyeId;
        public final int vanillaBlockId;
        public final int oreId;
        public final int bitmask;
        public final String oreName;
        public final String name;
        public final String unlocalizedName;
        public final String textureName;
        public final RGB rgbWrap;
        public final CYMK cymkWrap;
        private static final ColorMeta[] COLORS;

        public ItemStack createStack(Block block, int amount) {
            return new ItemStack(block, amount, this.vanillaBlockId);
        }

        public ItemStack createStack(Item item, int amount) {
            return new ItemStack(item, amount, this.vanillaDyeId);
        }

        private ColorMeta(String name, int rgb) {
            this(name, name, rgb);
        }

        private ColorMeta(String name, String textureName, int rgb) {
            int index;
            this.oreName = "dye" + WordUtils.capitalize((String)name);
            this.oreId = OreDictionary.getOreID((String)this.oreName);
            this.textureName = textureName;
            this.name = name.toLowerCase(Locale.ENGLISH);
            this.unlocalizedName = "openmodslib.color." + name;
            this.rgb = rgb;
            this.vanillaDyeId = index = this.ordinal();
            this.vanillaBlockId = ~index & 0xF;
            this.bitmask = 1 << this.vanillaBlockId;
            this.rgbWrap = new RGB(rgb);
            this.cymkWrap = this.rgbWrap.toCYMK();
        }

        static {
            COLORS = ColorMeta.values();
        }
    }
}

