/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Optional;
import openmods.calc.ICalculatorFrame;
import openmods.calc.ISymbol;
import openmods.calc.StackValidationException;

public abstract class FixedSymbol<E>
implements ISymbol<E> {
    protected final int argCount;
    protected final int resultCount;

    public FixedSymbol(int argCount, int resultCount) {
        this.argCount = argCount;
        this.resultCount = resultCount;
    }

    @Override
    public final void execute(ICalculatorFrame<E> frame, Optional<Integer> argumentsCount, Optional<Integer> returnsCount) {
        int returns;
        int args;
        if (argumentsCount.isPresent() && (args = ((Integer)argumentsCount.get()).intValue()) != this.argCount) {
            throw new StackValidationException("Expected %s argument(s) but got %s", this.argCount, args);
        }
        if (returnsCount.isPresent() && (returns = ((Integer)returnsCount.get()).intValue()) != this.resultCount) {
            throw new StackValidationException("Expected %s result(s) but got %s", this.resultCount, returns);
        }
        this.execute(frame);
    }

    public abstract void execute(ICalculatorFrame<E> var1);
}

