/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import openmods.calc.Constant;
import openmods.calc.ExprTokenizerFactory;
import openmods.calc.FixedSymbol;
import openmods.calc.ICalculatorFrame;
import openmods.calc.ICompiler;
import openmods.calc.IExecutable;
import openmods.calc.ISymbol;
import openmods.calc.IValueParser;
import openmods.calc.InfixCompiler;
import openmods.calc.OperatorDictionary;
import openmods.calc.PostfixCompiler;
import openmods.calc.StackValidationException;
import openmods.calc.Token;
import openmods.calc.TopFrame;
import openmods.utils.Stack;

public abstract class Calculator<E> {
    public static final String VAR_ANS = "$ans";
    private final TopFrame<E> topFrame = new TopFrame();
    private final OperatorDictionary<E> operators = new OperatorDictionary();
    private final ExprTokenizerFactory tokenizerFactory = new ExprTokenizerFactory();
    private final ICompiler<E> rpnCompiler;
    private final ICompiler<E> infixCompiler;
    private final E nullValue;

    public Calculator(IValueParser<E> parser, E nullValue) {
        this.nullValue = nullValue;
        this.setupOperators(this.operators);
        for (String operator : this.operators.allOperators()) {
            this.tokenizerFactory.addOperator(operator);
        }
        this.rpnCompiler = new PostfixCompiler<E>(parser, this.operators);
        this.infixCompiler = new InfixCompiler<E>(parser, this.operators);
        Calculator.setupGenericFunctions(this.topFrame);
        this.setupGlobals(this.topFrame);
    }

    private static <E> void setupGenericFunctions(TopFrame<E> topFrame) {
        topFrame.setSymbol("swap", new FixedSymbol<E>(2, 2){

            @Override
            public void execute(ICalculatorFrame<E> frame) {
                Stack stack = frame.stack();
                Object first = stack.pop();
                Object second = stack.pop();
                stack.push(first);
                stack.push(second);
            }
        });
        topFrame.setSymbol("pop", new ISymbol<E>(){

            @Override
            public void execute(ICalculatorFrame<E> frame, Optional<Integer> argumentsCount, Optional<Integer> returnsCount) {
                if (returnsCount.isPresent() && (Integer)returnsCount.get() != 0) {
                    throw new StackValidationException("Invalid expected return values on 'pop'", new Object[0]);
                }
                Stack stack = frame.stack();
                int count = (Integer)argumentsCount.or((Object)1);
                for (int i = 0; i < count; ++i) {
                    stack.pop();
                }
            }
        });
        topFrame.setSymbol("dup", new ISymbol<E>(){

            @Override
            public void execute(ICalculatorFrame<E> frame, Optional<Integer> argumentsCount, Optional<Integer> returnsCount) {
                Stack stack = frame.stack();
                List values = Lists.newArrayList();
                int in = (Integer)argumentsCount.or((Object)1);
                for (int i = 0; i < in; ++i) {
                    Object value = stack.pop();
                    values.add(value);
                }
                values = Lists.reverse((List)values);
                int out = (Integer)returnsCount.or((Object)(2 * in));
                for (int i = 0; i < out; ++i) {
                    Object value = values.get(i % in);
                    stack.push(value);
                }
            }
        });
    }

    public abstract String toString(E var1);

    protected abstract void setupOperators(OperatorDictionary<E> var1);

    protected abstract void setupGlobals(TopFrame<E> var1);

    public IExecutable<E> compile(ExprType type, String input) {
        Iterable<Token> tokens = this.tokenizerFactory.tokenize(input);
        switch (type) {
            case INFIX: {
                return this.infixCompiler.compile(tokens);
            }
            case POSTFIX: {
                return this.rpnCompiler.compile(tokens);
            }
        }
        throw new IllegalArgumentException(type.name());
    }

    public void setGlobalSymbol(String id, ISymbol<E> value) {
        this.topFrame.setSymbol(id, value);
    }

    public int stackSize() {
        return this.topFrame.stack().size();
    }

    public Iterable<E> getStack() {
        return Iterables.unmodifiableIterable(this.topFrame.stack());
    }

    public Iterable<String> printStack() {
        return Iterables.transform(this.topFrame.stack(), (Function)new Function<E, String>(){

            @Nullable
            public String apply(@Nullable E input) {
                return Calculator.this.toString(input);
            }
        });
    }

    public void execute(IExecutable<E> executable) {
        executable.execute(this.topFrame);
    }

    public E executeAndPop(IExecutable<E> executable) {
        executable.execute(this.topFrame);
        Stack<E> stack = this.topFrame.stack();
        if (stack.isEmpty()) {
            this.topFrame.setSymbol(VAR_ANS, Constant.create(this.nullValue));
            return null;
        }
        E result = stack.pop();
        this.topFrame.setSymbol(VAR_ANS, Constant.create(result));
        return result;
    }

    public static String decorateBase(boolean allowCustom, int base, String value) {
        if (allowCustom) {
            switch (base) {
                case 2: {
                    return "0b" + value;
                }
                case 8: {
                    return "0" + value;
                }
                case 10: {
                    return value;
                }
                case 16: {
                    return "0x" + value;
                }
            }
            return Integer.toString(base) + "#" + value;
        }
        return Integer.toString(base) + "#" + value;
    }

    public static enum ExprType {
        POSTFIX,
        INFIX;

    }

    protected abstract class AccumulatorFunction
    implements ISymbol<E> {
        protected AccumulatorFunction() {
        }

        @Override
        public void execute(ICalculatorFrame<E> frame, Optional<Integer> argumentsCount, Optional<Integer> returnsCount) {
            if (returnsCount.isPresent() && (Integer)returnsCount.get() != 1) {
                throw new StackValidationException("Invalid expected return values count", new Object[0]);
            }
            Stack<Object> stack = frame.stack();
            int args = (Integer)argumentsCount.or((Object)2);
            if (args == 0) {
                stack.push(Calculator.this.nullValue);
            } else {
                Object result = stack.pop();
                for (int i = 1; i < args; ++i) {
                    Object value = stack.pop();
                    result = this.accumulate(result, value);
                }
                stack.push(result);
            }
        }

        protected abstract E accumulate(E var1, E var2);
    }

    protected static interface Accumulator<E> {
        public E accumulate(E var1, E var2);
    }
}

