/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import router.reborn.RouterReborn;
import router.reborn.cfg;
import router.reborn.item.rfToolBase;
import router.reborn.util.util;

public class itemToolPickaxe
extends rfToolBase {
    public String toolClass = "pickaxe";
    private float damageVsEntity;
    private float efficiencyOnProperMaterial;
    private static final Set blocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc, Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh});
    private Item.ToolMaterial material;
    public int currentMode = 0;

    public itemToolPickaxe(Item.ToolMaterial material) {
        super(material, blocks);
        this.func_77655_b("pickaxe");
        this.func_77637_a(RouterReborn.ueTab);
        this.func_111206_d("pickaxe");
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.efficiencyOnProperMaterial = material.func_77998_b();
        this.damageVsEntity = (float)material.func_77996_d() + material.func_78000_c();
        this.material = material;
        this.material.customCraftingMaterial = Items.field_151137_ax;
        GameRegistry.registerItem((Item)this, (String)"pickaxe");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("RouterReborn:pickaxe");
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return this.material.func_77996_d();
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"axe", (Object)"shovel");
    }

    public boolean func_150897_b(Block p_150897_1_) {
        int bhl = p_150897_1_.getHarvestLevel(0);
        int phl = this.getHarvestLevel(new ItemStack((Item)this), this.toolClass);
        return p_150897_1_.getHarvestLevel(0) <= this.getHarvestLevel(new ItemStack((Item)this), this.toolClass);
    }

    public void saveNBT(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (tag.func_74764_b("pickaxemode")) {
            tag.func_82580_o("pickaxemode");
        }
        tag.func_74768_a("pickaxemode", this.currentMode);
        stack.func_77982_d(tag);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af()) {
            ++this.currentMode;
            if (this.currentMode > 2) {
                this.currentMode = 0;
            }
            String message = "";
            switch (this.currentMode) {
                case 0: {
                    message = "\u00a77Mode: \u00a7asingle block";
                    break;
                }
                case 1: {
                    message = "\u00a77Mode: \u00a7a3x3";
                    break;
                }
                case 2: {
                    message = "\u00a77Mode: \u00a7a5x5";
                    break;
                }
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            this.saveNBT(item);
            return item;
        }
        return super.func_77659_a(item, world, player);
    }

    public boolean func_150894_a(ItemStack item, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (this.material.func_77997_a() - item.func_77960_j() == 1) {
            item.func_77964_b(this.material.func_77997_a());
            world.func_72956_a((Entity)entity, "random.break", 1.0f, 1.0f);
            return false;
        }
        return super.func_150894_a(item, world, block, x, y, z, entity);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && cfg.pickaxecanplacetorches) {
            Block block = player.field_70170_p.func_147439_a(x, y, z);
            TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
            if ((block != null && tile == null || block != null && !(tile instanceof IInventory)) && this.placeTorch(new ItemStack(Blocks.field_150478_aa, 1), player, world, x, y, z, side, hitX, hitY, hitZ)) {
                return false;
            }
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public int getCurrentMode(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b("pickaxemode")) {
                return tag.func_74762_e("pickaxemode");
            }
            return 0;
        }
        return 0;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        this.currentMode = tag != null ? (tag.func_74764_b("pickaxemode") ? tag.func_74762_e("pickaxemode") : 0) : 0;
        if (player.func_70093_af()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        MovingObjectPosition mop = util.raytraceFromEntity(player.field_70170_p, (Entity)player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int sideHit = mop.field_72310_e;
        int breakRadius = this.currentMode;
        int breakDepth = 0;
        int xRange = breakRadius;
        int yRange = breakRadius;
        int zRange = breakDepth;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = breakDepth;
                zRange = breakRadius;
                break;
            }
            case 2: 
            case 3: {
                xRange = breakRadius;
                zRange = breakDepth;
                break;
            }
            case 4: 
            case 5: {
                xRange = breakDepth;
                zRange = breakRadius;
            }
        }
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (xPos == x && yPos == y && zPos == z || super.onBlockStartBreak(stack, xPos, yPos, zPos, player)) continue;
                    util.breakExtraBlock(player.field_70170_p, xPos, yPos, zPos, sideHit, player, x, y, z);
                }
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.set(0, "\u00a73" + StatCollector.func_74838_a((String)(this.func_77658_a() + ".name")) + "\u00a7r");
        NBTTagCompound tag = par1ItemStack.func_77978_p();
        if (tag != null && tag.func_74764_b("pickaxemode")) {
            this.currentMode = tag.func_74762_e("pickaxemode");
        }
        par3List.add("");
        switch (this.currentMode) {
            case 0: {
                par3List.add("\u00a77Mode: \u00a7asingle block");
                break;
            }
            case 1: {
                par3List.add("\u00a77Mode: \u00a7a3x3");
                break;
            }
            case 2: {
                par3List.add("\u00a77Mode: \u00a7a5x5");
                break;
            }
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int i, boolean p_77663_5_) {
        super.func_77663_a(item, world, entity, i, p_77663_5_);
    }

    public static void checkBlocksAndHarvest(EntityPlayer player, int x, int y, int z, int side) {
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block != null) {
            if (block.getHarvestLevel(player.field_70170_p.func_72805_g(x, y, z)) <= RouterReborn.itemPickaxe.getHarvestLevel(new ItemStack(RouterReborn.itemPickaxe), ((itemToolPickaxe)RouterReborn.itemPickaxe).toolClass) && block.func_149712_f(player.field_70170_p, x, y, z) >= 0.0f) {
                ItemStack itemstack = player.func_71045_bC();
                itemToolPickaxe item = (itemToolPickaxe)itemstack.func_77973_b();
                if (itemstack.func_77960_j() < item.material.func_77997_a() && player.func_82247_a(x, y, z, side, itemstack)) {
                    block.func_149636_a(player.field_70170_p, player, x, y, z, player.field_70170_p.func_72805_g(x, y, z));
                    block.func_149657_c(player.field_70170_p, x, y, z, block.getExpDrop((IBlockAccess)player.field_70170_p, 0, 0));
                    item.func_150894_a(itemstack, player.field_70170_p, player.field_70170_p.func_147439_a(x, y, z), x, y, z, (EntityLivingBase)player);
                    player.field_70170_p.func_147468_f(x, y, z);
                    player.field_70170_p.func_147471_g(x, y, z);
                }
            }
        }
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.material.func_77997_a() - stack.func_77960_j() == 1) {
            // empty if block
        }
        if (this.material.func_77997_a() - stack.func_77960_j() < 1) {
            return -1.0f;
        }
        if (this.func_150897_b(block)) {
            if (block.getHarvestTool(3) == "shovel") {
                return 7.5f;
            }
            if (block.getHarvestTool(3) == "pickaxe") {
                return 8.0f;
            }
            if (block.getHarvestTool(3) == "axe") {
                return 8.0f;
            }
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public float func_150893_a(ItemStack p_150893_1_, Block p_150893_2_) {
        return this.efficiencyOnProperMaterial;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        p_77644_1_.func_77972_a(2, p_77644_3_);
        return true;
    }

    public Item.ToolMaterial func_150913_i() {
        return this.material;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String func_77861_e() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return this.material.func_150995_f() == p_82789_2_.func_77973_b() ? true : super.func_82789_a(p_82789_1_, p_82789_2_);
    }

    public boolean func_77645_m() {
        return true;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damageVsEntity, 0));
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 0.04, 0));
        return multimap;
    }

    public boolean placeTorch(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        int i1;
        Block block = p_77648_3_.func_147439_a(p_77648_4_, p_77648_5_, p_77648_6_);
        if (block == Blocks.field_150431_aC && (p_77648_3_.func_72805_g(p_77648_4_, p_77648_5_, p_77648_6_) & 7) < 1) {
            p_77648_7_ = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I) {
            if (p_77648_7_ == 0) {
                --p_77648_5_;
            }
            if (p_77648_7_ == 1) {
                ++p_77648_5_;
            }
            if (p_77648_7_ == 2) {
                --p_77648_6_;
            }
            if (p_77648_7_ == 3) {
                ++p_77648_6_;
            }
            if (p_77648_7_ == 4) {
                --p_77648_4_;
            }
            if (p_77648_7_ == 5) {
                ++p_77648_4_;
            }
        }
        if (!p_77648_2_.func_82247_a(p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_1_)) {
            return false;
        }
        if (p_77648_1_.field_77994_a == 0) {
            return false;
        }
        Block torch = Block.func_149634_a((Item)p_77648_1_.func_77973_b());
        if (p_77648_3_.func_147472_a(torch, p_77648_4_, p_77648_5_, p_77648_6_, false, p_77648_7_, (Entity)null, p_77648_1_) && p_77648_3_.func_147465_d(p_77648_4_, p_77648_5_, p_77648_6_, torch, i1 = torch.func_149660_a(p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_8_, p_77648_9_, p_77648_10_, 0), 3)) {
            if (p_77648_3_.func_147439_a(p_77648_4_, p_77648_5_, p_77648_6_) == torch) {
                torch.func_149689_a(p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_, (EntityLivingBase)p_77648_2_, p_77648_1_);
                torch.func_149714_e(p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_, i1);
            }
            p_77648_3_.func_72908_a((double)((float)p_77648_4_ + 0.5f), (double)((float)p_77648_5_ + 0.5f), (double)((float)p_77648_6_ + 0.5f), torch.field_149762_H.func_150496_b(), (torch.field_149762_H.func_150497_c() + 1.0f) / 2.0f, torch.field_149762_H.func_150494_d() * 0.8f);
        }
        return true;
    }
}

