/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.block;

import cofh.api.item.IToolHammer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import router.reborn.BarrelType;
import router.reborn.RouterReborn;
import router.reborn.network.NetworkHandler;
import router.reborn.tileentity.TileEntityBarrel;
import router.reborn.util.util;

public class BlockBarrel
extends BlockContainer {
    IIcon[] icon = new IIcon[2];
    private final Random rand = new Random();

    public BlockBarrel(Material p_i45394_1_) {
        super(p_i45394_1_);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityBarrel();
    }

    public void func_149651_a(IIconRegister register) {
        int x = 1;
        for (BarrelType barrel : RouterReborn.getBarrels()) {
            IIcon[] textures = new IIcon[]{register.func_94245_a("RouterReborn:T" + x + "Top"), register.func_94245_a("RouterReborn:T" + x + "Side")};
            barrel.setTextures(textures);
            ++x;
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (RouterReborn.getBarrels().length <= meta) {
            return null;
        }
        return RouterReborn.getBarrels()[meta].getTextures()[side > 1 ? 1 : 0];
    }

    public String getName() {
        return "barrel";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (BarrelType barrel : RouterReborn.getBarrels()) {
            if (barrel == null) continue;
            list.add(barrel.getStack());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player2, int side, float hitX, float hitY, float hitZ) {
        TileEntityBarrel barrel = this.getTileEntity(world, x, y, z);
        if (!player2.func_70093_af()) {
            if (world.field_72995_K) {
                return true;
            }
            if (!(player2 instanceof EntityPlayerMP)) {
                return true;
            }
            EntityPlayerMP player = (EntityPlayerMP)player2;
            if (barrel == null) {
                return true;
            }
            boolean res = true;
            ItemStack playerItem = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
            if (playerItem == null) {
                if (barrel.timerClick <= 0) return true;
                res = this.insertItemToBarrel(barrel, barrel.getRawItem(), (EntityPlayer)player, true);
            } else {
                res = this.insertItemToBarrel(barrel, playerItem, (EntityPlayer)player, barrel.timerClick > 0);
            }
            if (res) {
                if (barrel.timerClick == 0) {
                    barrel.timerClick = 10;
                }
                NetworkHandler.UpdateClients(barrel, x, y, z, world);
                return true;
            }
        }
        if (!player2.func_70093_af()) return true;
        if (player2.field_71071_by.func_70448_g() == null) {
            if (world.field_72995_K) {
                return true;
            }
            if (!(player2 instanceof EntityPlayerMP)) {
                return true;
            }
            barrel.isLocked = !barrel.isLocked;
            NetworkHandler.UpdateClients(barrel, x, y, z, world);
            return true;
        }
        if (this.CreateItemBlock(world, x, y, z, player2, side, hitX, hitY, hitZ, false)) return true;
        return super.func_149727_a(world, x, y, z, player2, side, hitX, hitY, hitZ);
    }

    private boolean CreateItemBlock(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ, boolean broken) {
        if (player.func_70093_af() && !world.field_72995_K || broken) {
            ItemStack stk = player.func_71045_bC();
            if (broken || stk != null) {
                TileEntity tile;
                Item it = null;
                if (stk != null) {
                    it = stk.func_77973_b();
                }
                if ((broken || it instanceof IToolHammer) && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityBarrel) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    ((TileEntityBarrel)tile).writeToNBTItem(nbt);
                    ItemStack stack = new ItemStack(RouterReborn.barrel, 1, world.func_72805_g(x, y, z));
                    int id = BlockBarrel.func_149682_b((Block)this);
                    if (((TileEntityBarrel)tile).getRawItem() != null || ((TileEntityBarrel)tile).isLocked) {
                        nbt.func_74768_a("blockID", id);
                        stack.func_77982_d(nbt);
                    }
                    EntityItem ent = new EntityItem(world, (double)x, (double)y, (double)z, stack.func_77946_l());
                    world.func_72838_d((Entity)ent);
                    ((TileEntityBarrel)tile).setRawItem(null);
                    RouterReborn.eventServer.BlockBreak(new BlockEvent.BreakEvent(x, y, z, world, (Block)this, stack.func_77960_j(), player));
                    world.func_147468_f(x, y, z);
                    world.func_147475_p(x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    private void SendSlotUpdate(EntityPlayerMP player, int slot, ItemStack item) {
        int s = slot;
        if (s < 9) {
            s += 36;
        }
        player.field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(player.field_71069_bz.field_75152_c, s, item == null ? null : (item.field_77994_a == 0 ? null : item)));
    }

    private void insertAll(TileEntityBarrel barrel, ItemStack stack, EntityPlayer player) {
        ItemStack main = stack.func_77946_l();
        main.field_77994_a = 1;
        for (int i = 0; i < 36; ++i) {
            ItemStack itm = player.field_71071_by.field_70462_a[i];
            if (itm == null) continue;
            ItemStack tmp = itm.func_77946_l();
            tmp.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)tmp, (ItemStack)main)) continue;
            int oldCount = barrel.getTotalItemCount();
            ItemStack in = itm.func_77946_l();
            int max = barrel.func_70297_j_();
            if (in.field_77994_a > max) {
                in.field_77994_a = max;
            }
            barrel.func_70299_a(0, in.func_77946_l());
            ItemStack plIt = player.field_71071_by.func_70298_a(i, barrel.getTotalItemCount() - oldCount);
            ItemStack ns = itm.func_77946_l();
            ns.field_77994_a -= plIt.field_77994_a;
            this.SendSlotUpdate((EntityPlayerMP)player, i, ns);
            if (barrel.func_70297_j_() != 0) continue;
            return;
        }
    }

    private boolean insertItemToBarrel(TileEntityBarrel barrel, ItemStack stack, EntityPlayer player, boolean isDoubleClick) {
        if (stack == null) {
            return false;
        }
        ItemStack item = barrel.getRawItem();
        if (item == null) {
            ItemStack in = stack.func_77946_l();
            int max = barrel.func_70297_j_();
            if (in.field_77994_a > max) {
                in.field_77994_a = max;
            }
            if (max > 0) {
                if (!barrel.isLocked) {
                    barrel.func_70299_a(0, in);
                } else {
                    barrel.setRawItem(in.func_77946_l());
                }
                ItemStack ns = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, in.field_77994_a);
                ns.field_77994_a = in.field_77994_a - ns.field_77994_a;
                this.SendSlotUpdate((EntityPlayerMP)player, player.field_71071_by.field_70461_c, ns.field_77994_a == 0 ? null : ns);
                if (isDoubleClick) {
                    this.insertAll(barrel, stack, player);
                }
            }
            return true;
        }
        ItemStack s1 = item.func_77946_l();
        s1.field_77994_a = 1;
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = 1;
        if (ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2) || util.CheckOreDict(s1, s2)) {
            int oldCount = barrel.getTotalItemCount();
            ItemStack in = stack.func_77946_l();
            int max = barrel.func_70297_j_();
            if (in.field_77994_a > max) {
                in.field_77994_a = max;
            }
            if (max > 0) {
                barrel.func_70299_a(0, in);
                ItemStack ns = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, barrel.getTotalItemCount() - oldCount);
                if (ns != null) {
                    ns.field_77994_a = in.field_77994_a - ns.field_77994_a;
                }
                this.SendSlotUpdate((EntityPlayerMP)player, player.field_71071_by.field_70461_c, ns == null ? null : (ns.field_77994_a == 0 ? null : ns));
                if (isDoubleClick) {
                    this.insertAll(barrel, stack, player);
                }
            }
            return true;
        }
        return false;
    }

    public int TryPutInHand(TileEntityBarrel barrel, World world, boolean isSneaking, EntityPlayerMP player) {
        boolean iRet = false;
        ItemStack itemHeld = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (barrel.getRawItem() == null) {
            return 0;
        }
        ItemStack itemBarrel = barrel.getRawItem().func_77946_l();
        itemBarrel.field_77994_a = 1;
        ItemStack itemOut = barrel.func_70301_a(1);
        if (itemOut == null || itemOut.field_77994_a == 0) {
            return 0;
        }
        if (itemHeld != null) {
            ItemStack compPlayerItem = itemHeld.func_77946_l();
            compPlayerItem.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)itemBarrel, (ItemStack)compPlayerItem)) {
                return 0;
            }
            int maxPlayer = Math.min(itemHeld.func_77976_d() - itemHeld.field_77994_a, itemOut.field_77994_a);
            if (isSneaking && maxPlayer > 1) {
                maxPlayer = 1;
            }
            barrel.func_70298_a(1, maxPlayer);
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a += maxPlayer;
            this.SendSlotUpdate(player, player.field_71071_by.field_70461_c, player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c]);
            return maxPlayer;
        }
        int outAmount = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
        ItemStack transfer = itemOut.func_77946_l();
        transfer.field_77994_a = outAmount;
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = transfer.func_77946_l();
        if (isSneaking) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a = 1;
        }
        barrel.func_70298_a(1, isSneaking ? 1 : outAmount);
        this.SendSlotUpdate(player, player.field_71071_by.field_70461_c, player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c]);
        barrel.delayClick = 1;
        barrel.lastclick = world.func_82737_E();
        return isSneaking ? 1 : outAmount;
    }

    public int TryPutInInventory(TileEntityBarrel barrel, World world, boolean isSneaking, EntityPlayerMP player) {
        if (barrel.getRawItem() == null) {
            return 0;
        }
        ItemStack itemBarrel = barrel.getRawItem().func_77946_l();
        itemBarrel.field_77994_a = 1;
        ItemStack itemOut = barrel.func_70301_a(1);
        if (itemOut == null || itemOut.field_77994_a == 0) {
            return 0;
        }
        int iTransfered = 0;
        int outAmount = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack currentItem = player.field_71071_by.field_70462_a[i];
            if (currentItem != null) {
                ItemStack compPlayerItem = currentItem.func_77946_l();
                compPlayerItem.field_77994_a = 1;
                if (ItemStack.func_77989_b((ItemStack)itemBarrel, (ItemStack)compPlayerItem)) {
                    int maxPlayer = Math.min(currentItem.func_77976_d() - currentItem.field_77994_a, itemOut.field_77994_a);
                    if (isSneaking && maxPlayer > 1) {
                        maxPlayer = 1;
                    }
                    barrel.func_70298_a(1, maxPlayer);
                    player.field_71071_by.field_70462_a[i].field_77994_a += maxPlayer;
                    this.SendSlotUpdate(player, i, player.field_71071_by.field_70462_a[i]);
                    iTransfered += maxPlayer;
                }
            } else {
                ItemStack transfer = itemOut.func_77946_l();
                transfer.field_77994_a = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
                player.field_71071_by.field_70462_a[i] = transfer.func_77946_l();
                if (isSneaking) {
                    player.field_71071_by.field_70462_a[i].field_77994_a = 1;
                }
                this.SendSlotUpdate(player, i, player.field_71071_by.field_70462_a[i]);
                barrel.func_70298_a(1, isSneaking ? 1 : outAmount);
                iTransfered += isSneaking ? 1 : outAmount;
            }
            if (iTransfered >= outAmount) {
                return iTransfered;
            }
            if (!isSneaking || iTransfered < 1) continue;
            return iTransfered;
        }
        return iTransfered;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player2) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityBarrel barrel = this.getTileEntity(world, x, y, z);
        if (barrel != null && barrel.getRawItem() != null) {
            int result;
            int itemToTransfer;
            if (barrel.lastclick + 2L < world.func_82737_E()) {
                barrel.delayClick = 0;
            }
            if (barrel.delayClick > 0) {
                barrel.delayClick = 0;
                return;
            }
            ItemStack itemOut = barrel.func_70301_a(1);
            if (itemOut == null) {
                return;
            }
            int n = itemToTransfer = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
            if (player2.func_70093_af() && itemToTransfer > 1) {
                itemToTransfer = 1;
            }
            if ((itemToTransfer -= (result = this.TryPutInHand(barrel, world, player2.func_70093_af(), (EntityPlayerMP)player2))) > 0) {
                result = this.TryPutInInventory(barrel, world, player2.func_70093_af(), (EntityPlayerMP)player2);
            }
            if (!world.field_72995_K) {
                NetworkHandler.UpdateClients(barrel, x, y, z, world);
            }
            return;
        }
        super.func_149699_a(world, x, y, z, player2);
    }

    public void func_149681_a(World world, int x, int y, int z, int side, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntity entity = world.func_147438_o(x, y, z);
            if (entity == null || !(entity instanceof TileEntityBarrel)) {
                return;
            }
            TileEntityBarrel tile = (TileEntityBarrel)entity;
            if (tile.getTotalItemCount() > 0 || tile.isLocked) {
                if (!this.CreateItemBlock(world, x, y, z, player, side, 0.0f, 0.0f, 0.0f, true)) {
                    super.func_149681_a(world, x, y, z, side, player);
                }
            } else {
                super.func_149681_a(world, x, y, z, side, player);
            }
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        super.func_149664_b(world, x, y, z, meta);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity == null || !(entity instanceof TileEntityBarrel)) {
            return;
        }
        TileEntityBarrel tile = (TileEntityBarrel)entity;
        if (!world.field_72995_K) {
            world.func_147475_p(x, y, z);
        }
    }

    private void dropitem(World par1World, int x, int y, int z, ItemStack item) {
        float f = this.rand.nextFloat() * 0.8f + 0.1f;
        float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
        float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
        if (item != null) {
            EntityItem entityitem = new EntityItem(par1World, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), item.func_77946_l());
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
            entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
            par1World.func_72838_d((Entity)entityitem);
        }
    }

    private TileEntityBarrel getTileEntity(World world, int x, int y, int z) {
        TileEntity barrel = world.func_147438_o(x, y, z);
        if (barrel instanceof TileEntityBarrel) {
            return (TileEntityBarrel)barrel;
        }
        return null;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return super.func_149650_a(p_149650_1_, p_149650_2_, p_149650_3_);
    }
}

