/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.api.helpers;

import com.google.common.primitives.Ints;

public class Index
extends Number
implements Comparable<Index> {
    private static final long serialVersionUID = 1L;
    public int offset;
    public final int value;

    public Index(int value, int offset) {
        this.value = value - offset;
        this.offset = offset;
    }

    public Integer box() {
        return this.value;
    }

    public int unbox() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value + this.offset;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public boolean equals(Object obj) {
        return obj instanceof Index && this.value == ((Index)obj).value;
    }

    @Override
    public int compareTo(Index other) {
        return Ints.compare((int)this.value, (int)other.value);
    }

    public int hashCode() {
        return Ints.hashCode((int)this.value);
    }

    public String toString() {
        return Integer.toString(this.value + this.offset);
    }

    public void checkElementIndex(String name, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size: " + size);
        }
        if (this.value < 0) {
            throw new IndexOutOfBoundsException(String.format("%s (%d) must be at least %d", name, this.value + this.offset, this.offset));
        }
        if (this.value >= size) {
            throw new IndexOutOfBoundsException(String.format("%s (%d) must be less than %d", name, this.value + this.offset, size + this.offset));
        }
    }

    public void checkElementIndex(int size) {
        this.checkElementIndex("index", size);
    }
}

