/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;
import openperipheral.api.adapter.IPeripheralTypeProvider;
import openperipheral.api.peripheral.PeripheralTypeId;
import openperipheral.util.NameUtils;
import org.apache.commons.lang3.StringUtils;

public class PeripheralTypeProvider
implements IPeripheralTypeProvider {
    private static final String DEFAULTS_FILE = "/default_names.txt";
    private final Splitter lineSplitter = Splitter.onPattern((String)"\\s+");
    public static final PeripheralTypeProvider INSTANCE = new PeripheralTypeProvider();
    private final Map<String, String> names = Maps.newTreeMap();
    private File file;

    public void initialize(File configDir) {
        this.readDefaultNames();
        this.file = new File(configDir, "peripheral_names.txt");
        if (this.file.exists()) {
            this.readOverlayNames();
        }
        this.writeOverlayFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOverlayNames() {
        String absolutePath = this.file.getAbsolutePath();
        try {
            FileInputStream stream = new FileInputStream(this.file);
            try {
                this.parseNames(absolutePath, stream);
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + absolutePath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDefaultNames() {
        try {
            InputStream stream = this.getClass().getResourceAsStream(DEFAULTS_FILE);
            try {
                this.parseNames(DEFAULTS_FILE, stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse default names", e);
        }
    }

    private void parseNames(String fileName, InputStream stream) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            List fields = this.lineSplitter.splitToList((CharSequence)line);
            if (fields.size() != 2) {
                Log.warn((String)"Invalid format at %s:%s: '%s'", (Object[])new Object[]{fileName, reader.getLineNumber(), line});
                continue;
            }
            String clsName = (String)fields.get(0);
            String name = (String)fields.get(1);
            this.names.put(clsName, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOverlayFile() {
        if (this.file == null) {
            return;
        }
        try {
            Closer closer = Closer.create();
            try {
                OutputStream stream = (OutputStream)closer.register((Closeable)new FileOutputStream(this.file));
                PrintWriter writer = (PrintWriter)closer.register((Closeable)new PrintWriter(stream));
                this.writeNames(writer);
            }
            finally {
                closer.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write names to " + this.file.getAbsolutePath(), e);
        }
    }

    private void writeNames(PrintWriter stream) {
        stream.write("#OpenPeripheral user-friendly names\n");
        stream.write("#class_name\tuser_name\n");
        for (Map.Entry<String, String> e : this.names.entrySet()) {
            stream.write(e.getKey());
            stream.write(9);
            stream.write(e.getValue());
            stream.write(10);
        }
    }

    @Override
    public void setType(Class<?> cls, String type) {
        this.setType(cls.getName(), type);
    }

    public void setType(String key, String type) {
        this.names.put(key, type);
        this.writeOverlayFile();
    }

    @Override
    public String getType(Class<?> cls) {
        return this.names.get(cls.getName());
    }

    @Override
    public String generateType(Object obj) {
        if (obj == null) {
            return "invalid";
        }
        Class<?> cls = obj.getClass();
        String clsName = cls.getName();
        String name = this.names.get(clsName);
        if (name == null) {
            name = PeripheralTypeProvider.create(cls, obj);
            this.names.put(clsName, name);
            this.writeOverlayFile();
        }
        return name;
    }

    private static String create(Class<?> cls, Object target) {
        String name = PeripheralTypeProvider.tryGetName(cls, target);
        return Strings.isNullOrEmpty((String)name) ? "peripheral" : name.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase(Locale.ENGLISH);
    }

    private static String tryGetName(Class<?> cls, Object target) {
        block16: {
            PeripheralTypeId customId = cls.getAnnotation(PeripheralTypeId.class);
            if (customId != null) {
                return customId.value();
            }
            if (target instanceof IInventory) {
                try {
                    return ((IInventory)target).func_145825_b();
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Can't get inventory name for %s", (Object[])new Object[]{cls});
                }
            }
            if (target instanceof TileEntity) {
                TileEntity te = (TileEntity)target;
                try {
                    String mapping = NameUtils.getClassToNameMap().get(cls);
                    if (!Strings.isNullOrEmpty((String)mapping)) {
                        return mapping;
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Failed to map class %s to name", (Object[])new Object[]{cls});
                }
                try {
                    String name;
                    Block block = te.func_145838_q();
                    if (block == null) break block16;
                    int dmg = te.func_145832_p();
                    ItemStack is = new ItemStack(block, 1, dmg);
                    try {
                        name = is.func_82833_r();
                        if (!Strings.isNullOrEmpty((String)name)) {
                            return name;
                        }
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Can't get display name for %s", (Object[])new Object[]{cls});
                    }
                    try {
                        name = StringUtils.removeStart((String)block.func_149739_a(), (String)"tile.");
                        if (!Strings.isNullOrEmpty((String)name)) {
                            return name;
                        }
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Can't get unlocalized name for %s", (Object[])new Object[]{cls});
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Exception while getting name from item for %s", (Object[])new Object[]{cls});
                }
            }
        }
        return cls.getSimpleName();
    }
}

