/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gas;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.config.Config;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public final class GasUtil {
    private static boolean useCheckPerformed = false;
    private static boolean isGasConduitEnabled = false;
    public static final String API_NAME = "MekanismAPI|gas";

    public static boolean isGasConduitEnabled() {
        if (!useCheckPerformed) {
            isGasConduitEnabled = Config.isGasConduitEnabled ? ModAPIManager.INSTANCE.hasAPI(API_NAME) : false;
            useCheckPerformed = true;
        }
        return isGasConduitEnabled;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static IGasHandler getExternalGasHandler(IBlockAccess world, BlockCoord bc) {
        IGasHandler con = GasUtil.getGasHandler(world, bc);
        return con != null && !(con instanceof IConduitBundle) ? con : null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static IGasHandler getGasHandler(IBlockAccess world, BlockCoord bc) {
        return GasUtil.getGasHandler(world, bc.x, bc.y, bc.z);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static IGasHandler getGasHandler(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return GasUtil.getGasHandler(te);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static IGasHandler getGasHandler(TileEntity te) {
        if (te instanceof IGasHandler) {
            return (IGasHandler)te;
        }
        return null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean isGasValid(GasStack gas) {
        String name;
        return gas != null && (name = gas.getGas().getLocalizedName()) != null && !name.trim().isEmpty();
    }

    private GasUtil() {
    }
}

