/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.world.gen;

import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeFactory;
import com.jaquadro.minecraft.gardentrees.world.gen.WorldGenStandardOrnTree;
import java.util.HashMap;
import java.util.Map;

public class OrnamentalTreeRegistry {
    private static Map<String, OrnamentalTreeFactory> registry = new HashMap<String, OrnamentalTreeFactory>();

    public static void registerTree(String name, OrnamentalTreeFactory treeFactory) {
        registry.put(name, treeFactory);
    }

    public static OrnamentalTreeFactory getTree(String name) {
        return registry.get(name);
    }

    static {
        OrnamentalTreeRegistry.registerTree("small_oak", WorldGenStandardOrnTree.SmallOakTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_spruce", WorldGenStandardOrnTree.SmallSpruceTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_jungle", WorldGenStandardOrnTree.SmallJungleTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_acacia", WorldGenStandardOrnTree.SmallAcaciaTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_palm", WorldGenStandardOrnTree.SmallPalmTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_willow", WorldGenStandardOrnTree.SmallWillowTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_pine", WorldGenStandardOrnTree.SmallPineTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_mahogany", WorldGenStandardOrnTree.SmallMahoganyTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_shrub", WorldGenStandardOrnTree.SmallShrubTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_canopy", WorldGenStandardOrnTree.SmallCanopyTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_cyprus", WorldGenStandardOrnTree.SmallCyprusTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("tall_small_oak", WorldGenStandardOrnTree.TallSmallOakTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("large_oak", WorldGenStandardOrnTree.LargeOakTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("large_spruce", WorldGenStandardOrnTree.LargeSpruceTree.FACTORY);
    }
}

