/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.core.recipe;

import com.jaquadro.minecraft.gardencore.api.WoodRegistry;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.block.tile.TileEntityWoodProxy;
import com.jaquadro.minecraft.gardentrees.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class WoodPostRecipe
implements IRecipe {
    public static final List<Item> axeList = new ArrayList<Item>();
    private UniqueMetaIdentifier woodType;

    public WoodPostRecipe(UniqueMetaIdentifier uid) {
        this.woodType = uid;
    }

    public boolean func_77569_a(InventoryCrafting inventory, World world) {
        return this.func_77572_b(inventory) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        int size = this.getGridSize(inventory);
        for (int row = 0; row < size - 1; ++row) {
            for (int col = 0; col < size; ++col) {
                ItemStack wood;
                ItemStack axe = inventory.func_70463_b(col, row);
                if (!this.isValidAxe(axe) || (wood = inventory.func_70463_b(col, row + 1)) == null) continue;
                Block woodBlock = Block.func_149634_a((Item)wood.func_77973_b());
                int woodMeta = wood.func_77960_j();
                if (!WoodRegistry.instance().contains(woodBlock, woodMeta) || woodBlock != this.woodType.getBlock() || woodMeta != this.woodType.meta) continue;
                return new ItemStack((Block)ModBlocks.thinLog, 4, TileEntityWoodProxy.composeMetadata(woodBlock, woodMeta));
            }
        }
        return null;
    }

    public int func_77570_a() {
        return 4;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)ModBlocks.thinLog, 4, TileEntityWoodProxy.composeMetadata(this.woodType.getBlock(), this.woodType.meta));
    }

    private int getGridSize(InventoryCrafting inventory) {
        return (int)Math.sqrt(inventory.func_70302_i_());
    }

    private boolean isValidAxe(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        int n = axeList.size();
        for (int i = 0; i < n; ++i) {
            if (item != axeList.get(i)) continue;
            return true;
        }
        return false;
    }

    static {
        axeList.add(Items.field_151053_p);
        axeList.add(Items.field_151049_t);
        axeList.add(Items.field_151036_c);
        axeList.add(Items.field_151006_E);
        axeList.add(Items.field_151056_x);
    }
}

