/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.block;

import com.jaquadro.minecraft.gardentrees.core.ClientProxy;
import com.jaquadro.minecraft.gardentrees.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockIvy
extends Block
implements IShearable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;

    public BlockIvy(String name) {
        super(Material.field_151582_l);
        this.func_149663_c(name);
        this.func_149675_a(true);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a(ModCreativeTabs.tabGardenTrees);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int func_149645_b() {
        return ClientProxy.ivyRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        float unit = 0.0625f;
        int meta = blockAccess.func_72805_g(x, y, z);
        float xMin = 1.0f;
        float yMin = 1.0f;
        float zMin = 1.0f;
        float xMax = 0.0f;
        float yMax = 0.0f;
        float zMax = 0.0f;
        if ((meta & 2) != 0) {
            xMin = 0.0f;
            yMin = 0.0f;
            zMin = 0.0f;
            xMax = Math.max(xMax, unit);
            yMax = 1.0f;
            zMax = 1.0f;
        }
        if ((meta & 8) != 0) {
            xMin = Math.min(xMin, 1.0f - unit);
            yMin = 0.0f;
            zMin = 0.0f;
            xMax = 1.0f;
            yMax = 1.0f;
            zMax = 1.0f;
        }
        if ((meta & 4) != 0) {
            xMin = 0.0f;
            yMin = 0.0f;
            zMin = 0.0f;
            xMax = 1.0f;
            yMax = 1.0f;
            zMax = Math.max(zMax, unit);
        }
        if ((meta & 1) != 0) {
            xMin = 0.0f;
            yMin = 0.0f;
            zMin = Math.min(zMin, 1.0f - unit);
            xMax = 1.0f;
            yMax = 1.0f;
            zMax = 1.0f;
        }
        this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        int opSide = side - side % 2;
        switch (side) {
            case 2: {
                return this.canPlaceOnBlock(world, x, y, z + 1, opSide);
            }
            case 3: {
                return this.canPlaceOnBlock(world, x, y, z - 1, opSide);
            }
            case 4: {
                return this.canPlaceOnBlock(world, x + 1, y, z, opSide);
            }
            case 5: {
                return this.canPlaceOnBlock(world, x - 1, y, z, opSide);
            }
        }
        return false;
    }

    private boolean canPlaceOnBlock(World world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        return block.func_149688_o().func_76230_c() && block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.getOrientation((int)side));
    }

    public int func_149635_D() {
        return ColorizerFoliage.func_77468_c();
    }

    public int func_149741_i(int meta) {
        return ColorizerFoliage.func_77468_c();
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        return blockAccess.func_72807_a(x, z).func_150571_c(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K && !this.isBlockStateValid(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.field_73012_v.nextInt(2) == 0) {
            int limit = 9;
            block0: for (int dx = x - 4; dx <= x + 4; ++dx) {
                for (int dz = z - 4; dz <= z + 4; ++dz) {
                    for (int dy = y - 1; dy <= y + 1; ++dy) {
                        if (world.func_147439_a(dx, dy, dz) == this && --limit <= 0) break block0;
                    }
                }
            }
            int meta = world.func_72805_g(x, y, z);
            int dir = world.field_73012_v.nextInt(6);
            int facingDir = Direction.field_71579_d[dir];
            if (dir == 1 && y < 255 && world.func_147437_c(x, y + 1, z)) {
                if (limit <= 0) {
                    return;
                }
                int chance = world.field_73012_v.nextInt(16) & meta;
                if (chance > 0) {
                    for (int i = 0; i <= 3; ++i) {
                        int opSide = Direction.field_71582_c[Direction.field_71580_e[i]];
                        if (this.canPlaceOnBlock(world, x + Direction.field_71583_a[i], y + 1, z + Direction.field_71581_b[i], opSide)) continue;
                        chance &= ~(1 << i);
                    }
                    if (chance > 0) {
                        world.func_147465_d(x, y + 1, z, (Block)this, chance, 2);
                    }
                }
            } else if (dir >= 2 && dir <= 5 && (meta & 1 << facingDir) == 0) {
                if (limit <= 4) {
                    return;
                }
                Block block = world.func_147439_a(x + Direction.field_71583_a[facingDir], y, z + Direction.field_71581_b[facingDir]);
                int opSide = Direction.field_71582_c[Direction.field_71580_e[facingDir]];
                if (block.func_149688_o() == Material.field_151579_a) {
                    int dirRight = Direction.field_71577_f[facingDir];
                    int dirLeft = Direction.field_71578_g[facingDir];
                    int opSideRight = Direction.field_71582_c[Direction.field_71580_e[dirRight]];
                    int opSideLeft = Direction.field_71582_c[Direction.field_71580_e[dirLeft]];
                    if ((meta & 1 << dirRight) != 0 && this.canPlaceOnBlock(world, x + Direction.field_71583_a[facingDir] + Direction.field_71583_a[dirRight], y, z + Direction.field_71581_b[facingDir] + Direction.field_71581_b[dirRight], opSideRight)) {
                        world.func_147465_d(x + Direction.field_71583_a[facingDir], y, z + Direction.field_71581_b[facingDir], (Block)this, 1 << dirRight, 2);
                    } else if ((meta & 1 << dirLeft) != 0 && this.canPlaceOnBlock(world, x + Direction.field_71583_a[facingDir] + Direction.field_71583_a[dirLeft], y, z + Direction.field_71581_b[facingDir] + Direction.field_71581_b[dirLeft], opSideLeft)) {
                        world.func_147465_d(x + Direction.field_71583_a[facingDir], y, z + Direction.field_71581_b[facingDir], (Block)this, 1 << dirLeft, 2);
                    } else if ((meta & 1 << dirRight) != 0 && world.func_147437_c(x + Direction.field_71583_a[facingDir] + Direction.field_71583_a[dirRight], y, z + Direction.field_71581_b[facingDir] + Direction.field_71581_b[dirRight]) && this.canPlaceOnBlock(world, x + Direction.field_71583_a[dirRight], y, z + Direction.field_71581_b[dirRight], opSide)) {
                        world.func_147465_d(x + Direction.field_71583_a[facingDir] + Direction.field_71583_a[dirRight], y, z + Direction.field_71581_b[facingDir] + Direction.field_71581_b[dirRight], (Block)this, 1 << (facingDir + 2 & 3), 2);
                    } else if ((meta & 1 << dirLeft) != 0 && world.func_147437_c(x + Direction.field_71583_a[facingDir] + Direction.field_71583_a[dirLeft], y, z + Direction.field_71581_b[facingDir] + Direction.field_71581_b[dirLeft]) && this.canPlaceOnBlock(world, x + Direction.field_71583_a[dirLeft], y, z + Direction.field_71581_b[dirLeft], opSide)) {
                        world.func_147465_d(x + Direction.field_71583_a[facingDir] + Direction.field_71583_a[dirLeft], y, z + Direction.field_71581_b[facingDir] + Direction.field_71581_b[dirLeft], (Block)this, 1 << (facingDir + 2 & 3), 2);
                    }
                } else if (this.canPlaceOnBlock(world, x + Direction.field_71583_a[facingDir], y, z + Direction.field_71581_b[facingDir], opSide)) {
                    world.func_72921_c(x, y, z, meta | 1 << facingDir, 2);
                }
            }
        }
    }

    private boolean isBlockStateValid(World world, int x, int y, int z) {
        int meta;
        int mask = meta = world.func_72805_g(x, y, z);
        if (meta > 0) {
            for (int i = 0; i <= 3; ++i) {
                int bit = 1 << i;
                int opSide = Direction.field_71582_c[Direction.field_71580_e[i]];
                if ((meta & bit) == 0 || this.canPlaceOnBlock(world, x + Direction.field_71583_a[i], y, z + Direction.field_71581_b[i], opSide) || world.func_147439_a(x, y + 1, z) == this && (world.func_72805_g(x, y + 1, z) & bit) != 0) continue;
                mask &= ~bit;
            }
        }
        if (mask == 0) {
            return false;
        }
        if (mask != meta) {
            world.func_72921_c(x, y, z, mask, 2);
        }
        return true;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int bit = 0;
        switch (side) {
            case 2: {
                bit = 1;
                break;
            }
            case 3: {
                bit = 4;
                break;
            }
            case 4: {
                bit = 8;
                break;
            }
            case 5: {
                bit = 2;
            }
        }
        return bit != 0 ? bit : meta;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1));
        return ret;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.textures[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFull() {
        return this.textures[7];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        boolean nTop = blockAccess.func_147439_a(x, y + 1, z) == this;
        boolean nLeft = false;
        boolean nRight = false;
        int meta = blockAccess.func_72805_g(x, y, z);
        switch (side) {
            case 2: {
                nLeft = (meta & 8) != 0 || blockAccess.func_147439_a(x + 1, y, z) == this && (blockAccess.func_72805_g(x + 1, y, z) & 1) != 0 || blockAccess.func_147439_a(x + 1, y, z + 1) == this && (blockAccess.func_72805_g(x + 1, y, z + 1) & 2) != 0;
                nRight = (meta & 2) != 0 || blockAccess.func_147439_a(x - 1, y, z) == this && (blockAccess.func_72805_g(x - 1, y, z) & 1) != 0 || blockAccess.func_147439_a(x - 1, y, z + 1) == this && (blockAccess.func_72805_g(x - 1, y, z + 1) & 8) != 0;
                break;
            }
            case 3: {
                nLeft = (meta & 2) != 0 || blockAccess.func_147439_a(x - 1, y, z) == this && (blockAccess.func_72805_g(x - 1, y, z) & 4) != 0 || blockAccess.func_147439_a(x - 1, y, z - 1) == this && (blockAccess.func_72805_g(x - 1, y, z - 1) & 8) != 0;
                nRight = (meta & 8) != 0 || blockAccess.func_147439_a(x + 1, y, z) == this && (blockAccess.func_72805_g(x + 1, y, z) & 4) != 0 || blockAccess.func_147439_a(x + 1, y, z - 1) == this && (blockAccess.func_72805_g(x + 1, y, z - 1) & 2) != 0;
                break;
            }
            case 4: {
                nLeft = (meta & 4) != 0 || blockAccess.func_147439_a(x, y, z - 1) == this && (blockAccess.func_72805_g(x, y, z - 1) & 8) != 0 || blockAccess.func_147439_a(x + 1, y, z - 1) == this && (blockAccess.func_72805_g(x + 1, y, z - 1) & 1) != 0;
                nRight = (meta & 1) != 0 || blockAccess.func_147439_a(x, y, z + 1) == this && (blockAccess.func_72805_g(x, y, z + 1) & 8) != 0 || blockAccess.func_147439_a(x + 1, y, z + 1) == this && (blockAccess.func_72805_g(x + 1, y, z + 1) & 4) != 0;
                break;
            }
            case 5: {
                nLeft = (meta & 1) != 0 || blockAccess.func_147439_a(x, y, z + 1) == this && (blockAccess.func_72805_g(x, y, z + 1) & 2) != 0 || blockAccess.func_147439_a(x - 1, y, z + 1) == this && (blockAccess.func_72805_g(x - 1, y, z + 1) & 4) != 0;
                boolean bl = nRight = (meta & 4) != 0 || blockAccess.func_147439_a(x, y, z - 1) == this && (blockAccess.func_72805_g(x, y, z - 1) & 2) != 0 || blockAccess.func_147439_a(x - 1, y, z - 1) == this && (blockAccess.func_72805_g(x - 1, y, z - 1) & 1) != 0;
            }
        }
        if (nTop) {
            if (nLeft && nRight) {
                return this.textures[4];
            }
            if (nLeft) {
                return this.textures[3];
            }
            if (nRight) {
                return this.textures[2];
            }
            return this.textures[1];
        }
        if (nLeft && nRight) {
            return this.textures[7];
        }
        if (nLeft) {
            return this.textures[6];
        }
        if (nRight) {
            return this.textures[5];
        }
        return this.textures[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.textures = new IIcon[8];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = register.func_94245_a("GardenTrees:ivy" + i);
        }
    }
}

