/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer.item;

import com.jaquadro.minecraft.gardenapi.api.component.ILanternSource;
import com.jaquadro.minecraft.gardenapi.internal.Api;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import com.jaquadro.minecraft.gardenstuff.block.BlockLantern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LanternItemRenderer
implements IItemRenderer {
    private RenderHelper renderHelper = new RenderHelper();
    private float[] colorScratch = new float[3];

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderer = this.getRenderer(data);
        if (renderer == null) {
            return;
        }
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (!(block instanceof BlockLantern)) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderLantern((BlockLantern)block, item, renderer, type);
    }

    private void renderLantern(BlockLantern block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType renderType) {
        GL11.glEnable((int)3008);
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
        }
        block.func_149683_g();
        this.renderHelper.setRenderBounds((Block)block);
        this.renderHelper.renderBlock(null, (Block)block, item.func_77960_j());
        if (renderType != IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderHelper.state.renderFromInside = true;
            this.renderHelper.state.renderMinY = 0.005f;
            this.renderHelper.renderBlock(null, (Block)block, item.func_77960_j());
            this.renderHelper.state.renderFromInside = false;
        } else {
            this.renderHelper.state.renderMaxY = 0.005f;
            this.renderHelper.renderFace(1, null, (Block)block, block.func_149691_a(0, item.func_77960_j()), 0);
        }
        this.renderHelper.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderHelper.renderCrossedSquares((Block)block, item.func_77960_j(), block.getIconTopCross());
        ILanternSource lanternSource = Api.instance.registries().lanternSources().getLanternSource(block.getLightSource(item));
        if (lanternSource != null) {
            lanternSource.renderItem(renderer, renderType, block.getLightSourceMeta(item));
        }
        if (block.isGlass(item)) {
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)2977);
            RenderHelper.calculateBaseColor(this.colorScratch, block.func_149635_D());
            RenderHelper.setTessellatorColor(Tessellator.field_78398_a, this.colorScratch);
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            IIcon glass = block.getIconStainedGlass(item.func_77960_j());
            this.renderHelper.setRenderBounds((Block)block);
            this.renderHelper.state.renderMinX += 0.01;
            this.renderHelper.state.renderMinZ += 0.01;
            this.renderHelper.state.renderMaxX -= 0.01;
            this.renderHelper.state.renderMaxZ -= 0.01;
            this.renderHelper.state.renderMaxY -= 0.01;
            this.renderHelper.renderFace(4, null, (Block)block, glass, 0);
            this.renderHelper.renderFace(5, null, (Block)block, glass, 0);
            this.renderHelper.renderFace(2, null, (Block)block, glass, 0);
            this.renderHelper.renderFace(3, null, (Block)block, glass, 0);
            this.renderHelper.renderFace(1, null, (Block)block, glass, 0);
            GL11.glDisable((int)3042);
        }
    }

    private RenderBlocks getRenderer(Object[] data) {
        for (Object obj : data) {
            if (!(obj instanceof RenderBlocks)) continue;
            return (RenderBlocks)obj;
        }
        return null;
    }
}

