/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardenapi.api.connect.IChainSingleAttachable;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardenstuff.block.BlockLightChain;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class LightChainRenderer
implements ISimpleBlockRenderingHandler {
    private static final Vec3[] defaultAttachPoints = new Vec3[]{Vec3.func_72443_a((double)0.03125, (double)1.0, (double)0.03125), Vec3.func_72443_a((double)0.03125, (double)1.0, (double)0.96875), Vec3.func_72443_a((double)0.96875, (double)1.0, (double)0.03125), Vec3.func_72443_a((double)0.96875, (double)1.0, (double)0.96875)};
    private static final Vec3[] singleAttachPoint = new Vec3[]{Vec3.func_72443_a((double)0.5, (double)1.0, (double)0.5)};
    private static final Vec3 defaultSingleAttachPoint = Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.5);

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block instanceof BlockLightChain) {
            return this.renderWorldBlock(world, x, y, z, (BlockLightChain)block, modelId, renderer);
        }
        return false;
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockLightChain block, int modelId, RenderBlocks renderer) {
        IAttachable attachable;
        Vec3 topAttach;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        int color = block.func_149720_d(world, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78386_a(r, g, b);
        IIcon icon = block.func_149691_a(0, world.func_72805_g(x, y, z));
        if (renderer.func_147744_b()) {
            icon = renderer.field_147840_d;
        }
        int yMin = block.findMinY(world, x, y, z);
        int yMax = block.findMaxY(world, x, y, z);
        double upperDepth = 0.0;
        double lowerDepth = 0.0;
        Block blockTop = world.func_147439_a(x, yMax + 1, z);
        if (blockTop instanceof IChainSingleAttachable && (topAttach = ((IChainSingleAttachable)blockTop).getChainAttachPoint(world, x, yMax + 1, z, 0)) != null) {
            upperDepth = topAttach.field_72448_b;
        }
        if (upperDepth == 0.0 && (attachable = GardenAPI.instance().registries().attachable().getAttachable(blockTop, world.func_72805_g(x, y + 1, z))) != null && attachable.isAttachable(world, x, y + 1, z, 0)) {
            upperDepth = attachable.getAttachDepth(world, x, y + 1, z, 0);
        }
        for (Vec3 point : block.getAttachPoints(world, x, y, z)) {
            float height = (float)(yMax - yMin + 2) - (float)point.field_72448_b + (float)upperDepth;
            double cx = 0.5;
            double cz = 0.5;
            double dx = cx - point.field_72450_a;
            double dz = cz - point.field_72449_c;
            double yt = y + 1;
            double yb = y;
            double localYMin = (double)yMin + point.field_72448_b - 1.0;
            if (y == yMin) {
                yb = (double)(y - 1) + point.field_72448_b;
            }
            if (y == yMax) {
                yt = (double)(y + 1) + upperDepth;
            }
            double lerpB = 1.0 - (yb - localYMin) / (double)height;
            double lerpT = 1.0 - (yt - localYMin) / (double)height;
            this.drawBetween(renderer, icon, (double)x + dx * lerpB + cx, yb, (double)z + dz * lerpB + cz, (double)x + dx * lerpT + cx, yt, (double)z + dz * lerpT + cz);
        }
        com.jaquadro.minecraft.gardencore.core.ClientProxy.gardenProxyRenderer.renderWorldBlock(world, x, y, z, (Block)ModBlocks.gardenProxy, ModBlocks.gardenProxy.func_149645_b(), renderer);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.lightChainRenderID;
    }

    private void drawBetween(RenderBlocks renderer, IIcon icon, double x0, double y0, double z0, double x1, double y1, double z1) {
        Tessellator tessellator = Tessellator.field_78398_a;
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        Vec3 vT = Vec3.func_72443_a((double)(x1 - x0), (double)(y1 - y0), (double)(z1 - z0));
        Vec3 vB = Vec3.func_72443_a((double)(x1 - x0), (double)0.0, (double)(z1 - z0));
        Vec3 vN = vT.func_72431_c(vB);
        Vec3 vU = vT.func_72431_c(vN);
        vU = vU.func_72432_b();
        vN = vN.func_72432_b();
        double vUx = vU.field_72450_a / 2.0;
        double vUy = vU.field_72448_b / 2.0;
        double vUz = vU.field_72449_c / 2.0;
        if (vUx == 0.0 && vUy == 0.0) {
            vUx = -0.5;
            vUz = 0.5;
        }
        tessellator.func_78374_a(x0 + vUx, y0 + vUy, z0 + vUz, maxU, minV);
        tessellator.func_78374_a(x0 - vUx, y0 - vUy, z0 - vUz, minU, minV);
        tessellator.func_78374_a(x1 - vUx, y1 - vUy, z1 - vUz, minU, maxV);
        tessellator.func_78374_a(x1 + vUx, y1 + vUy, z1 + vUz, maxU, maxV);
        tessellator.func_78374_a(x1 + vUx, y1 + vUy, z1 + vUz, maxU, maxV);
        tessellator.func_78374_a(x1 - vUx, y1 - vUy, z1 - vUz, minU, maxV);
        tessellator.func_78374_a(x0 - vUx, y0 - vUy, z0 - vUz, minU, minV);
        tessellator.func_78374_a(x0 + vUx, y0 + vUy, z0 + vUz, maxU, minV);
        double vNx = vN.field_72450_a / 2.0;
        double vNy = vN.field_72448_b / 2.0;
        double vNz = vN.field_72449_c / 2.0;
        if (vNx == 0.0 && vNy == 0.0) {
            vNx = 0.5;
            vNz = 0.5;
        }
        tessellator.func_78374_a(x0 + vNx, y0 + vNy, z0 + vNz, maxU, minV);
        tessellator.func_78374_a(x0 - vNx, y0 - vNy, z0 - vNz, minU, minV);
        tessellator.func_78374_a(x1 - vNx, y1 - vNy, z1 - vNz, minU, maxV);
        tessellator.func_78374_a(x1 + vNx, y1 + vNy, z1 + vNz, maxU, maxV);
        tessellator.func_78374_a(x1 + vNx, y1 + vNy, z1 + vNz, maxU, maxV);
        tessellator.func_78374_a(x1 - vNx, y1 - vNy, z1 - vNz, minU, maxV);
        tessellator.func_78374_a(x0 - vNx, y0 - vNy, z0 - vNz, minU, minV);
        tessellator.func_78374_a(x0 + vNx, y0 + vNy, z0 + vNz, maxU, minV);
    }
}

