/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer;

import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardenstuff.block.BlockFence;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;

public class FenceRenderer
implements ISimpleBlockRenderingHandler {
    private static final float UN4 = -0.25f;
    private static final float U1 = 0.0615f;
    private static final float U7 = 0.4385f;
    private static final float U8 = 0.5f;
    private static final float U9 = 0.5615f;
    private static final float U15 = 0.9385f;
    private static final float U20 = 1.25f;
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockFence)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockFence)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockFence block, int modelId, RenderBlocks renderer) {
        boolean abYY;
        int meta = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxRenderer.setIcon(block.getIcon(meta));
        this.boxRenderer.flipOpposite = false;
        int connectFlags = block.calcConnectionFlags(world, x, y, z);
        boolean connectYNeg = (connectFlags & 1) != 0;
        boolean connectYPos = (connectFlags & 2) != 0;
        boolean connectZNeg = (connectFlags & 4) != 0;
        boolean connectZPos = (connectFlags & 8) != 0;
        boolean connectXNeg = (connectFlags & 0x10) != 0;
        boolean connectXPos = (connectFlags & 0x20) != 0;
        this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.4385f, 0.0, 0.4385f, 0.5615f, 1.0, 0.5615f);
        if (block.getPostInterval(meta) == 8) {
            if (connectZNeg) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.4385f, 0.0, 0.0, 0.5615f, 1.0, 0.0615f);
            }
            if (connectZPos) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.4385f, 0.0, 0.9385f, 0.5615f, 1.0, 1.0);
            }
            if (connectXNeg) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.0, 0.0, 0.4385f, 0.0615f, 1.0, 0.5615f);
            }
            if (connectXPos) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.9385f, 0.0, 0.4385f, 1.0, 1.0, 0.5615f);
            }
        }
        this.boxRenderer.flipOpposite = true;
        boolean fenceBelow = block.isFenceBelow(world, x, y, z);
        boolean abNN = connectYNeg && !fenceBelow && !connectYPos;
        boolean bl = abYY = connectYNeg && fenceBelow && connectYPos;
        if (abNN) {
            this.boxRenderer.setIcon(block.getIconTB(meta));
        }
        float yN = 0.0f;
        float yP = 1.0f;
        if (!abNN && !abYY) {
            if (connectYPos) {
                yN = 0.5f;
            } else if (connectYNeg) {
                yP = 0.5f;
            }
        }
        if (connectZNeg) {
            this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.5, yN, 0.0, 0.5, yP, 0.5);
        }
        if (connectZPos) {
            this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.5, yN, 0.5, 0.5, yP, 1.0);
        }
        if (connectXNeg) {
            this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.0, yN, 0.5, 0.5, yP, 0.5);
        }
        if (connectXPos) {
            this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.5, yN, 0.5, 1.0, yP, 0.5);
        }
        if (!abNN && !abYY) {
            if (connectYPos) {
                yN = 0.0f;
                yP = 0.5f;
            } else if (connectYNeg) {
                yN = 0.5f;
                yP = 1.0f;
            }
            this.boxRenderer.setIcon(block.getIconTB(meta));
            if (connectZNeg) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.5, yN, 0.0, 0.5, yP, 0.5);
            }
            if (connectZPos) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.5, yN, 0.5, 0.5, yP, 1.0);
            }
            if (connectXNeg) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.0, yN, 0.5, 0.5, yP, 0.5);
            }
            if (connectXPos) {
                this.boxRenderer.renderSolidBox(world, block, x, y, z, 0.5, yN, 0.5, 1.0, yP, 0.5);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.fenceRenderID;
    }
}

