/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer;

import com.jaquadro.minecraft.gardencore.api.block.IChain;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import com.jaquadro.minecraft.gardenstuff.block.BlockCandelabra;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityCandelabra;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CandelabraRenderer
implements ISimpleBlockRenderingHandler {
    private ModularBoxRenderer boxrender = new ModularBoxRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockCandelabra)) {
            return;
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.renderInventoryBlock((BlockCandelabra)block, metadata, modelId, renderer);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private void renderInventoryBlock(BlockCandelabra block, int metadata, int modelId, RenderBlocks renderer) {
        int level = metadata;
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
        this.renderCandle(renderer.field_147845_a, block, metadata);
        if (level >= 1) {
            RenderHelper.instance.state.setRenderOffset(-0.34375, 0.0, 0.0);
            this.renderCandle(renderer.field_147845_a, block, metadata);
            RenderHelper.instance.state.setRenderOffset(0.34375, 0.0, 0.0);
            this.renderCandle(renderer.field_147845_a, block, metadata);
        }
        if (level >= 2) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, -0.34375);
            this.renderCandle(renderer.field_147845_a, block, metadata);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.34375);
            this.renderCandle(renderer.field_147845_a, block, metadata);
        }
        RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
        RenderHelper.instance.renderCrossedSquares((Block)block, metadata, block.getIconBase());
        if (level >= 1) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.5, 1.0, 1.0, 1.0);
            RenderHelper.instance.renderFace(2, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
            RenderHelper.instance.state.setRenderOffset(0.5, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
            RenderHelper.instance.renderFace(3, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.5, 0.5, 1.0, 1.0);
            RenderHelper.instance.renderFace(2, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
            RenderHelper.instance.state.setRenderOffset(-0.5, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
            RenderHelper.instance.renderFace(3, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
        }
        if (level >= 2) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, -0.5);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.5, 1.0, 1.0, 1.0);
            RenderHelper.instance.renderFace(4, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
            RenderHelper.instance.renderFace(5, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.5);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
            RenderHelper.instance.renderFace(4, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.5, 0.5, 1.0, 1.0);
            RenderHelper.instance.renderFace(5, renderer.field_147845_a, (Block)block, block.getIconArmExt(), metadata);
        }
        RenderHelper.instance.state.clearRenderOffset();
    }

    private void renderCandle(IBlockAccess world, BlockCandelabra block, int meta) {
        float unit = 0.0625f;
        RenderHelper.instance.state.setColorMult(1.0f, 0.9f, 0.8f, 0.5f);
        this.boxrender.setUnit(0.0);
        this.boxrender.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxrender.setIcon(block.getIconCandleTop(), 1);
        for (int i = 2; i < 6; ++i) {
            this.boxrender.setIcon(block.getIconCandleSide(), i);
        }
        boolean x = false;
        boolean y = false;
        boolean z = false;
        this.boxrender.renderExterior(null, (Block)block, (double)x, (double)y, (double)z, unit * 6.5f, unit * 7.0f, unit * 6.5f, unit * 9.5f, unit * 13.0f, unit * 9.5f, 0, 1);
        RenderHelper.instance.state.resetColorMult();
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderHelper.instance.renderCrossedSquares((Block)block, meta, block.getIconCandleSide());
        RenderHelper.instance.setRenderBounds(unit * 5.75f, 0.0, unit * 5.75f, unit * 10.25f, unit * 7.0f, unit * 10.25f);
        RenderHelper.instance.renderFace(1, world, (Block)block, ModBlocks.metalBlock.func_149691_a(0, 0), meta);
        RenderHelper.instance.setRenderBounds(unit * 5.75f, unit * 7.0f, unit * 5.75f, unit * 10.25f, 1.0, unit * 10.25f);
        RenderHelper.instance.renderFace(0, world, (Block)block, ModBlocks.metalBlock.func_149691_a(0, 0), meta);
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderHelper.instance.renderCrossedSquares((Block)block, meta, block.getIconHolderSide());
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockCandelabra)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockCandelabra)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockCandelabra block, int modelId, RenderBlocks renderer) {
        TileEntityCandelabra tile = (TileEntityCandelabra)world.func_147438_o(x, y, z);
        if (tile == null) {
            return false;
        }
        RenderHelper.instance.setColorAndBrightness(world, (Block)block, x, y, z);
        RenderHelper.instance.state.setRotateTransform(2, tile.getDirection());
        if (tile.isSconce()) {
            this.renderSconce(world, x, y, z, block, tile.getLevel());
        } else {
            this.renderCandelabra(world, x, y, z, block, tile.getLevel());
        }
        RenderHelper.instance.state.clearRotateTransform();
        return true;
    }

    private void renderCandle(IBlockAccess world, BlockCandelabra block, int x, int y, int z) {
        float unit = 0.0625f;
        RenderHelper.instance.state.setColorMult(1.0f, 0.9f, 0.8f, 0.5f);
        this.boxrender.setUnit(0.0);
        this.boxrender.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxrender.setIcon(block.getIconCandleTop(), 1);
        for (int i = 2; i < 6; ++i) {
            this.boxrender.setIcon(block.getIconCandleSide(), i);
        }
        this.boxrender.renderExterior(world, (Block)block, x, y, z, unit * 6.5f, unit * 7.0f, unit * 6.5f, unit * 9.5f, unit * 13.0f, unit * 9.5f, 0, 1);
        RenderHelper.instance.state.resetColorMult();
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderHelper.instance.renderCrossedSquares(world, (Block)block, x, y, z, block.getIconCandleSide());
        RenderHelper.instance.setRenderBounds(unit * 5.75f, 0.0, unit * 5.75f, unit * 10.25f, unit * 7.0f, unit * 10.25f);
        RenderHelper.instance.renderFace(1, world, (Block)block, x, y, z, ModBlocks.metalBlock.func_149691_a(0, 0));
        RenderHelper.instance.setRenderBounds(unit * 5.75f, unit * 7.0f, unit * 5.75f, unit * 10.25f, 1.0, unit * 10.25f);
        RenderHelper.instance.renderFace(0, world, (Block)block, x, y, z, ModBlocks.metalBlock.func_149691_a(0, 0));
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderHelper.instance.drawCrossedSquares(block.getIconHolderSide(), x, y, z, 1.0f);
    }

    private void renderCandelabra(IBlockAccess world, int x, int y, int z, BlockCandelabra block, int level) {
        Block blockUpper = world.func_147439_a(x, y + 1, z);
        boolean hanging = level > 0 && (blockUpper instanceof IChain || blockUpper.isSideSolid(world, x, y + 1, z, ForgeDirection.DOWN));
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (!hanging) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0625, 0.0);
            this.renderCandle(world, block, x, y, z);
        }
        if (level >= 1) {
            RenderHelper.instance.state.setRenderOffset(-0.34375, 0.0, 0.0);
            this.renderCandle(world, block, x, y, z);
            RenderHelper.instance.state.setRenderOffset(0.34375, 0.0, 0.0);
            this.renderCandle(world, block, x, y, z);
        }
        if (level >= 2) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, -0.34375);
            this.renderCandle(world, block, x, y, z);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.34375);
            this.renderCandle(world, block, x, y, z);
        }
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
        if (hanging) {
            RenderHelper.instance.drawCrossedSquares(block.getIconHang(), x, y, z, 1.0f);
        } else {
            RenderHelper.instance.drawCrossedSquares(block.getIconBase(), x, y, z, 1.0f);
        }
        if (level >= 1) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.5, 1.0, 1.0, 1.0);
            RenderHelper.instance.renderFace(2, world, (Block)block, x, y, z, block.getIconArmExt());
            RenderHelper.instance.state.setRenderOffset(0.5, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
            RenderHelper.instance.renderFace(3, world, (Block)block, x, y, z, block.getIconArmExt());
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.5, 0.5, 1.0, 1.0);
            RenderHelper.instance.renderFace(2, world, (Block)block, x, y, z, block.getIconArmExt());
            RenderHelper.instance.state.setRenderOffset(-0.5, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
            RenderHelper.instance.renderFace(3, world, (Block)block, x, y, z, block.getIconArmExt());
        }
        if (level >= 2) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, -0.5);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.5, 1.0, 1.0, 1.0);
            RenderHelper.instance.renderFace(4, world, (Block)block, x, y, z, block.getIconArmExt());
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
            RenderHelper.instance.renderFace(5, world, (Block)block, x, y, z, block.getIconArmExt());
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.5);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
            RenderHelper.instance.renderFace(4, world, (Block)block, x, y, z, block.getIconArmExt());
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.0);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.5, 0.5, 1.0, 1.0);
            RenderHelper.instance.renderFace(5, world, (Block)block, x, y, z, block.getIconArmExt());
        }
        RenderHelper.instance.state.clearRenderOffset();
    }

    private void renderSconce(IBlockAccess world, int x, int y, int z, BlockCandelabra block, int level) {
        IIcon centerArmIcon = level == 0 ? block.getIconArm() : block.getIconArmExt();
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (level == 0) {
            RenderHelper.instance.state.setRenderOffset(0.0, -0.005f, -0.25);
            this.renderCandle(world, block, x, y, z);
        }
        if (level == 1 || level == 2) {
            RenderHelper.instance.state.setRenderOffset(-0.25, -0.005f, -0.25);
            this.renderCandle(world, block, x, y, z);
            RenderHelper.instance.state.setRenderOffset(0.25, -0.005f, -0.25);
            this.renderCandle(world, block, x, y, z);
        }
        if (level == 2) {
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, -0.125);
            this.renderCandle(world, block, x, y, z);
        }
        if (level == 1 || level == 2) {
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
            RenderHelper.instance.state.setRenderOffset(0.5, 0.0, 0.0);
            RenderHelper.instance.drawCrossedSquaresBounded(block.getIconArm(), x, y, z, 1.0f);
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
            RenderHelper.instance.state.setRenderOffset(-0.5, 0.0, 0.0);
            RenderHelper.instance.drawCrossedSquaresBounded(block.getIconArm(), x, y, z, 1.0f);
        }
        if (level == 0 || level == 2) {
            RenderHelper.instance.setRenderBounds(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.03125);
            RenderHelper.instance.renderFace(4, world, (Block)block, x, y, z, centerArmIcon);
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
            RenderHelper.instance.state.setRenderOffset(0.0, 0.0, 0.03125);
            RenderHelper.instance.state.flipTexture = true;
            RenderHelper.instance.renderFace(5, world, (Block)block, x, y, z, centerArmIcon);
            RenderHelper.instance.state.flipTexture = false;
        }
        RenderHelper.instance.setRenderBounds(0.375, 0.0625, 0.0, 0.625, 0.375, 0.0625);
        RenderHelper.instance.state.clearRenderOffset();
        RenderHelper.instance.renderBlock(world, ModBlocks.metalBlock, x, y, z);
        RenderHelper.instance.state.clearRenderOffset();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.sconceRenderID;
    }
}

