/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.integration.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.jaquadro.minecraft.gardenstuff.client.gui.GuiBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.core.ModItems;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class BloomeryFurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBloomeryFurnace.class;
    }

    public String getGuiTexture() {
        return "GardenStuff:textures/gui/bloomery_furnace.png";
    }

    public String getRecipeName() {
        return NEIClientUtils.translate((String)"recipe.gardenstuff.bloomeryFurnace", (Object[])new Object[0]);
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null || afuels.isEmpty()) {
            BloomeryFurnaceRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("bloomerySmelting") && ((Object)((Object)this)).getClass() == BloomeryFurnaceRecipeHandler.class) {
            this.arecipes.add(new SmeltingPair(new ItemStack(Items.field_151042_j), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ModItems.wroughtIronIngot)));
            this.arecipes.add(new SmeltingPair(new ItemStack(Blocks.field_150366_p), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ModItems.wroughtIronIngot)));
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (NEIServerUtils.areStacksSameType((ItemStack)new ItemStack(ModItems.wroughtIronIngot), (ItemStack)result)) {
            this.arecipes.add(new SmeltingPair(new ItemStack(Items.field_151042_j), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ModItems.wroughtIronIngot)));
            this.arecipes.add(new SmeltingPair(new ItemStack(Blocks.field_150366_p), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ModItems.wroughtIronIngot)));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        SmeltingPair arecipe;
        ItemStack[] primary = new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150366_p)};
        ItemStack[] secondary = new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m)};
        for (ItemStack stack : primary) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
            for (ItemStack secondaryStack : secondary) {
                arecipe = new SmeltingPair(stack, secondaryStack, new ItemStack(ModItems.wroughtIronIngot));
                arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred1), ingredient);
                this.arecipes.add(arecipe);
            }
        }
        for (ItemStack stack : secondary) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
            for (ItemStack primaryStack : primary) {
                arecipe = new SmeltingPair(primaryStack, stack, new ItemStack(ModItems.wroughtIronIngot));
                arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred2), ingredient);
                this.arecipes.add(arecipe);
            }
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        afuels.add(new FuelPair(new ItemStack(Items.field_151044_h, 1, 1), 1600));
    }

    public String getOverlayIdentifier() {
        return "bloomerySmelting";
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred1;
        PositionedStack ingred2;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred1, ItemStack ingred2, ItemStack result) {
            super((TemplateRecipeHandler)BloomeryFurnaceRecipeHandler.this);
            ingred1.field_77994_a = 1;
            ingred2.field_77994_a = 1;
            this.ingred1 = new PositionedStack((Object)ingred1, 51, 6);
            this.ingred2 = new PositionedStack((Object)ingred2, 30, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(BloomeryFurnaceRecipeHandler.this.cycleticks / 48, Arrays.asList(this.ingred1, this.ingred2));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return BloomeryFurnaceRecipeHandler.afuels.get((int)(BloomeryFurnaceRecipeHandler.this.cycleticks / 48 % BloomeryFurnaceRecipeHandler.afuels.size())).stack;
        }
    }

    private static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }
}

