/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.integration;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenstuff.GardenStuff;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import com.jaquadro.minecraft.gardenstuff.integration.lantern.FireflyLanternSource;
import com.jaquadro.minecraft.gardenstuff.integration.twilightforest.EntityFireflyWrapper;
import com.jaquadro.minecraft.gardenstuff.integration.twilightforest.RenderFireflyWrapper;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityWeatherEffect;
import net.minecraft.world.World;

public class TwilightForestIntegration {
    public static final String MOD_ID = "TwilightForest";
    static Class classEntityFirefly;
    static Class classRenderFirefly;
    public static Constructor constEntityFirefly;
    public static Constructor constRenderFirefly;
    private static boolean initialized;

    public static void init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            classEntityFirefly = Class.forName("twilightforest.entity.passive.EntityTFTinyFirefly");
            classRenderFirefly = Class.forName("twilightforest.client.renderer.entity.RenderTFTinyFirefly");
            constEntityFirefly = classEntityFirefly.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE);
            constRenderFirefly = classRenderFirefly.getConstructor(new Class[0]);
            if (GardenStuff.proxy instanceof ClientProxy) {
                TwilightForestIntegration.registerEntity();
            }
            Block blockFirefly = GameRegistry.findBlock((String)MOD_ID, (String)"tile.TFFirefly");
            FireflyLanternSource fireflySource = new FireflyLanternSource(blockFirefly);
            GardenAPI.instance().registries().lanternSources().registerLanternSource(fireflySource);
            initialized = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerEntity() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFireflyWrapper.class, (Render)new RenderFireflyWrapper());
    }

    public static boolean isLoaded() {
        return initialized;
    }

    public static void doFireflyEffect(World world, int x, int y, int z, Random rand) {
        try {
            for (int i = 0; i < 2; ++i) {
                double dx = (float)x + ((rand.nextFloat() - rand.nextFloat()) * 0.3f + 0.5f);
                double dy = (float)y + ((rand.nextFloat() - rand.nextFloat()) * 0.4f - 0.05f);
                double dz = (float)z + ((rand.nextFloat() - rand.nextFloat()) * 0.3f + 0.5f);
                EntityWeatherEffect tinyfly = (EntityWeatherEffect)constEntityFirefly.newInstance(world, dx, dy, dz);
                world.func_72838_d((Entity)tinyfly);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

