/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardencore.api.block.IChain;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHeavyChain
extends Block
implements IChain {
    public static final String[] types = new String[]{"iron", "gold", "rope", "rust", "wrought_iron", "moss"};
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] icons;

    public BlockHeavyChain(String blockName) {
        super(Material.field_151573_f);
        this.func_149663_c(blockName);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f);
        this.func_149658_d("GardenStuff:chain_heavy");
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.heavyChainRenderID;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public int func_149692_a(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)(types.length - 1));
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147460_e(x, y + 1, z, (Block)this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (block == this || block == ModBlocks.lantern) {
            world.func_147460_e(x, y + 1, z, (Block)this);
        }
        if (world.func_147439_a(x, y + 1, z) != this) {
            world.func_147460_e(x, y + 2, z, (Block)this);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149748_c(world, x, y, z, side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        if (side != 0) {
            return 0;
        }
        for (int i = 1; i <= 8 && y - i > 0; ++i) {
            Block block = world.func_147439_a(x, y - i, z);
            if (block == this) continue;
            return block.func_149709_b(world, x, y - i, z, side);
        }
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        return icons[MathHelper.func_76125_a((int)meta, (int)0, (int)(types.length - 1))];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        icons = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            BlockHeavyChain.icons[i] = register.func_94245_a(this.func_149641_N() + "_" + types[i]);
        }
    }

    @Override
    public boolean isMultiAttach() {
        return false;
    }
}

